/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap;

import edu.vt.middleware.ldap.LdapAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LdapEntry {
    private static final Log LOG = LogFactory.getLog(LdapEntry.class);
    private String dn;
    private Map attributes = new HashMap();

    public LdapEntry() {
    }

    public LdapEntry(String dn) {
        this.dn = dn;
    }

    public String getDn() {
        return this.dn;
    }

    public List getAttributes() {
        return new ArrayList(this.attributes.values());
    }

    public LdapAttribute getAttribute(String name) {
        return (LdapAttribute)this.attributes.get(name);
    }

    public void setDn(String dn) {
        this.dn = dn;
    }

    public void addAttribute(LdapAttribute a) {
        this.attributes.put(a.getName(), a);
    }

    public void addAttribute(String name, Object value) {
        this.attributes.put(name, new LdapAttribute(name, value));
    }

    public void addAttribute(String name, List values) {
        this.attributes.put(name, new LdapAttribute(name, values));
    }

    public void addAttributes(List l) {
        for (LdapAttribute a : l) {
            this.attributes.put(a.getName(), a);
        }
    }

    public void addAttributes(Map m) {
        for (String name : m.keySet()) {
            Object value = m.get(name);
            if (value instanceof List) {
                this.addAttribute(name, (List)value);
                continue;
            }
            this.addAttribute(name, value);
        }
    }

    public void clear() {
        this.attributes.clear();
    }
}

