/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.profile;

import edu.internet2.middleware.shibboleth.common.log.AuditLogEntry;
import edu.internet2.middleware.shibboleth.common.profile.ProfileException;
import edu.internet2.middleware.shibboleth.common.profile.provider.AbstractShibbolethProfileHandler;
import edu.internet2.middleware.shibboleth.common.profile.provider.BaseSAMLProfileRequestContext;
import edu.internet2.middleware.shibboleth.common.relyingparty.ProfileConfiguration;
import edu.internet2.middleware.shibboleth.common.relyingparty.RelyingPartyConfiguration;
import edu.internet2.middleware.shibboleth.common.relyingparty.RelyingPartyConfigurationManager;
import edu.internet2.middleware.shibboleth.common.relyingparty.RelyingPartySecurityPolicyResolver;
import edu.internet2.middleware.shibboleth.common.relyingparty.provider.AbstractSAMLProfileConfiguration;
import edu.internet2.middleware.shibboleth.common.relyingparty.provider.CryptoOperationRequirementLevel;
import edu.internet2.middleware.shibboleth.common.relyingparty.provider.SAMLMDRelyingPartyConfigurationManager;
import edu.internet2.middleware.shibboleth.idp.session.Session;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.opensaml.common.IdentifierGenerator;
import org.opensaml.common.binding.decoding.SAMLMessageDecoder;
import org.opensaml.common.binding.encoding.SAMLMessageEncoder;
import org.opensaml.saml2.metadata.AttributeAuthorityDescriptor;
import org.opensaml.saml2.metadata.AuthnAuthorityDescriptor;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.NameIDFormat;
import org.opensaml.saml2.metadata.PDPDescriptor;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.SSODescriptor;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.ws.security.SecurityPolicyResolver;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.ws.transport.http.HttpServletRequestAdapter;
import org.opensaml.xml.security.credential.Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSAMLProfileHandler
extends AbstractShibbolethProfileHandler<SAMLMDRelyingPartyConfigurationManager, Session> {
    private final Logger auditLog = LoggerFactory.getLogger((String)"Shibboleth-Audit");
    private final Logger log = LoggerFactory.getLogger(AbstractSAMLProfileHandler.class);
    private IdentifierGenerator idGenerator;
    private Map<String, SAMLMessageDecoder> messageDecoders;
    private Map<String, SAMLMessageEncoder> messageEncoders;
    private String inboundBinding;
    private List<String> supportedOutboundBindings;
    private SecurityPolicyResolver securityPolicyResolver;

    protected AbstractSAMLProfileHandler() {
    }

    public SecurityPolicyResolver getSecurityPolicyResolver() {
        if (this.securityPolicyResolver == null) {
            this.setSecurityPolicyResolver((SecurityPolicyResolver)new RelyingPartySecurityPolicyResolver((RelyingPartyConfigurationManager)this.getRelyingPartyConfigurationManager()));
        }
        return this.securityPolicyResolver;
    }

    public void setSecurityPolicyResolver(SecurityPolicyResolver resolver) {
        this.securityPolicyResolver = resolver;
    }

    protected Logger getAduitLog() {
        return this.auditLog;
    }

    public IdentifierGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public String getInboundBinding() {
        return this.inboundBinding;
    }

    public Map<String, SAMLMessageDecoder> getMessageDecoders() {
        return this.messageDecoders;
    }

    public Map<String, SAMLMessageEncoder> getMessageEncoders() {
        return this.messageEncoders;
    }

    public MetadataProvider getMetadataProvider() {
        SAMLMDRelyingPartyConfigurationManager rpcManager = this.getRelyingPartyConfigurationManager();
        if (rpcManager != null) {
            return rpcManager.getMetadataProvider();
        }
        return null;
    }

    public List<String> getSupportedOutboundBindings() {
        return this.supportedOutboundBindings;
    }

    protected Session getUserSession(InTransport inTransport) {
        HttpServletRequest rawRequest = ((HttpServletRequestAdapter)inTransport).getWrappedRequest();
        return (Session)rawRequest.getAttribute("ShibbolethIdPSession");
    }

    protected Session getUserSession(String principalName) {
        return (Session)this.getSessionManager().getSession(principalName);
    }

    public void setIdGenerator(IdentifierGenerator generator) {
        this.idGenerator = generator;
    }

    public void setInboundBinding(String binding) {
        this.inboundBinding = binding;
    }

    public void setMessageDecoders(Map<String, SAMLMessageDecoder> decoders) {
        this.messageDecoders = decoders;
    }

    public void setMessageEncoders(Map<String, SAMLMessageEncoder> encoders) {
        this.messageEncoders = encoders;
    }

    public void setSupportedOutboundBindings(List<String> bindings) {
        this.supportedOutboundBindings = bindings;
    }

    public RelyingPartyConfiguration getRelyingPartyConfiguration(String relyingPartyId) {
        try {
            if (this.getMetadataProvider().getEntityDescriptor(relyingPartyId) == null) {
                this.log.warn("No metadata for relying party {}, treating party as anonymous", (Object)relyingPartyId);
                return this.getRelyingPartyConfigurationManager().getAnonymousRelyingConfiguration();
            }
        }
        catch (MetadataProviderException e) {
            this.log.error("Unable to look up relying party metadata", (Throwable)e);
            return null;
        }
        return super.getRelyingPartyConfiguration(relyingPartyId);
    }

    protected void populateRequestContext(BaseSAMLProfileRequestContext requestContext) throws ProfileException {
        this.populateRelyingPartyInformation(requestContext);
        this.populateAssertingPartyInformation(requestContext);
        this.populateSAMLMessageInformation(requestContext);
        this.populateProfileInformation(requestContext);
        this.populateUserInformation(requestContext);
    }

    protected void populateRelyingPartyInformation(BaseSAMLProfileRequestContext requestContext) throws ProfileException {
        MetadataProvider metadataProvider = requestContext.getMetadataProvider();
        String relyingPartyId = requestContext.getInboundMessageIssuer();
        try {
            EntityDescriptor relyingPartyMetadata = metadataProvider.getEntityDescriptor(relyingPartyId);
            requestContext.setPeerEntityMetadata(relyingPartyMetadata);
        }
        catch (MetadataProviderException e) {
            this.log.error("Error looking up metadata for relying party " + relyingPartyId, (Throwable)e);
            throw new ProfileException("Error looking up metadata for relying party " + relyingPartyId);
        }
        RelyingPartyConfiguration rpConfig = this.getRelyingPartyConfiguration(relyingPartyId);
        if (rpConfig == null) {
            this.log.error("Unable to retrieve relying party configuration data for entity with ID {}", (Object)relyingPartyId);
            throw new ProfileException("Unable to retrieve relying party configuration data for entity with ID " + relyingPartyId);
        }
        requestContext.setRelyingPartyConfiguration(rpConfig);
    }

    protected void populateAssertingPartyInformation(BaseSAMLProfileRequestContext requestContext) throws ProfileException {
        String assertingPartyId = requestContext.getRelyingPartyConfiguration().getProviderId();
        requestContext.setLocalEntityId(assertingPartyId);
        requestContext.setOutboundMessageIssuer(assertingPartyId);
        try {
            EntityDescriptor localEntityDescriptor = requestContext.getMetadataProvider().getEntityDescriptor(assertingPartyId);
            if (localEntityDescriptor != null) {
                requestContext.setLocalEntityMetadata(localEntityDescriptor);
            }
        }
        catch (MetadataProviderException e) {
            this.log.error("Error looking up metadata for asserting party " + assertingPartyId, (Throwable)e);
            throw new ProfileException("Error looking up metadata for asserting party " + assertingPartyId);
        }
    }

    protected abstract void populateSAMLMessageInformation(BaseSAMLProfileRequestContext var1) throws ProfileException;

    protected void populateProfileInformation(BaseSAMLProfileRequestContext requestContext) throws ProfileException {
        Endpoint endpoint;
        AbstractSAMLProfileConfiguration profileConfig = (AbstractSAMLProfileConfiguration)requestContext.getRelyingPartyConfiguration().getProfileConfiguration(this.getProfileId());
        if (profileConfig != null) {
            requestContext.setProfileConfiguration((ProfileConfiguration)profileConfig);
            requestContext.setOutboundMessageArtifactType(profileConfig.getOutboundArtifactType());
        }
        if ((endpoint = this.selectEndpoint(requestContext)) == null) {
            this.log.error("No return endpoint available for relying party {}", (Object)requestContext.getInboundMessageIssuer());
            throw new ProfileException("No peer endpoint available to which to send SAML response");
        }
        requestContext.setPeerEntityEndpoint(endpoint);
    }

    protected List<String> getNameFormats(BaseSAMLProfileRequestContext requestContext) throws ProfileException {
        List<String> relyingPartySupportedFormats;
        ArrayList<String> nameFormats = new ArrayList<String>();
        RoleDescriptor relyingPartyRole = requestContext.getPeerEntityRoleMetadata();
        if (relyingPartyRole != null && (relyingPartySupportedFormats = this.getEntitySupportedFormats(relyingPartyRole)) != null && !relyingPartySupportedFormats.isEmpty()) {
            nameFormats.addAll(relyingPartySupportedFormats);
        }
        if (nameFormats.contains("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified")) {
            nameFormats.clear();
        }
        return nameFormats;
    }

    protected List<String> getEntitySupportedFormats(RoleDescriptor role) {
        List nameIDFormats = null;
        if (role instanceof SSODescriptor) {
            nameIDFormats = ((SSODescriptor)role).getNameIDFormats();
        } else if (role instanceof AuthnAuthorityDescriptor) {
            nameIDFormats = ((AuthnAuthorityDescriptor)role).getNameIDFormats();
        } else if (role instanceof PDPDescriptor) {
            nameIDFormats = ((PDPDescriptor)role).getNameIDFormats();
        } else if (role instanceof AttributeAuthorityDescriptor) {
            nameIDFormats = ((AttributeAuthorityDescriptor)role).getNameIDFormats();
        }
        ArrayList<String> supportedFormats = new ArrayList<String>();
        if (nameIDFormats != null) {
            for (NameIDFormat format : nameIDFormats) {
                supportedFormats.add(format.getFormat());
            }
        }
        return supportedFormats;
    }

    protected abstract void populateUserInformation(BaseSAMLProfileRequestContext var1) throws ProfileException;

    protected abstract Endpoint selectEndpoint(BaseSAMLProfileRequestContext var1) throws ProfileException;

    protected void encodeResponse(BaseSAMLProfileRequestContext requestContext) throws ProfileException {
        try {
            SAMLMessageEncoder encoder = this.getOutboundMessageEncoder(requestContext);
            AbstractSAMLProfileConfiguration profileConfig = (AbstractSAMLProfileConfiguration)requestContext.getProfileConfiguration();
            if (profileConfig != null && this.isSignResponse(requestContext)) {
                Credential signingCredential = profileConfig.getSigningCredential();
                if (signingCredential == null) {
                    signingCredential = requestContext.getRelyingPartyConfiguration().getDefaultSigningCredential();
                }
                if (signingCredential == null) {
                    throw new ProfileException("Signing of responses is required but no signing credential is available");
                }
                if (signingCredential.getPrivateKey() == null) {
                    throw new ProfileException("Signing of response is required but signing credential does not have a private key");
                }
                requestContext.setOutboundSAMLMessageSigningCredential(signingCredential);
            }
            this.log.debug("Encoding response to SAML request {} from relying party {}", (Object)requestContext.getInboundSAMLMessageId(), (Object)requestContext.getInboundMessageIssuer());
            requestContext.setMessageEncoder(encoder);
            encoder.encode((MessageContext)requestContext);
        }
        catch (MessageEncodingException e) {
            throw new ProfileException("Unable to encode response to relying party: " + requestContext.getInboundMessageIssuer(), (Exception)((Object)e));
        }
    }

    protected boolean isSignResponse(BaseSAMLProfileRequestContext requestContext) throws ProfileException {
        SAMLMessageEncoder encoder = this.getOutboundMessageEncoder(requestContext);
        AbstractSAMLProfileConfiguration profileConfig = (AbstractSAMLProfileConfiguration)requestContext.getProfileConfiguration();
        if (profileConfig != null) {
            try {
                return profileConfig.getSignResponses() == CryptoOperationRequirementLevel.always || profileConfig.getSignResponses() == CryptoOperationRequirementLevel.conditional && !encoder.providesMessageIntegrity((MessageContext)requestContext);
            }
            catch (MessageEncodingException e) {
                this.log.error("Unable to determine if outbound encoding '{}' provides message integrity protection", (Object)encoder.getBindingURI());
                throw new ProfileException("Unable to determine if outbound response should be signed");
            }
        }
        return false;
    }

    protected SAMLMessageEncoder getOutboundMessageEncoder(BaseSAMLProfileRequestContext requestContext) throws ProfileException {
        SAMLMessageEncoder encoder = null;
        Endpoint endpoint = requestContext.getPeerEntityEndpoint();
        if (endpoint == null) {
            this.log.warn("No peer endpoint available for peer. Unable to send response.");
            throw new ProfileException("No peer endpoint available for peer. Unable to send response.");
        }
        if (endpoint != null && (encoder = this.getMessageEncoders().get(endpoint.getBinding())) == null) {
            this.log.error("No outbound message encoder configured for binding: {}", (Object)requestContext.getPeerEntityEndpoint().getBinding());
            throw new ProfileException("No outbound message encoder configured for binding: " + requestContext.getPeerEntityEndpoint().getBinding());
        }
        return encoder;
    }

    protected SAMLMessageDecoder getInboundMessageDecoder(BaseSAMLProfileRequestContext requestContext) throws ProfileException {
        SAMLMessageDecoder decoder = null;
        decoder = this.getMessageDecoders().get(this.getInboundBinding());
        if (decoder == null) {
            this.log.error("No inbound message decoder configured for binding: {}", (Object)this.getInboundBinding());
            throw new ProfileException("No inbound message decoder configured for binding: " + this.getInboundBinding());
        }
        return decoder;
    }

    protected void writeAuditLogEntry(BaseSAMLProfileRequestContext context) {
        AuditLogEntry auditLogEntry = new AuditLogEntry();
        auditLogEntry.setMessageProfile(this.getProfileId());
        auditLogEntry.setPrincipalAuthenticationMethod(context.getPrincipalAuthenticationMethod());
        auditLogEntry.setPrincipalName(context.getPrincipalName());
        auditLogEntry.setAssertingPartyId(context.getLocalEntityId());
        auditLogEntry.setRelyingPartyId(context.getInboundMessageIssuer());
        auditLogEntry.setRequestBinding(context.getMessageDecoder().getBindingURI());
        auditLogEntry.setRequestId(context.getInboundSAMLMessageId());
        auditLogEntry.setResponseBinding(context.getMessageEncoder().getBindingURI());
        auditLogEntry.setResponseId(context.getOutboundSAMLMessageId());
        if (context.getReleasedAttributes() != null) {
            auditLogEntry.getReleasedAttributes().addAll(context.getReleasedAttributes());
        }
        this.getAduitLog().info(auditLogEntry.toString());
    }
}

