/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.authn.provider;

import edu.internet2.middleware.shibboleth.idp.authn.AuthenticationEngine;
import edu.internet2.middleware.shibboleth.idp.authn.provider.AbstractLoginHandler;
import edu.internet2.middleware.shibboleth.idp.session.Session;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreviousSessionLoginHandler
extends AbstractLoginHandler {
    private final Logger log = LoggerFactory.getLogger(PreviousSessionLoginHandler.class);
    private String servletPath = null;
    private boolean reportPreviousSessionAuthnMethod;

    public PreviousSessionLoginHandler() {
        this.setSupportsPassive(true);
        this.setSupportsForceAuthentication(false);
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public void setServletPath(String path) {
        this.servletPath = DatatypeHelper.safeTrimOrNullString((String)path);
    }

    public boolean reportPreviousSessionAuthnMethod() {
        return this.reportPreviousSessionAuthnMethod;
    }

    public void setReportPreviousSessionAuthnMethod(boolean report) {
        this.reportPreviousSessionAuthnMethod = report;
    }

    public boolean supportsPassive() {
        if (this.servletPath == null) {
            return true;
        }
        return super.supportsPassive();
    }

    public void login(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        Session idpSession;
        if (this.reportPreviousSessionAuthnMethod) {
            httpRequest.setAttribute("authnMethod", (Object)"urn:oasis:names:tc:SAML:2.0:ac:classes:PreviousSession");
        }
        if ((idpSession = (Session)httpRequest.getAttribute("ShibbolethIdPSession")) == null) {
            this.log.warn("No existing IdP session available.");
            httpRequest.setAttribute("authnError", (Object)"No existing IdP session available");
        } else {
            this.log.debug("Using existing IdP session for {}", (Object)idpSession.getPrincipalName());
            httpRequest.setAttribute("principal_name", (Object)idpSession.getPrincipalName());
        }
        AuthenticationEngine.returnToAuthenticationEngine(httpRequest, httpResponse);
    }
}

