/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.ant.pki;

import edu.internet2.middleware.ant.pki.RdnConverter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.asn1.x509.X509NameEntryConverter;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import org.bouncycastle.x509.extension.SubjectKeyIdentifierStructure;

public class SelfSignedCertificate
extends Task {
    private String keyType = "RSA";
    private int keysize = 2048;
    private String hostname;
    private String[] dnsSubjectAltNames;
    private String[] uriSubjectAltNames;
    private File privateKeyFile;
    private File certificateFile;
    private File keystoreFile;
    private String keystorePassword;

    public void execute() throws BuildException {
        this.validate();
        KeyPair keypair = this.generateKeyPair();
        X509Certificate certificate = this.generateCertificate(keypair);
        if (this.privateKeyFile != null) {
            try {
                this.privateKeyFile.createNewFile();
                PEMWriter keyOut = new PEMWriter((Writer)new FileWriter(this.privateKeyFile));
                keyOut.writeObject((Object)keypair.getPrivate());
                keyOut.flush();
                keyOut.close();
            }
            catch (Exception e) {
                throw new BuildException("Unable to create private key file.", (Throwable)e);
            }
        }
        if (this.certificateFile != null) {
            try {
                this.certificateFile.createNewFile();
                PEMWriter certOut = new PEMWriter((Writer)new FileWriter(this.certificateFile));
                certOut.writeObject((Object)certificate);
                certOut.flush();
                certOut.close();
            }
            catch (Exception e) {
                throw new BuildException("Unable to create private key file.", (Throwable)e);
            }
        }
        if (this.keystoreFile != null) {
            try {
                KeyStore store = KeyStore.getInstance("JKS");
                store.load(null, null);
                store.setKeyEntry(this.hostname, keypair.getPrivate(), this.keystorePassword.toCharArray(), new X509Certificate[]{certificate});
                FileOutputStream keystoreOut = new FileOutputStream(this.keystoreFile);
                store.store(keystoreOut, this.keystorePassword.toCharArray());
                keystoreOut.flush();
                keystoreOut.close();
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
        }
    }

    public void setKeyType(KeyType type) {
        this.keyType = type.getValue();
    }

    public void setKeysize(int size) {
        this.keysize = size;
    }

    public void setHostName(String name) {
        this.hostname = name;
    }

    public void setPrivateKeyFile(File file) {
        this.privateKeyFile = file;
    }

    public void setCertificateFile(File file) {
        this.certificateFile = file;
    }

    public void setKeystoreFile(File file) {
        this.keystoreFile = file;
    }

    public void setKeystorePassword(String password) {
        this.keystorePassword = password;
    }

    public void setDnsSubjectAltNames(String altNames) {
        this.dnsSubjectAltNames = altNames.split(" ");
    }

    public void setUriSubjectAltNames(String altNames) {
        this.uriSubjectAltNames = altNames.split(" ");
    }

    protected void validate() throws BuildException {
        if (this.keysize > 2048) {
            this.log("Key size is greater than 2048, this may cause problems with some JVMs", 1);
        }
        if (this.hostname == null || this.hostname.length() == 0) {
            throw new BuildException("The hostname attribute is required and may not contain an empty value");
        }
        if (this.keystoreFile != null && (this.keystorePassword == null || this.keystorePassword.length() == 0)) {
            throw new BuildException("Keystore password may not be null if a keystore file is given");
        }
    }

    protected KeyPair generateKeyPair() throws BuildException {
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance(this.keyType);
            generator.initialize(this.keysize);
            return generator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new BuildException("The " + this.keyType + " key type is not supported by this JVM");
        }
    }

    protected X509Certificate generateCertificate(KeyPair keypair) throws BuildException {
        try {
            X509V3CertificateGenerator certifcateGenerator = new X509V3CertificateGenerator();
            certifcateGenerator.setPublicKey(keypair.getPublic());
            StringBuffer dnBuffer = new StringBuffer("CN=").append(this.hostname);
            X509Name dn = new X509Name(false, dnBuffer.toString(), (X509NameEntryConverter)new RdnConverter());
            certifcateGenerator.setIssuerDN(dn);
            certifcateGenerator.setSubjectDN(dn);
            GregorianCalendar date = new GregorianCalendar();
            certifcateGenerator.setNotBefore(date.getTime());
            date.set(1, date.get(1) + 20);
            certifcateGenerator.setNotAfter(date.getTime());
            certifcateGenerator.setSerialNumber(new BigInteger(160, new SecureRandom()));
            certifcateGenerator.setSignatureAlgorithm("SHA1withRSA");
            certifcateGenerator.addExtension(X509Extensions.SubjectAlternativeName, false, (DEREncodable)new GeneralNames((ASN1Sequence)new DERSequence(this.buildSubjectAltNames())));
            certifcateGenerator.addExtension(X509Extensions.SubjectKeyIdentifier, false, (DEREncodable)new SubjectKeyIdentifierStructure(keypair.getPublic()));
            return certifcateGenerator.generate(keypair.getPrivate());
        }
        catch (Exception e) {
            this.log(e.toString(), 0);
            throw new BuildException("Unable to generate self-signed certificate", (Throwable)e);
        }
    }

    protected ASN1Encodable[] buildSubjectAltNames() {
        ArrayList<GeneralName> subjectAltNames = new ArrayList<GeneralName>();
        subjectAltNames.add(new GeneralName(2, this.hostname));
        if (this.dnsSubjectAltNames != null) {
            for (String subjectAltName : this.dnsSubjectAltNames) {
                subjectAltNames.add(new GeneralName(2, subjectAltName));
            }
        }
        if (this.uriSubjectAltNames != null) {
            for (String subjectAltName : this.uriSubjectAltNames) {
                subjectAltNames.add(new GeneralName(6, subjectAltName));
            }
        }
        return subjectAltNames.toArray(new ASN1Encodable[0]);
    }

    public static class KeyType
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"DSA", "RSA"};
        }
    }
}

