/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.servlets.session;

import edu.vt.middleware.ldap.servlets.session.SessionManager;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultSessionManager
extends SessionManager {
    private static final Log LOG = LogFactory.getLog(DefaultSessionManager.class);

    public void login(HttpSession session, String user) throws ServletException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Begin login method");
        }
        if (this.sessionId != null) {
            session.setAttribute(this.sessionId, (Object)user);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Set session attribute " + this.sessionId + " to " + user));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Could not set session attribute, value is null");
        }
    }

    public void logout(HttpSession session) throws ServletException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Begin logout method");
        }
        if (this.sessionId != null) {
            String user = (String)session.getAttribute(this.sessionId);
            session.removeAttribute(this.sessionId);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Removed session attribute " + this.sessionId + " for " + user));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Could not remove session attribute, value is null");
        }
        if (this.invalidateSession) {
            session.invalidate();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Session invalidated");
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Session was not invalidated");
        }
    }
}

