/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.ldif.util;

import edu.vt.middleware.ldap.Ldap;
import edu.vt.middleware.ldap.LdapPool;
import edu.vt.middleware.ldap.ldif.util.Ldif;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class LdifSearch {
    private static final Log LOG = LogFactory.getLog(LdifSearch.class);
    private LdapPool pool;
    private Ldif ldif = new Ldif();

    public LdifSearch() {
        this.pool = new LdapPool();
    }

    public LdifSearch(String propertiesFile) {
        this.pool = new LdapPool(propertiesFile);
    }

    public void search(String query, String[] attrs, OutputStream out) throws NamingException, IOException {
        this.ldif.outputLdif(this.doSearch(query, attrs), out);
    }

    public String searchToString(String query, String[] attrs) throws NamingException, IOException {
        return this.ldif.createLdif(this.doSearch(query, attrs));
    }

    private Iterator doSearch(String query, String[] attrs) throws NamingException {
        Iterator queryResults;
        block9: {
            queryResults = null;
            if (query != null) {
                try {
                    Ldap ldap = null;
                    try {
                        ldap = (Ldap)this.pool.borrowObject();
                        queryResults = ldap.search(query, attrs);
                    }
                    catch (NamingException e) {
                        if (LOG.isErrorEnabled()) {
                            LOG.error((Object)"Error attempting LDAP search", (Throwable)e);
                        }
                        throw e;
                    }
                    finally {
                        this.pool.returnObject(ldap);
                    }
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) break block9;
                    LOG.error((Object)"Error using LDAP pool", (Throwable)e);
                }
            }
        }
        return queryResults;
    }
}

