/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.jaas;

import com.sun.security.auth.callback.TextCallbackHandler;
import edu.vt.middleware.ldap.Authenticator;
import edu.vt.middleware.ldap.Ldap;
import edu.vt.middleware.ldap.LdapProperties;
import edu.vt.middleware.ldap.LdapUtil;
import edu.vt.middleware.ldap.jaas.LdapCredential;
import edu.vt.middleware.ldap.jaas.LdapPrincipal;
import edu.vt.middleware.ldap.jaas.LdapRole;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class LdapLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean success;
    private Set principals;
    private Set credentials;
    private Authenticator auth;
    private Ldap ldap;
    private String[] userRoleAttribute;
    private String roleFilter;
    private String[] roleAttribute;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        this.principals = new TreeSet();
        this.credentials = new HashSet();
        for (String key : options.keySet()) {
            String value = (String)options.get(key);
            if (key.equalsIgnoreCase("userRoleAttribute")) {
                this.userRoleAttribute = value.split(",");
                continue;
            }
            if (!key.startsWith("role")) continue;
            if (key.equalsIgnoreCase("roleAttribute")) {
                this.roleAttribute = value.split(",");
                continue;
            }
            if (!key.equalsIgnoreCase("roleFilter")) continue;
            this.roleFilter = value;
        }
        this.auth = this.createAuthenticator(options);
        this.ldap = this.createLdap(options);
    }

    public boolean login() throws LoginException {
        try {
            NameCallback nameCb = new NameCallback("Enter user: ");
            PasswordCallback passCb = new PasswordCallback("Enter user password: ", false);
            if (this.callbackHandler != null) {
                this.callbackHandler.handle(new Callback[]{nameCb, passCb});
            }
            ArrayList roles = new ArrayList();
            if (this.userRoleAttribute != null) {
                try {
                    Attributes attrs = this.auth.authenticate(nameCb.getName(), passCb.getPassword(), this.userRoleAttribute);
                    roles.addAll(this.attributesToRoles(attrs));
                    this.success = true;
                }
                catch (AuthenticationException e) {
                    this.success = false;
                }
            } else {
                this.success = this.auth.authenticate(nameCb.getName(), passCb.getPassword());
            }
            if (!this.success) {
                throw new LoginException("Authentication failed.");
            }
            if (this.roleAttribute != null && this.roleFilter != null) {
                try {
                    Object[] filterArgs = new Object[]{this.auth.getDn(nameCb.getName()), nameCb.getName()};
                    Iterator results = this.ldap.search(this.roleFilter, filterArgs, this.roleAttribute);
                    while (results.hasNext()) {
                        SearchResult sr = (SearchResult)results.next();
                        roles.addAll(this.attributesToRoles(sr.getAttributes()));
                    }
                }
                catch (NamingException e) {
                    this.success = false;
                    throw new LoginException(e.getMessage());
                }
            }
            this.principals.add(new LdapPrincipal(nameCb.getName()));
            if (!roles.isEmpty()) {
                Iterator i = roles.iterator();
                while (i.hasNext()) {
                    this.principals.add((LdapRole)i.next());
                }
            }
            this.credentials.add(new LdapCredential(passCb.getPassword()));
        }
        catch (IOException e) {
            throw new LoginException(e.toString());
        }
        catch (UnsupportedCallbackException e) {
            throw new LoginException(e.toString());
        }
        catch (NamingException e) {
            throw new LoginException(e.toString());
        }
        finally {
            this.auth.close();
            this.ldap.close();
        }
        return true;
    }

    public boolean commit() throws LoginException {
        if (this.success) {
            if (this.subject.isReadOnly()) {
                throw new LoginException("Subject is read-only.");
            }
            this.subject.getPrincipals().addAll(this.principals);
            this.subject.getPrivateCredentials().addAll(this.credentials);
        }
        this.principals.clear();
        this.credentials.clear();
        return true;
    }

    public boolean abort() {
        this.success = false;
        this.logout();
        return true;
    }

    public boolean logout() {
        this.principals.clear();
        this.credentials.clear();
        for (LdapPrincipal p : this.subject.getPrincipals(LdapPrincipal.class)) {
            this.subject.getPrincipals().remove(p);
        }
        for (LdapRole r : this.subject.getPrincipals(LdapRole.class)) {
            this.subject.getPrincipals().remove(r);
        }
        for (LdapCredential c : this.subject.getPrivateCredentials(LdapCredential.class)) {
            this.subject.getPrivateCredentials().remove(c);
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        LoginContext lc = new LoginContext("vt-ldap", new TextCallbackHandler());
        lc.login();
        System.out.println("Authentication/Authorization succeeded");
        Set<Principal> principals = lc.getSubject().getPrincipals();
        System.out.println("Subject Principal(s): ");
        for (Principal p : principals) {
            System.out.println("  " + p.getName());
        }
        lc.logout();
    }

    private Ldap createLdap(Map options) {
        LdapProperties ldapProperties = new LdapProperties();
        for (String key : options.keySet()) {
            String value = (String)options.get(key);
            if (key.startsWith("role")) {
                if (key.equalsIgnoreCase("roleAttribute") || key.equalsIgnoreCase("roleFilter")) continue;
                String propName = key.substring("role".length(), key.length());
                StringBuffer newKey = new StringBuffer().append(Character.toLowerCase(propName.charAt(0))).append(propName.substring(1));
                ldapProperties.setProperty(newKey.toString(), value);
                continue;
            }
            if (ldapProperties.isPropertySet(key)) continue;
            ldapProperties.setProperty(key, value);
        }
        Ldap ldap = new Ldap();
        ldapProperties.initialize(ldap);
        return ldap;
    }

    private Authenticator createAuthenticator(Map options) {
        LdapProperties authProperties = new LdapProperties();
        for (String key : options.keySet()) {
            String value = (String)options.get(key);
            if (key.equalsIgnoreCase("userRoleAttribute") || key.startsWith("role")) continue;
            authProperties.setProperty(key, value);
        }
        Authenticator auth = new Authenticator();
        authProperties.initialize(auth);
        return auth;
    }

    private List attributesToRoles(Attributes attributes) throws NamingException {
        ArrayList<LdapRole> roles = new ArrayList<LdapRole>();
        Map m = LdapUtil.parseAttributes(attributes, true);
        if (!m.isEmpty()) {
            for (List l : m.values()) {
                Iterator listIter = l.iterator();
                while (listIter.hasNext()) {
                    roles.add(new LdapRole((String)listIter.next()));
                }
            }
        }
        return roles;
    }
}

