/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap;

import edu.vt.middleware.ldap.Ldap;
import edu.vt.middleware.ldap.LdapConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class LdapUtil {
    private static final Log LOG = LogFactory.getLog(LdapUtil.class);

    private LdapUtil() {
    }

    public static List deepCopySearchResults(String dn, NamingEnumeration en) throws NamingException {
        return LdapUtil.deepCopySearchResults(dn, en, true);
    }

    public static List deepCopySearchResults(String dn, NamingEnumeration en, boolean removeUrls) throws NamingException {
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        if (en != null) {
            while (en.hasMore()) {
                SearchResult sr = LdapUtil.deepCopySearchResult(dn, (SearchResult)en.next(), removeUrls);
                if (sr == null) continue;
                results.add(sr);
            }
        }
        return results;
    }

    public static SearchResult deepCopySearchResult(String dn, SearchResult sr, boolean removeUrls) {
        SearchResult fqdn;
        String resultName = sr.getName();
        if (resultName != null) {
            StringBuffer fqName = null;
            fqName = sr.isRelative() ? (dn != null ? new StringBuffer(resultName).append(",").append(dn) : new StringBuffer(resultName)) : (removeUrls ? new StringBuffer(URI.create(resultName).getPath().substring(1)) : new StringBuffer(resultName));
            fqdn = new SearchResult(fqName.toString(), sr.getClassName(), sr.getObject(), sr.getAttributes(), sr.isRelative());
        } else {
            fqdn = sr;
        }
        return fqdn;
    }

    public static List parseNamingEnumeration(NamingEnumeration en) throws NamingException {
        ArrayList results = new ArrayList();
        if (en != null) {
            while (en.hasMore()) {
                results.add(en.next());
            }
        }
        return results;
    }

    public static Iterator searchAttributesRecursive(Ldap ldap, Attributes matchAttrs) throws NamingException {
        return LdapUtil.searchAttributesRecursive(ldap, matchAttrs, null);
    }

    public static Iterator searchAttributesRecursive(Ldap ldap, Attributes matchAttrs, String[] retAttrs) throws NamingException {
        List results = LdapUtil.searchAttributesRecursive(ldap, matchAttrs, retAttrs, new ArrayList());
        return results.iterator();
    }

    private static List searchAttributesRecursive(Ldap ldap, Attributes matchAttrs, String[] retAttrs, List parentDns) throws NamingException {
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        Iterator i = ldap.searchAttributes(matchAttrs, retAttrs);
        while (i.hasNext()) {
            SearchResult sr = (SearchResult)i.next();
            results.add(sr);
            parentDns.add(sr.getName());
            if (sr == null) continue;
            Attributes attrs = sr.getAttributes();
            NamingEnumeration<? extends Attribute> ae = attrs.getAll();
            while (ae.hasMore()) {
                Attribute attr = ae.next();
                if (attr == null) continue;
                String id = attr.getID();
                NamingEnumeration<?> e = attr.getAll();
                while (e.hasMore()) {
                    try {
                        String dn;
                        String value = (String)e.next();
                        if (!value.endsWith(dn = ldap.getLdapConfig().getBase()) || parentDns.contains(value)) continue;
                        String attrId = value.substring(0, value.indexOf("="));
                        value = value.substring(value.indexOf("=") + 1, value.indexOf(dn) - 1);
                        matchAttrs.put(attrId, value);
                        results.addAll(LdapUtil.searchAttributesRecursive(ldap, matchAttrs, retAttrs, parentDns));
                    }
                    catch (ClassCastException ex) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)"Recursive search does not support binary values");
                    }
                }
            }
        }
        return results;
    }

    public static boolean checkCredential(Object credential) {
        boolean answer = false;
        if (credential != null) {
            byte[] array;
            if (credential instanceof String) {
                String string = (String)credential;
                if (!string.equals("")) {
                    answer = true;
                }
            } else if (credential instanceof char[]) {
                char[] array2 = (char[])credential;
                if (array2.length != 0) {
                    answer = true;
                }
            } else if (credential instanceof byte[] && (array = (byte[])credential).length != 0) {
                answer = true;
            }
        }
        return answer;
    }

    public static Map parseAttributes(Attributes attrs, boolean encodeBinary) throws NamingException {
        NamingEnumeration<? extends Attribute> ae;
        HashMap attributes = new HashMap();
        if (attrs != null && (ae = attrs.getAll()) != null) {
            while (ae.hasMore()) {
                attributes.putAll(LdapUtil.parseAttribute(ae.next(), encodeBinary));
            }
        }
        return attributes;
    }

    public static Map parseAttribute(Attribute attr, boolean encodeBinary) throws NamingException {
        String attrName;
        HashMap attribute = new HashMap();
        if (attr != null && (attrName = attr.getID()) != null) {
            NamingEnumeration<?> e = attr.getAll();
            ArrayList<Object> values = new ArrayList<Object>();
            if (e != null) {
                while (e.hasMore()) {
                    Object rawValue = e.next();
                    try {
                        String stringValue = (String)rawValue;
                        if (stringValue == null) continue;
                        values.add(stringValue);
                    }
                    catch (ClassCastException e1) {
                        try {
                            byte[] bytes = (byte[])rawValue;
                            if (encodeBinary) {
                                try {
                                    String stringValue = new String(Base64.encodeBase64((byte[])bytes), "UTF-8");
                                    if (stringValue == null) continue;
                                    values.add(stringValue);
                                }
                                catch (UnsupportedEncodingException e2) {
                                    if (!LOG.isErrorEnabled()) continue;
                                    LOG.error((Object)("Could not encode attribute value for " + attrName + " using " + "UTF-8"));
                                }
                                continue;
                            }
                            if (bytes == null) continue;
                            values.add(bytes);
                        }
                        catch (ClassCastException e2) {
                            if (!LOG.isDebugEnabled()) continue;
                            LOG.debug((Object)("Could not cast attribute value for " + attrName + " (" + rawValue.getClass().getName() + ") as a byte[] or a String"));
                        }
                    }
                }
            }
            attribute.put(attrName, values);
        }
        return attribute;
    }

    public static Iterator runCommandline(String[] args) throws IOException, NamingException {
        Iterator results = null;
        Ldap ldap = new Ldap();
        LdapConfig config = new LdapConfig();
        ldap.setLdapConfig(config);
        String filter = null;
        ArrayList<String> attrs = new ArrayList<String>();
        boolean compare = false;
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-url")) {
                    config.setHost(args[++i]);
                    continue;
                }
                if (args[i].equals("-base")) {
                    config.setBase(args[++i]);
                    continue;
                }
                if (args[i].equals("-tls")) {
                    config.useTls(true);
                    continue;
                }
                if (args[i].equals("-authtype")) {
                    config.setAuthtype(args[++i]);
                    continue;
                }
                if (args[i].equals("-trace")) {
                    config.tracePackets(System.out);
                    continue;
                }
                if (args[i].equals("-useProperties")) {
                    ldap.loadFromProperties();
                    config = ldap.getLdapConfig();
                    continue;
                }
                if (args[i].equals("-serviceUser")) {
                    config.setServiceUser(args[++i]);
                    continue;
                }
                if (args[i].equals("-serviceCredential")) {
                    config.setServiceCredential(args[++i]);
                    continue;
                }
                if (args[i].equals("-query")) {
                    filter = args[++i];
                    continue;
                }
                if (args[i].equals("-compare")) {
                    filter = args[++i];
                    compare = true;
                    continue;
                }
                attrs.add(args[i]);
            }
            if (config.getHost() == null || config.getPort() == null || config.getBase() == null || filter == null) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if (config.getServiceUser() != null && config.getServiceCredential() == null) {
                System.out.print("Enter service user password:  ");
                String pass = new BufferedReader(new InputStreamReader(System.in)).readLine();
                config.setServiceCredential(pass);
            }
            if (compare) {
                System.out.println(ldap.compare(filter));
            } else {
                results = attrs.isEmpty() ? ldap.search(filter) : ldap.search(filter, attrs.toArray(new String[0]));
            }
            ldap.close();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("Usage: java " + ldap.getClass().getName() + " -url <url> \\");
            System.out.println("       -base <base DN> \\");
            System.out.println("       -tls \\");
            System.out.println("       -authtype <mechanism> \\");
            System.out.println("       -trace \\");
            System.out.println("       -useProperties \\");
            System.out.println("       -serviceUser <user> \\");
            System.out.println("       -serviceCredential <credential> (Optional) \\");
            System.out.println("       -query <filter> <attributes> \\");
            System.out.println("       -compare <filter> \\");
        }
        return results;
    }
}

