/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.relyingparty.provider;

import edu.internet2.middleware.shibboleth.common.config.BaseReloadableService;
import edu.internet2.middleware.shibboleth.common.config.relyingparty.RelyingPartyGroup;
import edu.internet2.middleware.shibboleth.common.relyingparty.RelyingPartyConfiguration;
import edu.internet2.middleware.shibboleth.common.relyingparty.RelyingPartyConfigurationManager;
import edu.internet2.middleware.shibboleth.common.service.ServiceException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.opensaml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMLMDRelyingPartyConfigurationManager
extends BaseReloadableService
implements RelyingPartyConfigurationManager {
    public static final String ANONYMOUS_RP_NAME = "anonymous";
    public static final String DEFAULT_RP_NAME = "default";
    private final Logger log = LoggerFactory.getLogger(SAMLMDRelyingPartyConfigurationManager.class);
    private MetadataProvider metadataProvider;
    private HashMap<String, RelyingPartyConfiguration> rpConfigs = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RelyingPartyConfiguration getAnonymousRelyingConfiguration() {
        Lock readLock = this.getReadWriteLock().readLock();
        readLock.lock();
        try {
            RelyingPartyConfiguration relyingPartyConfiguration = this.rpConfigs.get(ANONYMOUS_RP_NAME);
            Object var4_3 = null;
            readLock.unlock();
            return relyingPartyConfiguration;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RelyingPartyConfiguration getDefaultRelyingPartyConfiguration() {
        Lock readLock = this.getReadWriteLock().readLock();
        readLock.lock();
        try {
            RelyingPartyConfiguration relyingPartyConfiguration = this.rpConfigs.get(DEFAULT_RP_NAME);
            Object var4_3 = null;
            readLock.unlock();
            return relyingPartyConfiguration;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetadataProvider getMetadataProvider() {
        Lock readLock = this.getReadWriteLock().readLock();
        readLock.lock();
        try {
            MetadataProvider metadataProvider = this.metadataProvider;
            Object var4_3 = null;
            readLock.unlock();
            return metadataProvider;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            readLock.unlock();
            throw throwable;
        }
    }

    public void setMetadataProvider(MetadataProvider provider) {
        this.metadataProvider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RelyingPartyConfiguration getRelyingPartyConfiguration(String relyingPartyEntityID) {
        readLock = this.getReadWriteLock().readLock();
        readLock.lock();
        try {
            block9: {
                block10: {
                    this.log.debug("Looking up relying party configuration for {}", (Object)relyingPartyEntityID);
                    if (this.rpConfigs.containsKey(relyingPartyEntityID)) {
                        this.log.debug("Custom relying party configuration found for {}", (Object)relyingPartyEntityID);
                        var3_3 = this.rpConfigs.get(relyingPartyEntityID);
                        var7_6 = null;
                        readLock.unlock();
                        return var3_3;
                    }
                    this.log.debug("No custom relying party configuration found for {}, looking up configuration based on metadata groups.", (Object)relyingPartyEntityID);
                    try {
                        if (this.metadataProvider == null) {
                            this.log.debug("No metadata provider available, unable to lookup configuration based on entity group");
                            break block9;
                        }
                        entityDescriptor = this.metadataProvider.getEntityDescriptor(relyingPartyEntityID);
                        if (entityDescriptor == null) break block9;
                        entityGroup = (EntitiesDescriptor)entityDescriptor.getParent();
lbl20:
                        // 2 sources

                        while (entityGroup != null) {
                            if (this.rpConfigs.containsKey(entityGroup.getName())) {
                                this.log.debug("Relying party configuration found for {} as member of metadata group {}", (Object)relyingPartyEntityID, (Object)entityGroup.getName());
                                var5_11 = this.rpConfigs.get(entityGroup.getName());
                                break block10;
                            }
                            ** GOTO lbl-1000
                        }
                        break block9;
                    }
                    catch (MetadataProviderException e) {
                        this.log.error("Error fetching metadata for relying party " + relyingPartyEntityID, (Throwable)e);
                        break block9;
                    }
                }
                var7_7 = null;
                readLock.unlock();
                return var5_11;
lbl-1000:
                // 1 sources

                {
                    entityGroup = (EntitiesDescriptor)entityGroup.getParent();
                    ** GOTO lbl20
                }
            }
            this.log.debug("No custom or group-based relying party configuration found for {}. Using default relying party configuration.", (Object)relyingPartyEntityID);
            var3_4 = this.getDefaultRelyingPartyConfiguration();
            var7_8 = null;
            readLock.unlock();
            return var3_4;
        }
        catch (Throwable var6_12) {
            var7_9 = null;
            readLock.unlock();
            throw var6_12;
        }
    }

    @Override
    public Map<String, RelyingPartyConfiguration> getRelyingPartyConfigurations() {
        return this.rpConfigs;
    }

    @Override
    protected void onNewContextCreated(ApplicationContext newServiceContext) throws ServiceException {
        MetadataProvider oldProvider = this.metadataProvider;
        HashMap<String, RelyingPartyConfiguration> oldRpConfigs = this.rpConfigs;
        try {
            String[] relyingPartyGroupNames = newServiceContext.getBeanNamesForType(RelyingPartyGroup.class);
            RelyingPartyGroup newRpGroup = (RelyingPartyGroup)newServiceContext.getBean(relyingPartyGroupNames[0]);
            this.metadataProvider = newRpGroup.getMetadataProvider();
            HashMap<String, RelyingPartyConfiguration> newRpConfigs = new HashMap<String, RelyingPartyConfiguration>();
            List<RelyingPartyConfiguration> loadRpConfigs = newRpGroup.getRelyingParties();
            if (loadRpConfigs != null) {
                for (RelyingPartyConfiguration newRpConfig : loadRpConfigs) {
                    newRpConfigs.put(newRpConfig.getRelyingPartyId(), newRpConfig);
                    this.log.debug("Registering configuration for relying party: {}", (Object)newRpConfig.getRelyingPartyId());
                }
            }
            newRpConfigs.put(ANONYMOUS_RP_NAME, newRpGroup.getAnonymousRP());
            newRpConfigs.put(DEFAULT_RP_NAME, newRpGroup.getDefaultRP());
            this.rpConfigs = newRpConfigs;
        }
        catch (Exception e) {
            this.metadataProvider = oldProvider;
            this.rpConfigs = oldRpConfigs;
            throw new ServiceException(this.getId() + " configuration is not valid, retaining old configuration", e);
        }
    }
}

