/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.encoding.provider;

import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.encoding.AttributeEncodingException;
import edu.internet2.middleware.shibboleth.common.attribute.encoding.provider.AbstractSAML2AttributeEncoder;
import java.util.List;
import org.opensaml.Configuration;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeValue;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilder;
import org.opensaml.xml.schema.XSAny;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML2XMLObjectAttributeEncoder
extends AbstractSAML2AttributeEncoder {
    private final Logger log = LoggerFactory.getLogger(SAML2XMLObjectAttributeEncoder.class);
    private final XMLObjectBuilder<XSAny> attributeValueBuilder = Configuration.getBuilderFactory().getBuilder(XSAny.TYPE_NAME);

    public Attribute encode(BaseAttribute attribute) throws AttributeEncodingException {
        Attribute samlAttribute = (Attribute)this.attributeBuilder.buildObject();
        this.populateAttribute(samlAttribute);
        for (Object o : attribute.getValues()) {
            if (o == null || !(o instanceof XMLObject)) continue;
            XSAny samlAttributeValue = (XSAny)this.attributeValueBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME);
            samlAttributeValue.getUnknownXMLObjects().add((XMLObject)o);
            samlAttribute.getAttributeValues().add(samlAttributeValue);
        }
        List attributeValues = samlAttribute.getAttributeValues();
        if (attributeValues == null || attributeValues.isEmpty()) {
            this.log.debug("Unable to encode {} attribute.  It does not contain any values", (Object)attribute.getId());
            return null;
        }
        return samlAttribute;
    }
}

