/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.ws.wssecurity.impl;

import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.opensaml.ws.wssecurity.AttributedDateTime;
import org.opensaml.ws.wssecurity.impl.AbstractWSSecurityObject;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.util.AttributeMap;

public class AttributedDataTimeImpl
extends AbstractWSSecurityObject
implements AttributedDateTime {
    private DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private DateTime dateTimeValue;
    private String stringValue;
    private String id;
    private AttributeMap unknownAttributes = new AttributeMap((XMLObject)this);

    public AttributedDataTimeImpl(String namespaceURI, String elementLocalName, String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public DateTime getDateTime() {
        return this.dateTimeValue;
    }

    public void setDateTime(DateTime newDateTime) {
        this.dateTimeValue = newDateTime;
        String formattedDateTime = this.formatter.print((ReadableInstant)this.dateTimeValue);
        this.stringValue = this.prepareForAssignment(this.stringValue, formattedDateTime);
    }

    public String getValue() {
        return this.stringValue;
    }

    public void setValue(String newValue) {
        this.stringValue = this.prepareForAssignment(this.stringValue, newValue);
        this.dateTimeValue = this.formatter.parseDateTime(this.stringValue);
    }

    public String getWSUId() {
        return this.id;
    }

    public void setWSUId(String newId) {
        String oldID = this.id;
        this.id = this.prepareForAssignment(this.id, newId);
        this.registerOwnID(oldID, this.id);
    }

    public AttributeMap getUnknownAttributes() {
        return this.unknownAttributes;
    }
}

