/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.agreement.DHBasicAgreement;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSABlindedEngine;
import org.bouncycastle.crypto.generators.DHBasicKeyPairGenerator;
import org.bouncycastle.crypto.io.SignerInputStream;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.DHKeyGenerationParameters;
import org.bouncycastle.crypto.params.DHParameters;
import org.bouncycastle.crypto.params.DHPublicKeyParameters;
import org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.prng.ThreadedSeedGenerator;
import org.bouncycastle.crypto.tls.ByteQueue;
import org.bouncycastle.crypto.tls.Certificate;
import org.bouncycastle.crypto.tls.CertificateVerifyer;
import org.bouncycastle.crypto.tls.RecordStream;
import org.bouncycastle.crypto.tls.TlsCipherSuite;
import org.bouncycastle.crypto.tls.TlsCipherSuiteManager;
import org.bouncycastle.crypto.tls.TlsDSSSigner;
import org.bouncycastle.crypto.tls.TlsInputStream;
import org.bouncycastle.crypto.tls.TlsOuputStream;
import org.bouncycastle.crypto.tls.TlsRSASigner;
import org.bouncycastle.crypto.tls.TlsUtils;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.util.BigIntegers;

public class TlsProtocolHandler {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private static final short RL_CHANGE_CIPHER_SPEC = 20;
    private static final short RL_ALERT = 21;
    private static final short RL_HANDSHAKE = 22;
    private static final short RL_APPLICATION_DATA = 23;
    private static final short HP_HELLO_REQUEST = 0;
    private static final short HP_CLIENT_HELLO = 1;
    private static final short HP_SERVER_HELLO = 2;
    private static final short HP_CERTIFICATE = 11;
    private static final short HP_SERVER_KEY_EXCHANGE = 12;
    private static final short HP_CERTIFICATE_REQUEST = 13;
    private static final short HP_SERVER_HELLO_DONE = 14;
    private static final short HP_CERTIFICATE_VERIFY = 15;
    private static final short HP_CLIENT_KEY_EXCHANGE = 16;
    private static final short HP_FINISHED = 20;
    private static final short CS_CLIENT_HELLO_SEND = 1;
    private static final short CS_SERVER_HELLO_RECEIVED = 2;
    private static final short CS_SERVER_CERTIFICATE_RECEIVED = 3;
    private static final short CS_SERVER_KEY_EXCHANGE_RECEIVED = 4;
    private static final short CS_CERTIFICATE_REQUEST_RECEIVED = 5;
    private static final short CS_SERVER_HELLO_DONE_RECEIVED = 6;
    private static final short CS_CLIENT_KEY_EXCHANGE_SEND = 7;
    private static final short CS_CLIENT_CHANGE_CIPHER_SPEC_SEND = 8;
    private static final short CS_CLIENT_FINISHED_SEND = 9;
    private static final short CS_SERVER_CHANGE_CIPHER_SPEC_RECEIVED = 10;
    private static final short CS_DONE = 11;
    protected static final short AP_close_notify = 0;
    protected static final short AP_unexpected_message = 10;
    protected static final short AP_bad_record_mac = 20;
    protected static final short AP_decryption_failed = 21;
    protected static final short AP_record_overflow = 22;
    protected static final short AP_decompression_failure = 30;
    protected static final short AP_handshake_failure = 40;
    protected static final short AP_bad_certificate = 42;
    protected static final short AP_unsupported_certificate = 43;
    protected static final short AP_certificate_revoked = 44;
    protected static final short AP_certificate_expired = 45;
    protected static final short AP_certificate_unknown = 46;
    protected static final short AP_illegal_parameter = 47;
    protected static final short AP_unknown_ca = 48;
    protected static final short AP_access_denied = 49;
    protected static final short AP_decode_error = 50;
    protected static final short AP_decrypt_error = 51;
    protected static final short AP_export_restriction = 60;
    protected static final short AP_protocol_version = 70;
    protected static final short AP_insufficient_security = 71;
    protected static final short AP_internal_error = 80;
    protected static final short AP_user_canceled = 90;
    protected static final short AP_no_renegotiation = 100;
    protected static final short AL_warning = 1;
    protected static final short AL_fatal = 2;
    private static final byte[] emptybuf = new byte[0];
    private static final String TLS_ERROR_MESSAGE = "Internal TLS error, this could be an attack";
    private ByteQueue applicationDataQueue = new ByteQueue();
    private ByteQueue changeCipherSpecQueue = new ByteQueue();
    private ByteQueue alertQueue = new ByteQueue();
    private ByteQueue handshakeQueue = new ByteQueue();
    private RecordStream rs;
    private SecureRandom random;
    private AsymmetricKeyParameter serverPublicKey = null;
    private TlsInputStream tlsInputStream = null;
    private TlsOuputStream tlsOutputStream = null;
    private boolean closed = false;
    private boolean failedWithError = false;
    private boolean appDataReady = false;
    private byte[] clientRandom;
    private byte[] serverRandom;
    private byte[] ms;
    private TlsCipherSuite chosenCipherSuite = null;
    private BigInteger Yc;
    private byte[] pms;
    private CertificateVerifyer verifyer = null;
    private short connection_state;

    public TlsProtocolHandler(InputStream inputStream, OutputStream outputStream) {
        ThreadedSeedGenerator threadedSeedGenerator = new ThreadedSeedGenerator();
        this.random = new SecureRandom();
        this.random.setSeed(threadedSeedGenerator.generateSeed(20, true));
        this.rs = new RecordStream(this, inputStream, outputStream);
    }

    public TlsProtocolHandler(InputStream inputStream, OutputStream outputStream, SecureRandom secureRandom) {
        this.random = secureRandom;
        this.rs = new RecordStream(this, inputStream, outputStream);
    }

    protected void processData(short s, byte[] byArray, int n, int n2) throws IOException {
        switch (s) {
            case 20: {
                this.changeCipherSpecQueue.addData(byArray, n, n2);
                this.processChangeCipherSpec();
                break;
            }
            case 21: {
                this.alertQueue.addData(byArray, n, n2);
                this.processAlert();
                break;
            }
            case 22: {
                this.handshakeQueue.addData(byArray, n, n2);
                this.processHandshake();
                break;
            }
            case 23: {
                if (!this.appDataReady) {
                    this.failWithError((short)2, (short)10);
                }
                this.applicationDataQueue.addData(byArray, n, n2);
                this.processApplicationData();
                break;
            }
        }
    }

    private void processHandshake() throws IOException {
        boolean bl;
        do {
            bl = false;
            if (this.handshakeQueue.size() < 4) continue;
            byte[] byArray = new byte[4];
            this.handshakeQueue.read(byArray, 0, 4, 0);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            short s = TlsUtils.readUint8(byteArrayInputStream);
            int n = TlsUtils.readUint24(byteArrayInputStream);
            if (this.handshakeQueue.size() < n + 4) continue;
            byte[] byArray2 = new byte[n];
            this.handshakeQueue.read(byArray2, 0, n, 4);
            this.handshakeQueue.removeData(n + 4);
            if (s != 20) {
                this.rs.hash1.update(byArray, 0, 4);
                this.rs.hash2.update(byArray, 0, 4);
                this.rs.hash1.update(byArray2, 0, n);
                this.rs.hash2.update(byArray2, 0, n);
            }
            ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byArray2);
            block2 : switch (s) {
                case 11: {
                    Object object;
                    switch (this.connection_state) {
                        case 2: {
                            Certificate certificate = Certificate.parse(byteArrayInputStream2);
                            this.assertEmpty(byteArrayInputStream2);
                            object = certificate.certs[0];
                            SubjectPublicKeyInfo subjectPublicKeyInfo = object.getSubjectPublicKeyInfo();
                            try {
                                this.serverPublicKey = PublicKeyFactory.createKey(subjectPublicKeyInfo);
                            }
                            catch (RuntimeException runtimeException) {
                                this.failWithError((short)2, (short)43);
                            }
                            if (this.serverPublicKey.isPrivate()) {
                                this.failWithError((short)2, (short)80);
                            }
                            switch (this.chosenCipherSuite.getKeyExchangeAlgorithm()) {
                                case 1: {
                                    if (!(this.serverPublicKey instanceof RSAKeyParameters)) {
                                        this.failWithError((short)2, (short)46);
                                    }
                                    this.validateKeyUsage((X509CertificateStructure)object, 32);
                                    break;
                                }
                                case 5: {
                                    if (!(this.serverPublicKey instanceof RSAKeyParameters)) {
                                        this.failWithError((short)2, (short)46);
                                    }
                                    this.validateKeyUsage((X509CertificateStructure)object, 128);
                                    break;
                                }
                                case 3: {
                                    if (this.serverPublicKey instanceof DSAPublicKeyParameters) break;
                                    this.failWithError((short)2, (short)46);
                                    break;
                                }
                                default: {
                                    this.failWithError((short)2, (short)43);
                                }
                            }
                            if (this.verifyer.isValid(certificate.getCerts())) break;
                            this.failWithError((short)2, (short)90);
                            break;
                        }
                        default: {
                            this.failWithError((short)2, (short)10);
                        }
                    }
                    this.connection_state = (short)3;
                    bl = true;
                    break;
                }
                case 20: {
                    Object object;
                    switch (this.connection_state) {
                        case 10: {
                            byte[] byArray3 = new byte[12];
                            TlsUtils.readFully(byArray3, byteArrayInputStream2);
                            this.assertEmpty(byteArrayInputStream2);
                            object = new byte[12];
                            byte[] byArray4 = new byte[36];
                            this.rs.hash2.doFinal(byArray4, 0);
                            TlsUtils.PRF(this.ms, TlsUtils.toByteArray("server finished"), byArray4, object);
                            for (int i = 0; i < byArray3.length; ++i) {
                                if (byArray3[i] == object[i]) continue;
                                this.failWithError((short)2, (short)40);
                            }
                            this.connection_state = (short)11;
                            this.appDataReady = true;
                            bl = true;
                            break block2;
                        }
                    }
                    this.failWithError((short)2, (short)10);
                    break;
                }
                case 2: {
                    Object object;
                    switch (this.connection_state) {
                        case 1: {
                            TlsUtils.checkVersion(byteArrayInputStream2, this);
                            this.serverRandom = new byte[32];
                            TlsUtils.readFully(this.serverRandom, byteArrayInputStream2);
                            short s2 = TlsUtils.readUint8(byteArrayInputStream2);
                            object = new byte[s2];
                            TlsUtils.readFully(object, byteArrayInputStream2);
                            this.chosenCipherSuite = TlsCipherSuiteManager.getCipherSuite(TlsUtils.readUint16(byteArrayInputStream2), this);
                            short s3 = TlsUtils.readUint8(byteArrayInputStream2);
                            if (s3 != 0) {
                                this.failWithError((short)2, (short)47);
                            }
                            this.assertEmpty(byteArrayInputStream2);
                            this.connection_state = (short)2;
                            bl = true;
                            break block2;
                        }
                    }
                    this.failWithError((short)2, (short)10);
                    break;
                }
                case 14: {
                    Object object;
                    switch (this.connection_state) {
                        case 3: {
                            if (this.chosenCipherSuite.getKeyExchangeAlgorithm() != 1) {
                                this.failWithError((short)2, (short)10);
                            }
                        }
                        case 4: 
                        case 5: {
                            byte[] byArray5;
                            this.assertEmpty(byteArrayInputStream2);
                            boolean bl2 = this.connection_state == 5;
                            this.connection_state = (short)6;
                            if (bl2) {
                                this.sendClientCertificate();
                            }
                            switch (this.chosenCipherSuite.getKeyExchangeAlgorithm()) {
                                case 1: {
                                    this.pms = new byte[48];
                                    this.random.nextBytes(this.pms);
                                    this.pms[0] = 3;
                                    this.pms[1] = 1;
                                    object = new RSABlindedEngine();
                                    PKCS1Encoding pKCS1Encoding = new PKCS1Encoding((AsymmetricBlockCipher)object);
                                    pKCS1Encoding.init(true, new ParametersWithRandom(this.serverPublicKey, this.random));
                                    byArray5 = null;
                                    try {
                                        byArray5 = pKCS1Encoding.processBlock(this.pms, 0, this.pms.length);
                                    }
                                    catch (InvalidCipherTextException invalidCipherTextException) {
                                        this.failWithError((short)2, (short)80);
                                    }
                                    this.sendClientKeyExchange(byArray5);
                                    break;
                                }
                                case 3: 
                                case 5: {
                                    object = BigIntegers.asUnsignedByteArray(this.Yc);
                                    this.sendClientKeyExchange((byte[])object);
                                    break;
                                }
                                default: {
                                    this.failWithError((short)2, (short)10);
                                }
                            }
                            this.connection_state = (short)7;
                            object = new byte[]{1};
                            this.rs.writeMessage((short)20, (byte[])object, 0, ((byte[])object).length);
                            this.connection_state = (short)8;
                            this.ms = new byte[48];
                            byte[] byArray6 = new byte[this.clientRandom.length + this.serverRandom.length];
                            System.arraycopy(this.clientRandom, 0, byArray6, 0, this.clientRandom.length);
                            System.arraycopy(this.serverRandom, 0, byArray6, this.clientRandom.length, this.serverRandom.length);
                            TlsUtils.PRF(this.pms, TlsUtils.toByteArray("master secret"), byArray6, this.ms);
                            this.rs.writeSuite = this.chosenCipherSuite;
                            this.rs.writeSuite.init(this.ms, this.clientRandom, this.serverRandom);
                            byArray5 = new byte[12];
                            byte[] byArray7 = new byte[36];
                            this.rs.hash1.doFinal(byArray7, 0);
                            TlsUtils.PRF(this.ms, TlsUtils.toByteArray("client finished"), byArray7, byArray5);
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                            TlsUtils.writeUint8((short)20, byteArrayOutputStream);
                            TlsUtils.writeUint24(12, byteArrayOutputStream);
                            byteArrayOutputStream.write(byArray5);
                            byte[] byArray8 = byteArrayOutputStream.toByteArray();
                            this.rs.writeMessage((short)22, byArray8, 0, byArray8.length);
                            this.connection_state = (short)9;
                            bl = true;
                            break block2;
                        }
                    }
                    this.failWithError((short)2, (short)40);
                    break;
                }
                case 12: {
                    block32 : switch (this.connection_state) {
                        case 3: {
                            switch (this.chosenCipherSuite.getKeyExchangeAlgorithm()) {
                                case 5: {
                                    this.processDHEKeyExchange(byteArrayInputStream2, new TlsRSASigner());
                                    break block32;
                                }
                                case 3: {
                                    this.processDHEKeyExchange(byteArrayInputStream2, new TlsDSSSigner());
                                    break block32;
                                }
                            }
                            this.failWithError((short)2, (short)10);
                            break;
                        }
                        default: {
                            this.failWithError((short)2, (short)10);
                        }
                    }
                    this.connection_state = (short)4;
                    bl = true;
                    break;
                }
                case 13: {
                    Object object;
                    switch (this.connection_state) {
                        case 3: {
                            if (this.chosenCipherSuite.getKeyExchangeAlgorithm() != 1) {
                                this.failWithError((short)2, (short)10);
                            }
                        }
                        case 4: {
                            short s4 = TlsUtils.readUint8(byteArrayInputStream2);
                            object = new byte[s4];
                            TlsUtils.readFully(object, byteArrayInputStream2);
                            int n2 = TlsUtils.readUint16(byteArrayInputStream2);
                            byte[] byArray9 = new byte[n2];
                            TlsUtils.readFully(byArray9, byteArrayInputStream2);
                            this.assertEmpty(byteArrayInputStream2);
                            break;
                        }
                        default: {
                            this.failWithError((short)2, (short)10);
                        }
                    }
                    this.connection_state = (short)5;
                    bl = true;
                    break;
                }
                default: {
                    this.failWithError((short)2, (short)10);
                }
            }
        } while (bl);
    }

    private void processApplicationData() {
    }

    private void processAlert() throws IOException {
        while (this.alertQueue.size() >= 2) {
            byte[] byArray = new byte[2];
            this.alertQueue.read(byArray, 0, 2, 0);
            this.alertQueue.removeData(2);
            short s = byArray[0];
            short s2 = byArray[1];
            if (s == 2) {
                this.failedWithError = true;
                this.closed = true;
                try {
                    this.rs.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new IOException(TLS_ERROR_MESSAGE);
            }
            if (s2 != 0) continue;
            this.failWithError((short)1, (short)0);
        }
    }

    private void processChangeCipherSpec() throws IOException {
        while (this.changeCipherSpecQueue.size() > 0) {
            byte[] byArray = new byte[1];
            this.changeCipherSpecQueue.read(byArray, 0, 1, 0);
            this.changeCipherSpecQueue.removeData(1);
            if (byArray[0] != 1) {
                this.failWithError((short)2, (short)10);
                continue;
            }
            if (this.connection_state == 9) {
                this.rs.readSuite = this.rs.writeSuite;
                this.connection_state = (short)10;
                continue;
            }
            this.failWithError((short)2, (short)40);
        }
    }

    private void processDHEKeyExchange(ByteArrayInputStream byteArrayInputStream, Signer signer) throws IOException {
        Object object;
        InputStream inputStream = byteArrayInputStream;
        if (signer != null) {
            signer.init(false, this.serverPublicKey);
            signer.update(this.clientRandom, 0, this.clientRandom.length);
            signer.update(this.serverRandom, 0, this.serverRandom.length);
            inputStream = new SignerInputStream(byteArrayInputStream, signer);
        }
        int n = TlsUtils.readUint16(inputStream);
        byte[] byArray = new byte[n];
        TlsUtils.readFully(byArray, inputStream);
        int n2 = TlsUtils.readUint16(inputStream);
        byte[] byArray2 = new byte[n2];
        TlsUtils.readFully(byArray2, inputStream);
        int n3 = TlsUtils.readUint16(inputStream);
        byte[] byArray3 = new byte[n3];
        TlsUtils.readFully(byArray3, inputStream);
        if (signer != null) {
            int n4 = TlsUtils.readUint16(byteArrayInputStream);
            object = new byte[n4];
            TlsUtils.readFully((byte[])object, byteArrayInputStream);
            if (!signer.verifySignature((byte[])object)) {
                this.failWithError((short)2, (short)42);
            }
        }
        this.assertEmpty(byteArrayInputStream);
        BigInteger bigInteger = new BigInteger(1, byArray);
        object = new BigInteger(1, byArray2);
        BigInteger bigInteger2 = new BigInteger(1, byArray3);
        if (!bigInteger.isProbablePrime(10)) {
            this.failWithError((short)2, (short)47);
        }
        if (((BigInteger)object).compareTo(TWO) < 0 || ((BigInteger)object).compareTo(bigInteger.subtract(TWO)) > 0) {
            this.failWithError((short)2, (short)47);
        }
        if (bigInteger2.compareTo(TWO) < 0 || bigInteger2.compareTo(bigInteger.subtract(ONE)) > 0) {
            this.failWithError((short)2, (short)47);
        }
        DHParameters dHParameters = new DHParameters(bigInteger, (BigInteger)object);
        DHBasicKeyPairGenerator dHBasicKeyPairGenerator = new DHBasicKeyPairGenerator();
        dHBasicKeyPairGenerator.init(new DHKeyGenerationParameters(this.random, dHParameters));
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = dHBasicKeyPairGenerator.generateKeyPair();
        this.Yc = ((DHPublicKeyParameters)asymmetricCipherKeyPair.getPublic()).getY();
        DHBasicAgreement dHBasicAgreement = new DHBasicAgreement();
        dHBasicAgreement.init(asymmetricCipherKeyPair.getPrivate());
        BigInteger bigInteger3 = dHBasicAgreement.calculateAgreement(new DHPublicKeyParameters(bigInteger2, dHParameters));
        this.pms = BigIntegers.asUnsignedByteArray(bigInteger3);
    }

    private void validateKeyUsage(X509CertificateStructure x509CertificateStructure, int n) throws IOException {
        DERBitString dERBitString;
        int n2;
        X509Extension x509Extension;
        X509Extensions x509Extensions = x509CertificateStructure.getTBSCertificate().getExtensions();
        if (x509Extensions != null && (x509Extension = x509Extensions.getExtension(X509Extensions.KeyUsage)) != null && ((n2 = (dERBitString = KeyUsage.getInstance(x509Extension)).getBytes()[0] & 0xFF) & n) != n) {
            this.failWithError((short)2, (short)46);
        }
    }

    private void sendClientCertificate() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsUtils.writeUint8((short)11, byteArrayOutputStream);
        TlsUtils.writeUint24(3, byteArrayOutputStream);
        TlsUtils.writeUint24(0, byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.rs.writeMessage((short)22, byArray, 0, byArray.length);
    }

    private void sendClientKeyExchange(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsUtils.writeUint8((short)16, byteArrayOutputStream);
        TlsUtils.writeUint24(byArray.length + 2, byteArrayOutputStream);
        TlsUtils.writeUint16(byArray.length, byteArrayOutputStream);
        byteArrayOutputStream.write(byArray);
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        this.rs.writeMessage((short)22, byArray2, 0, byArray2.length);
    }

    public void connect(CertificateVerifyer certificateVerifyer) throws IOException {
        this.verifyer = certificateVerifyer;
        this.clientRandom = new byte[32];
        this.random.nextBytes(this.clientRandom);
        int n = (int)(System.currentTimeMillis() / 1000L);
        this.clientRandom[0] = (byte)(n >> 24);
        this.clientRandom[1] = (byte)(n >> 16);
        this.clientRandom[2] = (byte)(n >> 8);
        this.clientRandom[3] = (byte)n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsUtils.writeVersion(byteArrayOutputStream);
        byteArrayOutputStream.write(this.clientRandom);
        TlsUtils.writeUint8((short)0, byteArrayOutputStream);
        TlsCipherSuiteManager.writeCipherSuites(byteArrayOutputStream);
        byte[] byArray = new byte[]{0};
        TlsUtils.writeUint8((short)byArray.length, byteArrayOutputStream);
        byteArrayOutputStream.write(byArray);
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        TlsUtils.writeUint8((short)1, byteArrayOutputStream2);
        TlsUtils.writeUint24(byteArrayOutputStream.size(), byteArrayOutputStream2);
        byteArrayOutputStream2.write(byteArrayOutputStream.toByteArray());
        byte[] byArray2 = byteArrayOutputStream2.toByteArray();
        this.rs.writeMessage((short)22, byArray2, 0, byArray2.length);
        this.connection_state = 1;
        while (this.connection_state != 11) {
            this.rs.readData();
        }
        this.tlsInputStream = new TlsInputStream(this);
        this.tlsOutputStream = new TlsOuputStream(this);
    }

    protected int readApplicationData(byte[] byArray, int n, int n2) throws IOException {
        while (this.applicationDataQueue.size() == 0) {
            if (this.failedWithError) {
                throw new IOException(TLS_ERROR_MESSAGE);
            }
            if (this.closed) {
                return -1;
            }
            try {
                this.rs.readData();
            }
            catch (IOException iOException) {
                if (!this.closed) {
                    this.failWithError((short)2, (short)80);
                }
                throw iOException;
            }
            catch (RuntimeException runtimeException) {
                if (!this.closed) {
                    this.failWithError((short)2, (short)80);
                }
                throw runtimeException;
            }
        }
        n2 = Math.min(n2, this.applicationDataQueue.size());
        this.applicationDataQueue.read(byArray, n, n2, 0);
        this.applicationDataQueue.removeData(n2);
        return n2;
    }

    protected void writeData(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.failedWithError) {
            throw new IOException(TLS_ERROR_MESSAGE);
        }
        if (this.closed) {
            throw new IOException("Sorry, connection has been closed, you cannot write more data");
        }
        this.rs.writeMessage((short)23, emptybuf, 0, 0);
        do {
            n3 = Math.min(n2, 16384);
            try {
                this.rs.writeMessage((short)23, byArray, n, n3);
            }
            catch (IOException iOException) {
                if (!this.closed) {
                    this.failWithError((short)2, (short)80);
                }
                throw iOException;
            }
            catch (RuntimeException runtimeException) {
                if (!this.closed) {
                    this.failWithError((short)2, (short)80);
                }
                throw runtimeException;
            }
            n += n3;
        } while ((n2 -= n3) > 0);
    }

    public TlsOuputStream getTlsOuputStream() {
        return this.tlsOutputStream;
    }

    public OutputStream getOutputStream() {
        return this.tlsOutputStream;
    }

    public TlsInputStream getTlsInputStream() {
        return this.tlsInputStream;
    }

    public InputStream getInputStream() {
        return this.tlsInputStream;
    }

    protected void failWithError(short s, short s2) throws IOException {
        if (!this.closed) {
            byte[] byArray = new byte[]{(byte)s, (byte)s2};
            this.closed = true;
            if (s == 2) {
                this.failedWithError = true;
            }
            this.rs.writeMessage((short)21, byArray, 0, 2);
            this.rs.close();
            if (s == 2) {
                throw new IOException(TLS_ERROR_MESSAGE);
            }
        } else {
            throw new IOException(TLS_ERROR_MESSAGE);
        }
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.failWithError((short)1, (short)0);
        }
    }

    protected void assertEmpty(ByteArrayInputStream byteArrayInputStream) throws IOException {
        if (byteArrayInputStream.available() > 0) {
            this.failWithError((short)2, (short)50);
        }
    }

    protected void flush() throws IOException {
        this.rs.flush();
    }
}

