/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.servlets;

import edu.vt.middleware.ldap.Authenticator;
import edu.vt.middleware.ldap.servlets.CommonServlet;
import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class LoginServlet
extends CommonServlet {
    private static final Log LOG = LogFactory.getLog((Class)(class$edu$vt$middleware$ldap$servlets$LoginServlet == null ? (class$edu$vt$middleware$ldap$servlets$LoginServlet = LoginServlet.class$("edu.vt.middleware.ldap.servlets.LoginServlet")) : class$edu$vt$middleware$ldap$servlets$LoginServlet));
    private String loginUrl;
    private String errorMsg;
    private Authenticator auth;
    static /* synthetic */ Class class$edu$vt$middleware$ldap$servlets$LoginServlet;

    public void init(ServletConfig config) throws ServletException {
        String propertiesFile;
        super.init(config);
        this.loginUrl = this.getInitParameter("edu.vt.middleware.ldap.servlets.loginUrl");
        if (this.loginUrl == null) {
            this.loginUrl = "/";
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("edu.vt.middleware.ldap.servlets.loginUrl = " + this.loginUrl));
        }
        this.errorMsg = this.getInitParameter("edu.vt.middleware.ldap.servlets.errorMsg");
        if (this.errorMsg == null) {
            this.errorMsg = "Could not authenticate or authorize user";
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("edu.vt.middleware.ldap.servlets.errorMsg = " + this.errorMsg));
        }
        if ((propertiesFile = this.getInitParameter("edu.vt.middleware.ldap.servlets.propertiesFile")) == null) {
            propertiesFile = "/ldap.properties";
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("edu.vt.middleware.ldap.servlets.propertiesFile = " + propertiesFile));
        }
        this.auth = new Authenticator();
        this.auth.loadFromProperties(propertiesFile);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        StringBuffer error;
        String url;
        String user;
        block19: {
            boolean validCredentials;
            block18: {
                validCredentials = false;
                user = request.getParameter("user");
                if (user != null) {
                    user = user.trim().toLowerCase();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Received user param = " + user));
                }
                String credential = request.getParameter("credential");
                url = request.getParameter("url");
                if (url == null) {
                    url = "";
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Received url param = " + url));
                }
                error = new StringBuffer(this.errorMsg);
                try {
                    if (this.auth.authenticate(user, credential)) {
                        validCredentials = true;
                    }
                }
                catch (Exception e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)("Error authenticating user " + user), (Throwable)e);
                    }
                    if (e.getCause() != null && e.getCause().getMessage() != null && !e.getCause().getMessage().equals("null")) {
                        error.append(": ").append(e.getCause().getMessage());
                    }
                    if (e.getMessage() == null || e.getMessage().equals("null")) break block18;
                    error.append(": ").append(e.getMessage());
                }
            }
            if (validCredentials) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Authentication succeeded for user " + user));
                }
                try {
                    this.sessionManager.login(request.getSession(true), user);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Initialized session for user " + user));
                    }
                    response.sendRedirect(url);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Redirected user to " + url));
                    }
                    return;
                }
                catch (Exception e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)("Error authorizing user " + user), (Throwable)e);
                    }
                    if (e.getCause() != null && e.getCause().getMessage() != null && !e.getCause().getMessage().equals("null")) {
                        error.append(": ").append(e.getCause().getMessage());
                    }
                    if (e.getMessage() == null || e.getMessage().equals("null")) break block19;
                    error.append(": ").append(e.getMessage());
                }
            }
        }
        StringBuffer errorUrl = new StringBuffer(this.loginUrl);
        errorUrl.append("?error=").append(URLEncoder.encode(error.toString(), "UTF-8"));
        errorUrl.append("&user=").append(URLEncoder.encode(user, "UTF-8"));
        errorUrl.append("&url=").append(URLEncoder.encode(url, "UTF-8"));
        response.sendRedirect(errorUrl.toString());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Redirected user to " + errorUrl.toString()));
        }
    }

    public void destroy() {
        super.destroy();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

