/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.session.impl;

import edu.internet2.middleware.shibboleth.common.session.Session;
import java.security.Principal;
import java.util.Set;
import javax.security.auth.Subject;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;

public abstract class AbstractSession
implements Session {
    private static final long serialVersionUID = 4726780089406295821L;
    private final String sessionId;
    private Subject subject;
    private long inactivityTimeout;
    private long lastActivity;

    public AbstractSession(String id, long timeout) {
        this.sessionId = id;
        this.subject = new Subject();
        this.inactivityTimeout = timeout;
        this.lastActivity = new DateTime().toDateTime((Chronology)ISOChronology.getInstanceUTC()).getMillis();
    }

    public synchronized String getSessionID() {
        return this.sessionId;
    }

    public synchronized Subject getSubject() {
        return this.subject;
    }

    public synchronized void setSubject(Subject newSubject) {
        this.subject = newSubject;
    }

    public synchronized String getPrincipalName() {
        Set<Principal> principals = this.subject.getPrincipals();
        if (principals != null && !principals.isEmpty()) {
            return principals.iterator().next().getName();
        }
        return null;
    }

    public synchronized long getInactivityTimeout() {
        return this.inactivityTimeout;
    }

    public synchronized DateTime getLastActivityInstant() {
        return new DateTime(this.lastActivity, (Chronology)ISOChronology.getInstanceUTC());
    }

    public synchronized void setLastActivityInstant(DateTime activity) {
        this.lastActivity = activity.toDateTime((Chronology)ISOChronology.getInstanceUTC()).getMillis();
    }
}

