/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.joda.time.DateTime;
import org.opensaml.util.resource.AbstractFilteredResource;
import org.opensaml.util.resource.ResourceException;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;

public class SVNResource
extends AbstractFilteredResource {
    private final Logger log = LoggerFactory.getLogger(SVNResource.class);
    private final SVNClientManager clientManager;
    private SVNURL remoteRepository;
    private File workingCopy;
    private SVNRevision revision;
    private String resourceFileName;

    public SVNResource(SVNClientManager svnClientMgr, SVNURL repositoryUrl, File workingCopyDirectory, long revision, String resourceFile) throws ResourceException {
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
        if (svnClientMgr == null) {
            this.log.error("SVN client manager may not be null");
            throw new IllegalArgumentException("SVN client manager may not be null");
        }
        this.clientManager = svnClientMgr;
        if (repositoryUrl == null) {
            throw new IllegalArgumentException("SVN repository URL may not be null");
        }
        this.remoteRepository = repositoryUrl;
        try {
            this.checkWorkingCopyDirectory(workingCopyDirectory);
            this.workingCopy = workingCopyDirectory;
        }
        catch (ResourceException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        this.revision = revision < 0L ? SVNRevision.HEAD : SVNRevision.create((long)revision);
        this.resourceFileName = DatatypeHelper.safeTrimOrNullString((String)resourceFile);
        if (this.resourceFileName == null) {
            this.log.error("SVN working copy resource file name may not be null or empty");
            throw new IllegalArgumentException("SVN working copy resource file name may not be null or empty");
        }
        this.checkoutOrUpdateResource();
        if (!this.getResourceFile().exists()) {
            this.log.error("Resource file " + resourceFile + " does not exist in SVN working copy directory " + workingCopyDirectory.getAbsolutePath());
            throw new ResourceException("Resource file " + resourceFile + " does not exist in SVN working copy directory " + workingCopyDirectory.getAbsolutePath());
        }
    }

    public boolean exists() throws ResourceException {
        return this.getResourceFile().exists();
    }

    public InputStream getInputStream() throws ResourceException {
        try {
            return this.applyFilter(new FileInputStream(this.getResourceFile()));
        }
        catch (IOException e) {
            String erroMsg = "Unable to read resource file " + this.resourceFileName + " from local working copy " + this.workingCopy.getAbsolutePath();
            this.log.error(erroMsg, (Throwable)e);
            throw new ResourceException(erroMsg, (Exception)e);
        }
    }

    public DateTime getLastModifiedTime() throws ResourceException {
        SVNStatusClient client = this.clientManager.getStatusClient();
        client.setIgnoreExternals(false);
        try {
            SVNStatus status = client.doStatus(this.getResourceFile(), false);
            if (status.getContentsStatus() == SVNStatusType.STATUS_NORMAL) {
                return new DateTime((Object)status.getWorkingContentsDate());
            }
            String errMsg = "Unable to determine last modified time of resource " + this.resourceFileName + " within working directory " + this.workingCopy.getAbsolutePath();
            this.log.error(errMsg);
            throw new ResourceException(errMsg);
        }
        catch (SVNException e) {
            String errMsg = "Unable to check status of resource " + this.resourceFileName + " within working directory " + this.workingCopy.getAbsolutePath();
            this.log.error(errMsg, (Throwable)e);
            throw new ResourceException(errMsg, (Exception)((Object)e));
        }
    }

    public String getLocation() {
        return this.remoteRepository.toDecodedString() + "/" + this.resourceFileName;
    }

    protected void checkWorkingCopyDirectory(File directory) throws ResourceException {
        boolean created;
        if (directory == null) {
            this.log.error("SVN working copy directory may not be null");
            throw new ResourceException("SVN working copy directory may not be null");
        }
        if (!directory.exists() && !(created = directory.mkdirs())) {
            this.log.error("SVN working copy direction " + directory.getAbsolutePath() + " does not exist and could not be created");
            throw new ResourceException("SVN working copy direction " + directory.getAbsolutePath() + " does not exist and could not be created");
        }
        if (!directory.isDirectory()) {
            this.log.error("SVN working copy location " + directory.getAbsolutePath() + " is not a directory");
            throw new ResourceException("SVN working copy location " + directory.getAbsolutePath() + " is not a directory");
        }
        if (!directory.canRead()) {
            this.log.error("SVN working copy directory " + directory.getAbsolutePath() + " can not be read by this process");
            throw new ResourceException("SVN working copy directory " + directory.getAbsolutePath() + " can not be read by this process");
        }
        if (!directory.canWrite()) {
            this.log.error("SVN working copy directory " + directory.getAbsolutePath() + " can not be written to by this process");
            throw new ResourceException("SVN working copy directory " + directory.getAbsolutePath() + " can not be written to by this process");
        }
    }

    protected void checkoutOrUpdateResource() throws ResourceException {
        SVNUpdateClient client = this.clientManager.getUpdateClient();
        client.setIgnoreExternals(false);
        File svnMetadataDir = new File(this.workingCopy, ".svn");
        if (!svnMetadataDir.exists()) {
            try {
                client.doCheckout(this.remoteRepository, this.workingCopy, this.revision, this.revision, SVNDepth.INFINITY, true);
            }
            catch (SVNException e) {
                String errMsg = "Unable to check out revsion " + this.revision.toString() + " from remote repository " + this.remoteRepository.toDecodedString() + " to local working directory " + this.workingCopy.getAbsolutePath();
                this.log.error(errMsg, (Throwable)e);
                throw new ResourceException(errMsg, (Exception)((Object)e));
            }
        }
        try {
            client.doUpdate(this.workingCopy, this.revision, SVNDepth.INFINITY, true, true);
        }
        catch (SVNException e) {
            String errMsg = "Unable to update working copy of resoure " + this.remoteRepository.toDecodedString() + " in working copy " + this.workingCopy.getAbsolutePath() + " to revsion " + this.revision.toString();
            this.log.error(errMsg, (Throwable)e);
            throw new ResourceException(errMsg, (Exception)((Object)e));
        }
    }

    protected File getResourceFile() {
        return new File(this.workingCopy, this.resourceFileName);
    }
}

