/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.profile.provider;

import edu.internet2.middleware.shibboleth.common.profile.AbstractErrorHandler;
import edu.internet2.middleware.shibboleth.common.util.StringResourceLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.util.StringResourceRepository;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.ws.transport.OutTransport;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VelocityErrorHandler
extends AbstractErrorHandler {
    private final Logger log = LoggerFactory.getLogger(VelocityErrorHandler.class);
    private VelocityEngine velocityEngine;
    private String templatePath;

    public VelocityErrorHandler(VelocityEngine engine, String template) {
        if (engine == null) {
            this.log.error("Velocity engine may not be null");
            throw new IllegalArgumentException("Velocity engine may not be null");
        }
        this.velocityEngine = engine;
        this.templatePath = DatatypeHelper.safeTrimOrNullString((String)template);
        if (this.templatePath == null) {
            this.log.error("Velocity template path may not be null or empty");
            throw new IllegalArgumentException("Velocity template path may not be null or empty");
        }
    }

    public void initialize() throws IOException {
        String templateString = DatatypeHelper.inputstreamToString((InputStream)this.getClass().getResourceAsStream(this.templatePath), null);
        StringResourceRepository repository = StringResourceLoader.getRepository();
        repository.putStringResource(this.templatePath, templateString);
    }

    public void processRequest(InTransport in, OutTransport out) {
        VelocityContext context = new VelocityContext();
        context.put("requestError", in.getAttribute("error"));
        try {
            OutputStreamWriter responseWriter = new OutputStreamWriter(out.getOutgoingStream());
            Template template = this.velocityEngine.getTemplate(this.templatePath);
            template.merge((Context)context, (Writer)responseWriter);
            responseWriter.flush();
        }
        catch (Throwable t) {
            this.log.error("Unable to evaluate velocity error template", t);
        }
    }
}

