/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.profile;

import edu.internet2.middleware.shibboleth.common.log.AccessLogEntry;
import edu.internet2.middleware.shibboleth.common.profile.AbstractErrorHandler;
import edu.internet2.middleware.shibboleth.common.profile.NoProfileHandlerException;
import edu.internet2.middleware.shibboleth.common.profile.ProfileException;
import edu.internet2.middleware.shibboleth.common.profile.ProfileHandler;
import edu.internet2.middleware.shibboleth.common.profile.ProfileHandlerManager;
import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.ws.transport.OutTransport;
import org.opensaml.ws.transport.http.HttpServletRequestAdapter;
import org.opensaml.ws.transport.http.HttpServletResponseAdapter;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileRequestDispatcherServlet
extends HttpServlet {
    private static final long serialVersionUID = 3750548606378986211L;
    private final Logger log = LoggerFactory.getLogger(ProfileRequestDispatcherServlet.class);
    private final Logger accessLog = LoggerFactory.getLogger((String)"Shibboleth-Access");
    private ProfileHandlerManager handlerManager;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String handlerManagerId = config.getInitParameter("handlerManagerId");
        if (DatatypeHelper.isEmpty((String)handlerManagerId)) {
            handlerManagerId = "shibboleth.HandlerManager";
        }
        this.handlerManager = (ProfileHandlerManager)this.getServletContext().getAttribute(handlerManagerId);
    }

    protected void service(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException, IOException {
        if (this.accessLog.isInfoEnabled()) {
            AccessLogEntry accessEntry = new AccessLogEntry(httpRequest);
            this.accessLog.info(accessEntry.toString());
        }
        HttpServletRequestAdapter profileReq = new HttpServletRequestAdapter(httpRequest);
        HttpServletResponseAdapter profileResp = new HttpServletResponseAdapter(httpResponse, httpRequest.isSecure());
        AbstractErrorHandler errorHandler = this.handlerManager.getErrorHandler();
        ProfileHandler handler = this.handlerManager.getProfileHandler((ServletRequest)httpRequest);
        if (handler != null) {
            try {
                handler.processRequest(profileReq, profileResp);
                return;
            }
            catch (ProfileException e) {
                httpRequest.setAttribute("error", (Object)e);
            }
            catch (Throwable t) {
                this.log.error("Error occured while processing request", t);
            }
        } else {
            this.log.warn("No profile handler configured for request at path: {}", (Object)httpRequest.getPathInfo());
            httpRequest.setAttribute("error", (Object)new NoProfileHandlerException("No profile handler configured for request at path: " + URLEncoder.encode(httpRequest.getPathInfo(), "UTF-8")));
        }
        errorHandler.processRequest((InTransport)profileReq, (OutTransport)profileResp);
    }
}

