/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.log;

import edu.internet2.middleware.shibboleth.common.util.HttpHelper;
import javax.servlet.http.HttpServletRequest;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.opensaml.xml.util.DatatypeHelper;

public class AccessLogEntry {
    public static final String ACCESS_LOGGER_NAME = "Shibboleth-Access";
    private static DateTimeFormatter dateFormatter = ISODateTimeFormat.basicDateTimeNoMillis();
    private DateTime requestTime = new DateTime();
    private String remoteHost;
    private String serverHost;
    private int serverPort;
    private String requestPath;

    public AccessLogEntry(HttpServletRequest request) {
        this.remoteHost = request.getRemoteHost();
        this.serverHost = request.getServerName();
        this.serverPort = request.getServerPort();
        this.requestPath = HttpHelper.getRequestUriWithoutContext(request);
    }

    public AccessLogEntry(String remote, String host, int port, String path) {
        this.remoteHost = DatatypeHelper.safeTrimOrNullString((String)remote);
        this.serverHost = DatatypeHelper.safeTrimOrNullString((String)host);
        this.serverPort = port;
        this.requestPath = DatatypeHelper.safeTrimOrNullString((String)path);
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public String getRequestPath() {
        return this.requestPath;
    }

    public DateTime getRequestTime() {
        return this.requestTime;
    }

    public String getServerHost() {
        return this.serverHost;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public String toString() {
        StringBuilder entryString = new StringBuilder();
        entryString.append(this.getRequestTime().toString(dateFormatter.withZone(DateTimeZone.UTC)));
        entryString.append("|");
        entryString.append(this.getRemoteHost());
        entryString.append("|");
        entryString.append(this.getServerHost());
        entryString.append(":");
        entryString.append(this.getServerPort());
        entryString.append("|");
        entryString.append(this.getRequestPath());
        entryString.append("|");
        return entryString.toString();
    }
}

