/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config.service;

import edu.internet2.middleware.shibboleth.common.config.service.AbstractServiceBeanDefinitionParser;
import org.opensaml.xml.util.DatatypeHelper;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public abstract class AbstractReloadableServiceBeanDefinitionParser
extends AbstractServiceBeanDefinitionParser {
    protected void doParse(Element configElement, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(configElement, parserContext, builder);
        if (configElement.hasAttributeNS(null, "configurationResourcePollingFrequency") && configElement.hasAttributeNS(null, "configurationResourcePollingRetryAttempts")) {
            builder.addPropertyReference("pollingTimer", configElement.getAttributeNS(null, "timerId"));
            long frequency = Integer.parseInt(DatatypeHelper.safeTrimOrNullString((String)configElement.getAttributeNS(null, "configurationResourcePollingFrequency")));
            builder.addPropertyValue("pollingFrequency", (Object)frequency);
            int retryAttempts = 0;
            if (configElement.hasAttributeNS(null, "configurationResourcePollingRetryAttempts")) {
                retryAttempts = Integer.parseInt(DatatypeHelper.safeTrimOrNullString((String)configElement.getAttributeNS(null, "configurationResourcePollingRetryAttempts")));
            }
            if (retryAttempts < 1) {
                retryAttempts = 3;
            }
            builder.addPropertyValue("pollingRetryAttempts", (Object)retryAttempts);
        }
    }
}

