/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config.security;

import java.util.ArrayList;
import java.util.List;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.CredentialResolver;
import org.opensaml.xml.security.credential.StaticCredentialResolver;
import org.opensaml.xml.security.keyinfo.BasicProviderKeyInfoCredentialResolver;
import org.opensaml.xml.security.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xml.security.keyinfo.provider.DSAKeyValueProvider;
import org.opensaml.xml.security.keyinfo.provider.InlineX509DataProvider;
import org.opensaml.xml.security.keyinfo.provider.RSAKeyValueProvider;
import org.opensaml.xml.signature.impl.ExplicitKeySignatureTrustEngine;
import org.springframework.beans.factory.config.AbstractFactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticExplicitKeySignatureTrustEngineFactoryBean
extends AbstractFactoryBean {
    private List<Credential> credentials;

    public List<Credential> getCredentials() {
        return this.credentials;
    }

    public void setCredentials(List<Credential> newCredentials) {
        this.credentials = newCredentials;
    }

    public Class getObjectType() {
        return ExplicitKeySignatureTrustEngine.class;
    }

    protected Object createInstance() throws Exception {
        StaticCredentialResolver credResolver = new StaticCredentialResolver(this.getCredentials());
        ArrayList<Object> keyInfoProviders = new ArrayList<Object>();
        keyInfoProviders.add(new DSAKeyValueProvider());
        keyInfoProviders.add(new RSAKeyValueProvider());
        keyInfoProviders.add(new InlineX509DataProvider());
        BasicProviderKeyInfoCredentialResolver keyInfoCredResolver = new BasicProviderKeyInfoCredentialResolver(keyInfoProviders);
        return new ExplicitKeySignatureTrustEngine((CredentialResolver)credResolver, (KeyInfoCredentialResolver)keyInfoCredResolver);
    }
}

