/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config.attribute.resolver.dataConnector;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import edu.internet2.middleware.shibboleth.common.config.attribute.resolver.dataConnector.BaseDataConnectorBeanDefinitionParser;
import edu.internet2.middleware.shibboleth.common.config.attribute.resolver.dataConnector.StoredIDDataConnectorBeanFactory;
import java.beans.PropertyVetoException;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.xml.namespace.QName;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoredIDDataConnectorBeanDefinitionParser
extends BaseDataConnectorBeanDefinitionParser {
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:resolver:dc", "StoredId");
    private final Logger log = LoggerFactory.getLogger(StoredIDDataConnectorBeanDefinitionParser.class);

    protected Class getBeanClass(Element element) {
        return StoredIDDataConnectorBeanFactory.class;
    }

    @Override
    protected void doParse(String pluginId, Element pluginConfig, Map<QName, List<Element>> pluginConfigChildren, BeanDefinitionBuilder pluginBuilder, ParserContext parserContext) {
        super.doParse(pluginId, pluginConfig, pluginConfigChildren, pluginBuilder, parserContext);
        if (pluginConfig.hasAttributeNS(null, "generatedAttributeID")) {
            pluginBuilder.addPropertyValue("generatedAttribute", (Object)pluginConfig.getAttributeNS(null, "generatedAttributeID"));
        } else {
            pluginBuilder.addPropertyValue("generatedAttribute", (Object)"storedId");
        }
        pluginBuilder.addPropertyValue("sourceAttribute", (Object)pluginConfig.getAttributeNS(null, "sourceAttributeID"));
        pluginBuilder.addPropertyValue("salt", (Object)pluginConfig.getAttributeNS(null, "salt").getBytes());
        DataSource connectionSource = this.processConnectionManagement(pluginId, pluginConfigChildren, pluginBuilder);
        pluginBuilder.addPropertyValue("datasource", (Object)connectionSource);
    }

    protected DataSource processConnectionManagement(String pluginId, Map<QName, List<Element>> pluginConfigChildren, BeanDefinitionBuilder pluginBuilder) {
        List<Element> cmc = pluginConfigChildren.get(new QName("urn:mace:shibboleth:2.0:resolver:dc", "ContainerManagedConnection"));
        if (cmc != null && cmc.get(0) != null) {
            return this.buildContainerManagedConnection(pluginId, cmc.get(0));
        }
        return this.buildApplicationManagedConnection(pluginId, pluginConfigChildren.get(new QName("urn:mace:shibboleth:2.0:resolver:dc", "ApplicationManagedConnection")).get(0));
    }

    protected DataSource buildContainerManagedConnection(String pluginId, Element cmc) {
        String jndiResource = cmc.getAttributeNS(null, "resourceName");
        jndiResource = DatatypeHelper.safeTrim((String)jndiResource);
        Hashtable<String, String> initCtxProps = this.buildProperties(XMLHelper.getChildElementsByTagNameNS((Element)cmc, (String)"urn:mace:shibboleth:2.0:resolver:dc", (String)"JNDIConnectionProperty"));
        try {
            InitialContext initCtx = new InitialContext(initCtxProps);
            DataSource dataSource = (DataSource)initCtx.lookup(jndiResource);
            if (dataSource == null) {
                this.log.error("DataSource " + jndiResource + " did not exist in JNDI directory");
                throw new BeanCreationException("DataSource " + jndiResource + " did not exist in JNDI directory");
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Retrieved data source for data connector {} from JNDI location {} using properties ", (Object)pluginId, initCtxProps);
            }
            return dataSource;
        }
        catch (NamingException e) {
            this.log.error("Unable to retrieve data source for data connector " + pluginId + " from JNDI location " + jndiResource + " using properties " + initCtxProps, (Throwable)e);
            return null;
        }
    }

    protected DataSource buildApplicationManagedConnection(String pluginId, Element amc) {
        ComboPooledDataSource datasource = new ComboPooledDataSource();
        String driverClass = DatatypeHelper.safeTrim((String)amc.getAttributeNS(null, "jdbcDriver"));
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        try {
            classLoader.loadClass(driverClass);
        }
        catch (ClassNotFoundException e) {
            this.log.error("Unable to create relational database connector, JDBC driver can not be found on the classpath");
            throw new BeanCreationException("Unable to create relational database connector, JDBC driver can not be found on the classpath");
        }
        try {
            datasource.setDriverClass(driverClass);
            datasource.setJdbcUrl(DatatypeHelper.safeTrim((String)amc.getAttributeNS(null, "jdbcURL")));
            datasource.setUser(DatatypeHelper.safeTrim((String)amc.getAttributeNS(null, "jdbcUserName")));
            datasource.setPassword(DatatypeHelper.safeTrim((String)amc.getAttributeNS(null, "jdbcPassword")));
            if (amc.hasAttributeNS(null, "poolAcquireIncrement")) {
                datasource.setAcquireIncrement(Integer.parseInt(DatatypeHelper.safeTrim((String)amc.getAttributeNS(null, "poolAcquireIncrement"))));
            } else {
                datasource.setAcquireIncrement(3);
            }
            if (amc.hasAttributeNS(null, "poolAcquireRetryAttempts")) {
                datasource.setAcquireRetryAttempts(Integer.parseInt(DatatypeHelper.safeTrim((String)amc.getAttributeNS(null, "poolAcquireRetryAttempts"))));
            } else {
                datasource.setAcquireRetryAttempts(36);
            }
            if (amc.hasAttributeNS(null, "poolAcquireRetryDelay")) {
                datasource.setAcquireRetryDelay(Integer.parseInt(DatatypeHelper.safeTrim((String)amc.getAttributeNS(null, "poolAcquireRetryDelay"))));
            } else {
                datasource.setAcquireRetryDelay(5000);
            }
            if (amc.hasAttributeNS(null, "poolBreakAfterAcquireFailure")) {
                datasource.setBreakAfterAcquireFailure(XMLHelper.getAttributeValueAsBoolean((Attr)amc.getAttributeNodeNS(null, "poolBreakAfterAcquireFailure")).booleanValue());
            } else {
                datasource.setBreakAfterAcquireFailure(true);
            }
            if (amc.hasAttributeNS(null, "poolMinSize")) {
                datasource.setMinPoolSize(Integer.parseInt(DatatypeHelper.safeTrim((String)amc.getAttributeNS(null, "poolMinSize"))));
            } else {
                datasource.setMinPoolSize(2);
            }
            if (amc.hasAttributeNS(null, "poolMaxSize")) {
                datasource.setMaxPoolSize(Integer.parseInt(DatatypeHelper.safeTrim((String)amc.getAttributeNS(null, "poolMaxSize"))));
            } else {
                datasource.setMaxPoolSize(50);
            }
            if (amc.hasAttributeNS(null, "poolMaxIdleTime")) {
                datasource.setMaxIdleTime(Integer.parseInt(DatatypeHelper.safeTrim((String)amc.getAttributeNS(null, "poolMaxIdleTime"))));
            } else {
                datasource.setMaxIdleTime(600);
            }
            if (amc.hasAttributeNS(null, "poolIdleTestPeriod")) {
                datasource.setIdleConnectionTestPeriod(Integer.parseInt(DatatypeHelper.safeTrim((String)amc.getAttributeNS(null, "poolIdleTestPeriod"))));
            } else {
                datasource.setIdleConnectionTestPeriod(180);
            }
            this.log.debug("Created application managed data source for data connector {}", (Object)pluginId);
            return datasource;
        }
        catch (PropertyVetoException e) {
            this.log.error("Unable to create data source for data connector {} with JDBC driver class {}", (Object)pluginId, (Object)driverClass);
            return null;
        }
    }

    protected Hashtable<String, String> buildProperties(List<Element> propertyElements) {
        if (propertyElements == null || propertyElements.size() < 1) {
            return null;
        }
        Hashtable<String, String> properties = new Hashtable<String, String>();
        for (Element propertyElement : propertyElements) {
            String propName = DatatypeHelper.safeTrim((String)propertyElement.getAttributeNS(null, "name"));
            String propValue = DatatypeHelper.safeTrim((String)propertyElement.getAttributeNS(null, "value"));
            properties.put(propName, propValue);
        }
        return properties;
    }
}

