/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config.attribute.resolver.dataConnector;

import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.RDBMSColumnDescriptor;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.RDBMSDataConnector;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.TemplateEngine;
import edu.internet2.middleware.shibboleth.common.config.attribute.resolver.dataConnector.BaseDataConnectorFactoryBean;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.opensaml.xml.util.DatatypeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RDBMSDataConnectorFactoryBean
extends BaseDataConnectorFactoryBean {
    private TemplateEngine templateEngine;
    private DataSource connectionDataSource;
    private String queryTemplate;
    private List<RDBMSColumnDescriptor> columnDescriptors;
    private boolean readOnlyConnections;
    private boolean queryUsesStoredProcedures;
    private boolean noResultsIsError;
    private boolean cacheResults;

    public Class getObjectType() {
        return RDBMSDataConnector.class;
    }

    public boolean isNoResultIsError() {
        return this.noResultsIsError;
    }

    public void setNoResultIsError(boolean b) {
        this.noResultsIsError = b;
    }

    public boolean getCacheResults() {
        return this.cacheResults;
    }

    public void setCacheResults(boolean cache) {
        this.cacheResults = cache;
    }

    public List<RDBMSColumnDescriptor> getColumnDescriptors() {
        return this.columnDescriptors;
    }

    public void setColumnDescriptors(List<RDBMSColumnDescriptor> descriptors) {
        this.columnDescriptors = descriptors;
    }

    public DataSource getConnectionDataSource() {
        return this.connectionDataSource;
    }

    public void setConnectionDataSource(DataSource source) {
        this.connectionDataSource = source;
    }

    public String getQueryTemplate() {
        return this.queryTemplate;
    }

    public void setQueryTemplate(String template) {
        this.queryTemplate = DatatypeHelper.safeTrimOrNullString((String)template);
    }

    public boolean getQueryUsesStoredProcedures() {
        return this.queryUsesStoredProcedures;
    }

    public void setQueryUsesStoredProcedures(boolean storedProcedures) {
        this.queryUsesStoredProcedures = storedProcedures;
    }

    public boolean isReadOnlyConnections() {
        return this.readOnlyConnections;
    }

    public void setReadOnlyConnections(boolean readOnly) {
        this.readOnlyConnections = readOnly;
    }

    public TemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    public void setTemplateEngine(TemplateEngine engine) {
        this.templateEngine = engine;
    }

    protected Object createInstance() throws Exception {
        RDBMSDataConnector connector = new RDBMSDataConnector(this.getConnectionDataSource(), this.getCacheResults());
        this.populateDataConnector(connector);
        connector.setTemplateEngine(this.getTemplateEngine());
        connector.setQueryTemplate(this.getQueryTemplate());
        connector.setUsesStoredProcedure(this.getQueryUsesStoredProcedures());
        connector.setConnectionReadOnly(this.isReadOnlyConnections());
        connector.setNoResultIsError(this.isNoResultIsError());
        if (this.getColumnDescriptors() != null) {
            Map<String, RDBMSColumnDescriptor> columnDecriptors = connector.getColumnDescriptor();
            for (RDBMSColumnDescriptor descriptor : this.getColumnDescriptors()) {
                columnDecriptors.put(descriptor.getColumnName(), descriptor);
            }
        }
        connector.initialize();
        return connector;
    }
}

