/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config.attribute.resolver;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResolutionPlugInBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    public static final QName DEPENDENCY_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:resolver", "Dependency");
    private final Logger log = LoggerFactory.getLogger(AbstractResolutionPlugInBeanDefinitionParser.class);

    protected final void doParse(Element config, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String pluginId = DatatypeHelper.safeTrimOrNullString((String)config.getAttributeNS(null, "id"));
        this.log.info("Parsing configuration for {} plugin with ID: {}", (Object)config.getLocalName(), (Object)pluginId);
        builder.addPropertyValue("pluginId", (Object)pluginId);
        Map children = XMLHelper.getChildElements((Element)config);
        List<String> dependencyIds = this.parseDependencies((List)children.get(DEPENDENCY_ELEMENT_NAME));
        this.log.debug("Setting the following attribute definition dependencies for plugin {}: {}", (Object)pluginId, dependencyIds);
        builder.addPropertyValue("dependencyIds", dependencyIds);
        this.doParse(pluginId, config, children, builder, parserContext);
    }

    protected abstract void doParse(String var1, Element var2, Map<QName, List<Element>> var3, BeanDefinitionBuilder var4, ParserContext var5);

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) {
        return element.getAttributeNS(null, "id");
    }

    protected List<String> parseDependencies(List<Element> elements) {
        if (elements == null || elements.size() == 0) {
            return null;
        }
        ArrayList<String> dependencyIds = new ArrayList<String>();
        for (Element dependency : elements) {
            dependencyIds.add(DatatypeHelper.safeTrimOrNullString((String)dependency.getAttributeNS(null, "ref")));
        }
        return dependencyIds;
    }
}

