/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config;

import java.util.List;
import org.opensaml.DefaultBootstrap;
import org.opensaml.util.resource.Resource;
import org.opensaml.xml.XMLConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpensamlConfigBean
implements InitializingBean {
    private final Logger log = LoggerFactory.getLogger(OpensamlConfigBean.class);
    private List<Resource> configResources;

    public OpensamlConfigBean(List<Resource> configs) {
        this.configResources = configs;
    }

    public void afterPropertiesSet() throws Exception {
        DefaultBootstrap.bootstrap();
        if (this.configResources != null && !this.configResources.isEmpty()) {
            XMLConfigurator configurator = new XMLConfigurator();
            for (Resource config : this.configResources) {
                try {
                    this.log.debug("Loading OpenSAML configuration file: {}", (Object)config.getLocation());
                    configurator.load(config.getInputStream());
                }
                catch (Exception e) {
                    this.log.error("Unable to load OpenSAML configuration file: " + config.getLocation());
                }
            }
        }
    }
}

