/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.xml.BeanDefinitionDecorator;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandler;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class BaseSpringNamespaceHandler
implements NamespaceHandler {
    private final Logger log = LoggerFactory.getLogger(BaseSpringNamespaceHandler.class);
    private Map<QName, BeanDefinitionParser> parsers = new HashMap<QName, BeanDefinitionParser>();
    private Map<QName, BeanDefinitionDecorator> decorators = new HashMap<QName, BeanDefinitionDecorator>();
    private Map<QName, BeanDefinitionDecorator> attributeDecorators = new HashMap<QName, BeanDefinitionDecorator>();

    public BeanDefinitionHolder decorate(Node node, BeanDefinitionHolder definition, ParserContext parserContext) {
        return this.findDecoratorForNode(node).decorate(node, definition, parserContext);
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        return this.findParserForElement(element).parse(element, parserContext);
    }

    protected BeanDefinitionParser findParserForElement(Element element) {
        BeanDefinitionParser parser = null;
        QName parserId = XMLHelper.getXSIType((Element)element);
        if (parserId != null) {
            this.log.trace("Attempting to find parser for element of type: {}", (Object)parserId);
            parser = this.parsers.get(parserId);
        }
        if (parser == null) {
            parserId = XMLHelper.getNodeQName((Node)element);
            this.log.trace("Attempting to find parser with element name: {}", (Object)parserId);
            parser = this.parsers.get(parserId);
        }
        if (parser == null) {
            this.log.error("Cannot locate BeanDefinitionParser for element: " + parserId);
            throw new IllegalArgumentException("Cannot locate BeanDefinitionParser for element: " + parserId);
        }
        return parser;
    }

    protected BeanDefinitionDecorator findDecoratorForNode(Node node) {
        BeanDefinitionDecorator decorator = null;
        if (node instanceof Element) {
            decorator = this.decorators.get(XMLHelper.getXSIType((Element)((Element)node)));
            if (decorator == null) {
                decorator = this.decorators.get(XMLHelper.getNodeQName((Node)node));
            }
        } else if (node instanceof Attr) {
            decorator = this.attributeDecorators.get(node.getLocalName());
        } else {
            throw new IllegalArgumentException("Cannot decorate based on Nodes of type [" + node.getClass().getName() + "]");
        }
        if (decorator == null) {
            throw new IllegalArgumentException("Cannot locate BeanDefinitionDecorator for  [" + node.getLocalName() + "]");
        }
        return decorator;
    }

    protected void registerBeanDefinitionParser(QName elementNameOrType, BeanDefinitionParser parser) {
        this.parsers.put(elementNameOrType, parser);
    }

    protected void registerBeanDefinitionDecorator(QName elementNameOrType, BeanDefinitionDecorator decorator) {
        this.decorators.put(elementNameOrType, decorator);
    }

    protected void registerBeanDefinitionDecoratorForAttribute(QName attributeName, BeanDefinitionDecorator decorator) {
        this.attributeDecorators.put(attributeName, decorator);
    }
}

