/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector;

import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.provider.BasicAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.AttributeResolutionException;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.ShibbolethResolutionContext;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.BaseDataConnector;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.TemplateEngine;
import edu.internet2.middleware.shibboleth.common.session.LogoutEvent;
import edu.vt.middleware.ldap.Ldap;
import edu.vt.middleware.ldap.LdapConfig;
import edu.vt.middleware.ldap.LdapPool;
import edu.vt.middleware.ldap.LdapUtil;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.opensaml.xml.security.x509.X509Credential;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapDataConnector
extends BaseDataConnector
implements ApplicationListener {
    private static Logger log = LoggerFactory.getLogger(LdapDataConnector.class);
    private TrustManager[] sslTrustManagers;
    private KeyManager[] sslKeyManagers;
    private boolean mergeMultipleResults;
    private boolean noResultsIsError;
    private boolean cacheResults;
    private TemplateEngine filterCreator;
    private String filterTemplateName;
    private String filterTemplate;
    private String[] returnAttributes;
    private LdapConfig ldapConfig;
    private LdapPool ldapPool;
    private int poolMaxIdle;
    private int poolInitIdleCapacity;
    private Map<String, Map<String, Map<String, BaseAttribute>>> cache;
    private boolean initialized;
    private final LDAPValueEscapingStrategy escapingStrategy;

    public LdapDataConnector(String ldapUrl, String ldapBaseDn, boolean startTls, int maxIdle, int initIdleCapacity) {
        this.ldapConfig = new LdapConfig(ldapUrl, ldapBaseDn);
        this.ldapConfig.useTls(startTls);
        this.poolMaxIdle = maxIdle;
        this.poolInitIdleCapacity = initIdleCapacity;
        this.escapingStrategy = new LDAPValueEscapingStrategy();
    }

    public void initialize() {
        this.initialized = true;
        this.registerTemplate();
        this.initializeLdapPool();
        this.initializeCache();
    }

    protected void initializeLdapPool() {
        if (this.initialized) {
            this.ldapPool = new LdapPool(this.ldapConfig, this.poolMaxIdle, this.poolInitIdleCapacity);
        }
    }

    protected void initializeCache() {
        if (this.cacheResults && this.initialized) {
            this.cache = new HashMap<String, Map<String, Map<String, BaseAttribute>>>();
        }
    }

    protected void clearCache() {
        if (this.cacheResults && this.initialized) {
            this.cache.clear();
        }
    }

    protected void registerTemplate() {
        if (this.initialized) {
            this.filterTemplateName = "shibboleth.resolver.dc." + this.getId();
            this.filterCreator.registerTemplate(this.filterTemplateName, this.filterTemplate);
        }
    }

    public boolean isMergeResults() {
        return this.mergeMultipleResults;
    }

    public void setMergeResults(boolean b) {
        this.mergeMultipleResults = b;
        this.clearCache();
    }

    public boolean isCacheResults() {
        return this.cacheResults;
    }

    public void setCacheResults(boolean b) {
        this.cacheResults = b;
        if (!this.cacheResults) {
            this.cache = null;
        } else {
            this.initializeCache();
        }
    }

    public boolean isNoResultsIsError() {
        return this.noResultsIsError;
    }

    public void setNoResultsIsError(boolean b) {
        this.noResultsIsError = b;
    }

    public TemplateEngine getTemplateEngine() {
        return this.filterCreator;
    }

    public void setTemplateEngine(TemplateEngine engine) {
        this.filterCreator = engine;
        this.registerTemplate();
        this.clearCache();
    }

    public String getFilterTemplate() {
        return this.filterTemplate;
    }

    public void setFilterTemplate(String template) {
        this.filterTemplate = template;
        this.clearCache();
    }

    public String getLdapUrl() {
        return this.ldapConfig.getHost();
    }

    public String getBaseDn() {
        return this.ldapConfig.getBase();
    }

    public boolean isUseStartTls() {
        return this.ldapConfig.isTlsEnabled();
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.ldapConfig.getSslSocketFactory();
    }

    public void setSslSocketFactory(SSLSocketFactory sf) {
        this.ldapConfig.setSslSocketFactory(sf);
        this.clearCache();
        this.initializeLdapPool();
    }

    public TrustManager[] getSslTrustManagers() {
        return this.sslTrustManagers;
    }

    public void setSslTrustManagers(X509Credential tc) {
        if (tc != null) {
            try {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                keystore.load(null, null);
                for (X509Certificate c : tc.getEntityCertificateChain()) {
                    keystore.setCertificateEntry("ldap_tls_trust_" + c.getSerialNumber(), c);
                }
                tmf.init(keystore);
                this.sslTrustManagers = tmf.getTrustManagers();
                SSLContext ctx = SSLContext.getInstance("TLS");
                ctx.init(this.sslKeyManagers, this.sslTrustManagers, null);
                this.ldapConfig.setSslSocketFactory(ctx.getSocketFactory());
                this.clearCache();
                this.initializeLdapPool();
            }
            catch (GeneralSecurityException e) {
                log.error("Error initializing trust managers", (Throwable)e);
            }
            catch (IOException e) {
                log.error("Error initializing trust managers", (Throwable)e);
            }
        }
    }

    public KeyManager[] getSslKeyManagers() {
        return this.sslKeyManagers;
    }

    public void setSslKeyManagers(X509Credential kc) {
        if (kc != null) {
            try {
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                keystore.load(null, null);
                keystore.setKeyEntry("ldap_tls_client_auth", kc.getPrivateKey(), "changeit".toCharArray(), kc.getEntityCertificateChain().toArray(new X509Certificate[0]));
                kmf.init(keystore, "changeit".toCharArray());
                this.sslKeyManagers = kmf.getKeyManagers();
                SSLContext ctx = SSLContext.getInstance("TLS");
                ctx.init(this.sslKeyManagers, this.sslTrustManagers, null);
                this.ldapConfig.setSslSocketFactory(ctx.getSocketFactory());
                this.clearCache();
                this.initializeLdapPool();
            }
            catch (GeneralSecurityException e) {
                log.error("Error initializing key managers", (Throwable)e);
            }
            catch (IOException e) {
                log.error("Error initializing key managers", (Throwable)e);
            }
        }
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.ldapConfig.getHostnameVerifier();
    }

    public void setHostnameVerifier(HostnameVerifier hv) {
        this.ldapConfig.setHostnameVerifier(hv);
        this.clearCache();
        this.initializeLdapPool();
    }

    public AUTHENTICATION_TYPE getAuthenticationType() {
        AUTHENTICATION_TYPE type = null;
        if (this.ldapConfig.isAnonymousAuth()) {
            type = AUTHENTICATION_TYPE.ANONYMOUS;
        } else if (this.ldapConfig.isSimpleAuth()) {
            type = AUTHENTICATION_TYPE.SIMPLE;
        } else if (this.ldapConfig.isStrongAuth()) {
            type = AUTHENTICATION_TYPE.STRONG;
        } else if (this.ldapConfig.isExternalAuth()) {
            type = AUTHENTICATION_TYPE.EXTERNAL;
        } else if (this.ldapConfig.isDigestMD5Auth()) {
            type = AUTHENTICATION_TYPE.DIGEST_MD5;
        } else if (this.ldapConfig.isCramMD5Auth()) {
            type = AUTHENTICATION_TYPE.CRAM_MD5;
        } else if (this.ldapConfig.isGSSAPIAuth()) {
            type = AUTHENTICATION_TYPE.GSSAPI;
        }
        return type;
    }

    public void setAuthenticationType(AUTHENTICATION_TYPE type) {
        if (type == AUTHENTICATION_TYPE.ANONYMOUS) {
            this.ldapConfig.useAnonymousAuth();
        } else if (type == AUTHENTICATION_TYPE.SIMPLE) {
            this.ldapConfig.useSimpleAuth();
        } else if (type == AUTHENTICATION_TYPE.STRONG) {
            this.ldapConfig.useStrongAuth();
        } else if (type == AUTHENTICATION_TYPE.EXTERNAL) {
            this.ldapConfig.useExternalAuth();
        } else if (type == AUTHENTICATION_TYPE.DIGEST_MD5) {
            this.ldapConfig.useDigestMD5Auth();
        } else if (type == AUTHENTICATION_TYPE.CRAM_MD5) {
            this.ldapConfig.useCramMD5Auth();
        } else if (type == AUTHENTICATION_TYPE.GSSAPI) {
            this.ldapConfig.useGSSAPIAuth();
        }
        this.clearCache();
        this.initializeLdapPool();
    }

    public SEARCH_SCOPE getSearchScope() {
        SEARCH_SCOPE scope = null;
        if (this.ldapConfig.isObjectSearchScope()) {
            scope = SEARCH_SCOPE.OBJECT;
        } else if (this.ldapConfig.isOneLevelSearchScope()) {
            scope = SEARCH_SCOPE.ONELEVEL;
        } else if (this.ldapConfig.isSubTreeSearchScope()) {
            scope = SEARCH_SCOPE.SUBTREE;
        }
        return scope;
    }

    public void setSearchScope(SEARCH_SCOPE scope) {
        if (scope == SEARCH_SCOPE.OBJECT) {
            this.ldapConfig.useObjectSearchScope();
        } else if (scope == SEARCH_SCOPE.SUBTREE) {
            this.ldapConfig.useSubTreeSearchScope();
        } else if (scope == SEARCH_SCOPE.ONELEVEL) {
            this.ldapConfig.useOneLevelSearchScope();
        }
        this.clearCache();
    }

    public String[] getReturnAttributes() {
        return this.returnAttributes;
    }

    public void setReturnAttributes(String[] s) {
        this.returnAttributes = s;
        this.clearCache();
    }

    public void setReturnAttributes(String s) {
        StringTokenizer st = new StringTokenizer(s, ",");
        String[] ra = new String[st.countTokens()];
        for (int count = 0; count < st.countTokens(); ++count) {
            ra[count] = st.nextToken();
        }
        this.setReturnAttributes(ra);
    }

    public int getSearchTimeLimit() {
        return this.ldapConfig.getTimeLimit();
    }

    public void setSearchTimeLimit(int i) {
        this.ldapConfig.setTimeLimit(i);
        this.clearCache();
    }

    public long getMaxResultSize() {
        return this.ldapConfig.getCountLimit();
    }

    public void setMaxResultSize(long l) {
        this.ldapConfig.setCountLimit(l);
        this.clearCache();
    }

    public boolean isReturningObjects() {
        return this.ldapConfig.getReturningObjFlag();
    }

    public void setReturningObjects(boolean b) {
        this.ldapConfig.setReturningObjFlag(b);
        this.clearCache();
    }

    public boolean isLinkDereferencing() {
        return this.ldapConfig.getDerefLinkFlag();
    }

    public void setLinkDereferencing(boolean b) {
        this.ldapConfig.setDerefLinkFlag(b);
        this.clearCache();
    }

    public String getPrincipal() {
        return this.ldapConfig.getServiceUser();
    }

    public void setPrincipal(String s) {
        this.ldapConfig.setServiceUser(s);
        this.clearCache();
        this.initializeLdapPool();
    }

    public String getPrincipalCredential() {
        return (String)this.ldapConfig.getServiceCredential();
    }

    public void setPrincipalCredential(String s) {
        this.ldapConfig.setServiceCredential(s);
        this.clearCache();
        this.initializeLdapPool();
    }

    public void setLdapProperties(Map<String, String> ldapProperties) {
        for (Map.Entry<String, String> entry : ldapProperties.entrySet()) {
            this.ldapConfig.setEnvironmentProperties(entry.getKey(), entry.getValue());
        }
        this.clearCache();
        this.initializeLdapPool();
    }

    public void onApplicationEvent(ApplicationEvent evt) {
        if (evt instanceof LogoutEvent) {
            LogoutEvent logoutEvent = (LogoutEvent)evt;
            this.cache.remove(logoutEvent.getUserSession().getPrincipalName());
        }
    }

    @Override
    public Map<String, BaseAttribute> resolve(ShibbolethResolutionContext resolutionContext) throws AttributeResolutionException {
        String searchFilter = this.filterCreator.createStatement(this.filterTemplateName, resolutionContext, this.getDependencyIds(), this.escapingStrategy);
        searchFilter = searchFilter.trim();
        log.debug("Search filter: {}", (Object)searchFilter);
        Map<String, BaseAttribute> attributes = null;
        if (this.cacheResults) {
            log.debug("Checking cache for search results");
            attributes = this.getCachedAttributes(resolutionContext, searchFilter);
            if (attributes != null && log.isDebugEnabled()) {
                log.debug("Returning attributes from cache");
            }
        }
        if (attributes == null) {
            log.debug("Retrieving attributes from LDAP");
            Iterator<SearchResult> results = this.searchLdap(searchFilter);
            if (this.noResultsIsError && !results.hasNext()) {
                throw new AttributeResolutionException("No LDAP entry found for " + resolutionContext.getAttributeRequestContext().getPrincipalName());
            }
            attributes = this.buildBaseAttributes(results);
            if (this.cacheResults && attributes != null) {
                this.setCachedAttributes(resolutionContext, searchFilter, attributes);
                log.debug("Stored results in the cache");
            }
        }
        return attributes;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void validate() throws AttributeResolutionException {
        Ldap ldap = null;
        ldap = (Ldap)this.ldapPool.borrowObject();
        if (!ldap.connect()) {
            throw new NamingException();
        }
        Object var4_2 = null;
        if (ldap == null) return;
        try {
            this.ldapPool.returnObject((Object)ldap);
            return;
        }
        catch (Exception e) {
            log.error("Could not return Ldap object back to pool", (Throwable)e);
        }
        return;
        {
            catch (NamingException e) {
                log.error("An error occured when attempting to search the LDAP: " + this.ldapConfig.getEnvironment(), (Throwable)e);
                throw new AttributeResolutionException("An error occurred when attempting to search the LDAP");
            }
            catch (Exception e) {
                log.error("Could not retrieve Ldap object from pool", (Throwable)e);
                throw new AttributeResolutionException("An error occurred when attempting to retrieve a LDAP connection from the pool");
            }
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (ldap == null) throw throwable;
            try {
                this.ldapPool.returnObject((Object)ldap);
                throw throwable;
            }
            catch (Exception e) {
                log.error("Could not return Ldap object back to pool", (Throwable)e);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Iterator<SearchResult> searchLdap(String searchFilter) throws AttributeResolutionException {
        Iterator iterator;
        Ldap ldap = null;
        try {
            try {
                ldap = (Ldap)this.ldapPool.borrowObject();
                iterator = ldap.search(searchFilter, this.returnAttributes);
                Object var5_6 = null;
                if (ldap == null) return iterator;
            }
            catch (NamingException e) {
                log.error("An error occured when attempting to search the LDAP: " + this.ldapConfig.getEnvironment(), (Throwable)e);
                throw new AttributeResolutionException("An error occurred when attempting to search the LDAP");
            }
            catch (Exception e) {
                log.error("Could not retrieve Ldap object from pool", (Throwable)e);
                throw new AttributeResolutionException("An error occurred when attempting to retrieve a LDAP connection from the pool");
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (ldap == null) throw throwable;
            try {
                this.ldapPool.returnObject((Object)ldap);
                throw throwable;
            }
            catch (Exception e) {
                log.error("Could not return Ldap object back to pool", (Throwable)e);
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            log.error("Could not return Ldap object back to pool", (Throwable)e);
            return iterator;
        }
        this.ldapPool.returnObject((Object)ldap);
        return iterator;
    }

    protected Map<String, BaseAttribute> buildBaseAttributes(Iterator<SearchResult> results) throws AttributeResolutionException {
        HashMap<String, BaseAttribute> attributes = new HashMap<String, BaseAttribute>();
        if (!results.hasNext()) {
            return attributes;
        }
        do {
            SearchResult sr = results.next();
            Map newAttrsMap = null;
            try {
                newAttrsMap = LdapUtil.parseAttributes((Attributes)sr.getAttributes(), (boolean)true);
            }
            catch (NamingException e) {
                log.error("Error parsing LDAP attributes", (Throwable)e);
                throw new AttributeResolutionException("Error parsing LDAP attributes");
            }
            for (Map.Entry entry : newAttrsMap.entrySet()) {
                List values;
                log.debug("Found the following attribute: {}", entry);
                BasicAttribute attribute = (BasicAttribute)attributes.get(entry.getKey());
                if (attribute == null) {
                    attribute = new BasicAttribute();
                    attribute.setId((String)entry.getKey());
                    attributes.put((String)entry.getKey(), attribute);
                }
                if ((values = (List)entry.getValue()) == null || values.isEmpty()) continue;
                for (String value : values) {
                    if (DatatypeHelper.isEmpty((String)value)) continue;
                    ((BaseAttribute)attribute).getValues().add(DatatypeHelper.safeTrimOrNullString((String)value));
                }
            }
        } while (this.mergeMultipleResults && results.hasNext());
        return attributes;
    }

    protected void setCachedAttributes(ShibbolethResolutionContext resolutionContext, String searchFiler, Map<String, BaseAttribute> attributes) {
        Map<Object, Object> results = null;
        String principal = resolutionContext.getAttributeRequestContext().getPrincipalName();
        if (this.cache.containsKey(principal)) {
            results = this.cache.get(principal);
        } else {
            results = new HashMap();
            this.cache.put(principal, results);
        }
        results.put(searchFiler, attributes);
    }

    protected Map<String, BaseAttribute> getCachedAttributes(ShibbolethResolutionContext resolutionContext, String searchFilter) {
        String principal;
        Map<String, BaseAttribute> attributes = null;
        if (this.cacheResults && this.cache.containsKey(principal = resolutionContext.getAttributeRequestContext().getPrincipalName())) {
            Map<String, Map<String, BaseAttribute>> results = this.cache.get(principal);
            attributes = results.get(searchFilter);
        }
        return attributes;
    }

    protected class LDAPValueEscapingStrategy
    implements TemplateEngine.CharacterEscapingStrategy {
        protected LDAPValueEscapingStrategy() {
        }

        public String escape(String value) {
            return value.replace("*", "\\*").replace("(", "\\(").replace(")", "\\)").replace("\\", "\\");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AUTHENTICATION_TYPE {
        ANONYMOUS,
        SIMPLE,
        STRONG,
        EXTERNAL,
        DIGEST_MD5,
        CRAM_MD5,
        GSSAPI;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SEARCH_SCOPE {
        OBJECT,
        ONELEVEL,
        SUBTREE;

    }
}

