/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.attributeDefinition;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueMap {
    private final Logger log = LoggerFactory.getLogger(ValueMap.class);
    private String returnValue;
    private Collection<SourceValue> sourceValues = new HashSet<SourceValue>();

    public String getReturnValue() {
        return this.returnValue;
    }

    public void setReturnValue(String newReturnValue) {
        this.returnValue = newReturnValue;
    }

    public Collection<SourceValue> getSourceValues() {
        return this.sourceValues;
    }

    public Set<String> evaluate(String attributeValue) {
        this.log.debug("Attempting to map attribute value '{}'", (Object)attributeValue);
        HashSet<String> mappedValues = new HashSet<String>();
        for (SourceValue sourceValue : this.sourceValues) {
            String newValue = null;
            if (sourceValue.isPartialMatch()) {
                this.log.debug("Performing partial match comparison.");
                if (attributeValue.contains(sourceValue.getValue())) {
                    this.log.debug("Attribute value '{}' matches source value '{}' it will be mapped to '{}'", new Object[]{attributeValue, sourceValue.getValue(), newValue});
                    newValue = this.returnValue;
                }
            } else {
                this.log.debug("Performing regular expression based comparison");
                try {
                    int flags = sourceValue.isIgnoreCase() ? 2 : 0;
                    Matcher m = Pattern.compile(sourceValue.getValue(), flags).matcher(attributeValue);
                    if (m.matches()) {
                        newValue = m.replaceAll(this.returnValue);
                        this.log.debug("Attribute value '{}' matches regular expression it will be mapped to '{}'", (Object)attributeValue, (Object)newValue);
                    }
                }
                catch (PatternSyntaxException e) {
                    this.log.debug("Error matching value {}.  Skipping this value.", (Object)attributeValue);
                }
            }
            if (newValue == null) continue;
            mappedValues.add(newValue);
        }
        return mappedValues;
    }

    public class SourceValue {
        private String value;
        private boolean ignoreCase;
        private boolean partialMatch;

        public SourceValue(String newValue, boolean newIgnoreCase, boolean newPartialMatch) {
            this.value = newValue;
            this.ignoreCase = newIgnoreCase;
            this.partialMatch = newPartialMatch;
        }

        public boolean isIgnoreCase() {
            return this.ignoreCase;
        }

        public boolean isPartialMatch() {
            return this.partialMatch;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.getValue();
        }
    }
}

