/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.authn;

import edu.internet2.middleware.shibboleth.common.session.Session;
import edu.internet2.middleware.shibboleth.common.session.SessionManager;
import edu.internet2.middleware.shibboleth.common.util.HttpHelper;
import edu.internet2.middleware.shibboleth.idp.authn.AuthenticationException;
import edu.internet2.middleware.shibboleth.idp.authn.ForceAuthenticationException;
import edu.internet2.middleware.shibboleth.idp.authn.LoginContext;
import edu.internet2.middleware.shibboleth.idp.authn.LoginContextEntry;
import edu.internet2.middleware.shibboleth.idp.authn.LoginHandler;
import edu.internet2.middleware.shibboleth.idp.authn.PassiveAuthenticationException;
import edu.internet2.middleware.shibboleth.idp.authn.UsernamePrincipal;
import edu.internet2.middleware.shibboleth.idp.profile.IdPProfileHandlerManager;
import edu.internet2.middleware.shibboleth.idp.session.AuthenticationMethodInformation;
import edu.internet2.middleware.shibboleth.idp.session.impl.AuthenticationMethodInformationImpl;
import edu.internet2.middleware.shibboleth.idp.session.impl.ServiceInformationImpl;
import edu.internet2.middleware.shibboleth.idp.util.HttpServletHelper;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joda.time.DateTime;
import org.opensaml.util.storage.StorageService;
import org.opensaml.ws.transport.http.HTTPTransportUtils;
import org.opensaml.xml.util.Base64;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationEngine
extends HttpServlet {
    public static final String RETAIN_PUBLIC_CREDENTIALS = "retainSubjectsPublicCredentials";
    public static final String RETAIN_PRIVATE_CREDENTIALS = "retainSubjectsPrivateCredentials";
    public static final String LOGIN_CONTEXT_PARTITION_NAME_INIT_PARAM_NAME = "loginContextPartitionName";
    public static final String LOGIN_CONTEXT_LIFETIME_INIT_PARAM_NAME = "loginContextEntryLifetime";
    public static final String IDP_SESSION_COOKIE_NAME = "_idp_session";
    public static final String LOGIN_CONTEXT_KEY_NAME = "_idp_authn_lc_key";
    private static final long serialVersionUID = -8479060989001890156L;
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationEngine.class);
    private static ServletContext context;
    private static StorageService<String, LoginContextEntry> storageService;
    private boolean retainSubjectsPublicCredentials;
    private boolean retainSubjectsPrivateCredentials;
    private IdPProfileHandlerManager handlerManager;
    private SessionManager<edu.internet2.middleware.shibboleth.idp.session.Session> sessionManager;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String retain = DatatypeHelper.safeTrimOrNullString((String)config.getInitParameter(RETAIN_PRIVATE_CREDENTIALS));
        this.retainSubjectsPrivateCredentials = retain != null ? Boolean.parseBoolean(retain) : false;
        retain = DatatypeHelper.safeTrimOrNullString((String)config.getInitParameter(RETAIN_PUBLIC_CREDENTIALS));
        this.retainSubjectsPublicCredentials = retain != null ? Boolean.parseBoolean(retain) : false;
        this.handlerManager = HttpServletHelper.getProfileHandlerManager(config.getServletContext());
        this.sessionManager = HttpServletHelper.getSessionManager(config.getServletContext());
        storageService = HttpServletHelper.getStorageService(config.getServletContext());
        context = config.getServletContext();
    }

    public static void returnToAuthenticationEngine(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        LOG.debug("Returning control to authentication engine");
        LoginContext loginContext = HttpServletHelper.getLoginContext(storageService, context, httpRequest);
        if (loginContext == null) {
            LOG.warn("No login context available, unable to return to authentication engine");
            AuthenticationEngine.forwardRequest("/error.jsp", httpRequest, httpResponse);
        } else {
            AuthenticationEngine.forwardRequest(loginContext.getAuthenticationEngineURL(), httpRequest, httpResponse);
        }
    }

    public static void returnToProfileHandler(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        LOG.debug("Returning control to profile handler");
        LoginContext loginContext = HttpServletHelper.getLoginContext(storageService, context, httpRequest);
        if (loginContext == null) {
            LOG.warn("No login context available, unable to return to profile handler");
            AuthenticationEngine.forwardRequest("/error.jsp", httpRequest, httpResponse);
        }
        HttpServletHelper.bindLoginContext(loginContext, httpRequest);
        LOG.debug("Returning control to profile handler at: {}", (Object)loginContext.getProfileHandlerURL());
        AuthenticationEngine.forwardRequest(loginContext.getProfileHandlerURL(), httpRequest, httpResponse);
    }

    protected static void forwardRequest(String forwardPath, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        try {
            RequestDispatcher dispatcher = httpRequest.getRequestDispatcher(forwardPath);
            dispatcher.forward((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            return;
        }
        catch (IOException e) {
            LOG.error("Unable to return control back to authentication engine", (Throwable)e);
        }
        catch (ServletException e) {
            LOG.error("Unable to return control back to authentication engine", (Throwable)e);
        }
    }

    protected void service(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException, IOException {
        LoginContext loginContext;
        LOG.debug("Processing incoming request");
        if (httpResponse.isCommitted()) {
            LOG.error("HTTP Response already committed");
        }
        if ((loginContext = HttpServletHelper.getLoginContext(storageService, this.getServletContext(), httpRequest)) == null) {
            LOG.error("Incoming request does not have attached login context");
            throw new ServletException("Incoming request does not have attached login context");
        }
        if (!loginContext.getAuthenticationAttempted()) {
            this.startUserAuthentication(loginContext, httpRequest, httpResponse);
        } else {
            this.completeAuthentication(loginContext, httpRequest, httpResponse);
        }
    }

    protected void startUserAuthentication(LoginContext loginContext, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        LOG.debug("Beginning user authentication process.");
        try {
            LoginHandler loginHandler;
            edu.internet2.middleware.shibboleth.idp.session.Session idpSession = (edu.internet2.middleware.shibboleth.idp.session.Session)httpRequest.getAttribute("ShibbolethIdPSession");
            if (idpSession != null) {
                LOG.debug("Existing IdP session available for principal {}", (Object)idpSession.getPrincipalName());
            }
            Map<String, LoginHandler> possibleLoginHandlers = this.determinePossibleLoginHandlers(idpSession, loginContext);
            LOG.debug("Possible authentication handlers for this request: {}", possibleLoginHandlers);
            if (loginContext.isForceAuthRequired()) {
                this.filterByForceAuthentication(idpSession, loginContext, possibleLoginHandlers);
            }
            if (loginContext.isPassiveAuthRequired()) {
                this.filterByPassiveAuthentication(idpSession, loginContext, possibleLoginHandlers);
            }
            LOG.debug("Possible authentication handlers after filtering: {}", possibleLoginHandlers);
            if (idpSession != null && possibleLoginHandlers.containsKey("urn:oasis:names:tc:SAML:2.0:ac:classes:PreviousSession")) {
                loginContext.setAttemptedAuthnMethod("urn:oasis:names:tc:SAML:2.0:ac:classes:PreviousSession");
                loginHandler = possibleLoginHandlers.get("urn:oasis:names:tc:SAML:2.0:ac:classes:PreviousSession");
            } else {
                possibleLoginHandlers.remove("urn:oasis:names:tc:SAML:2.0:ac:classes:PreviousSession");
                if (possibleLoginHandlers.isEmpty()) {
                    LOG.info("No authentication mechanism available for use with relying party '{}'", (Object)loginContext.getRelyingPartyId());
                    throw new AuthenticationException();
                }
                if (loginContext.getDefaultAuthenticationMethod() != null && possibleLoginHandlers.containsKey(loginContext.getDefaultAuthenticationMethod())) {
                    loginHandler = possibleLoginHandlers.get(loginContext.getDefaultAuthenticationMethod());
                    loginContext.setAttemptedAuthnMethod(loginContext.getDefaultAuthenticationMethod());
                } else {
                    Map.Entry<String, LoginHandler> chosenLoginHandler = possibleLoginHandlers.entrySet().iterator().next();
                    loginContext.setAttemptedAuthnMethod(chosenLoginHandler.getKey());
                    loginHandler = chosenLoginHandler.getValue();
                }
            }
            LOG.debug("Authenticating user with login handler of type {}", (Object)loginHandler.getClass().getName());
            loginContext.setAuthenticationAttempted();
            loginContext.setAuthenticationEngineURL(HttpHelper.getRequestUriWithoutContext((HttpServletRequest)httpRequest));
            HttpServletHelper.bindLoginContext(loginContext, storageService, this.getServletContext(), httpRequest, httpResponse);
            loginHandler.login(httpRequest, httpResponse);
        }
        catch (AuthenticationException e) {
            loginContext.setAuthenticationFailure(e);
            AuthenticationEngine.returnToProfileHandler(httpRequest, httpResponse);
        }
    }

    protected Map<String, LoginHandler> determinePossibleLoginHandlers(edu.internet2.middleware.shibboleth.idp.session.Session idpSession, LoginContext loginContext) throws AuthenticationException {
        HashMap<String, LoginHandler> supportedLoginHandlers = new HashMap<String, LoginHandler>(this.handlerManager.getLoginHandlers());
        LOG.debug("Filtering configured login handlers by requested athentication methods.");
        LOG.debug("Configured LoginHandlers: {}", supportedLoginHandlers);
        LOG.debug("Requested authentication methods: {}", loginContext.getRequestedAuthenticationMethods());
        if (loginContext.getRequestedAuthenticationMethods().isEmpty()) {
            LOG.trace("No preference given for authentication methods");
            return supportedLoginHandlers;
        }
        if (supportedLoginHandlers.containsKey("urn:oasis:names:tc:SAML:2.0:ac:classes:PreviousSession") && idpSession != null && loginContext.getRequestedAuthenticationMethods() != null) {
            boolean retainPreviousSession = false;
            Map<String, AuthenticationMethodInformation> currentAuthnMethods = idpSession.getAuthenticationMethods();
            for (String currentAuthnMethod : currentAuthnMethods.keySet()) {
                if (!loginContext.getRequestedAuthenticationMethods().contains(currentAuthnMethod)) continue;
                retainPreviousSession = true;
                break;
            }
            if (!retainPreviousSession) {
                supportedLoginHandlers.remove("urn:oasis:names:tc:SAML:2.0:ac:classes:PreviousSession");
            }
        }
        Iterator supportedLoginHandlerItr = supportedLoginHandlers.entrySet().iterator();
        while (supportedLoginHandlerItr.hasNext()) {
            Map.Entry supportedLoginHandler = supportedLoginHandlerItr.next();
            if (((String)supportedLoginHandler.getKey()).equals("urn:oasis:names:tc:SAML:2.0:ac:classes:PreviousSession") || loginContext.getRequestedAuthenticationMethods().contains(supportedLoginHandler.getKey())) continue;
            supportedLoginHandlerItr.remove();
        }
        if (supportedLoginHandlers.isEmpty()) {
            LOG.warn("No authentication method, requested by the service provider, is supported");
            throw new AuthenticationException("No authentication method, requested by the service provider, is supported");
        }
        return supportedLoginHandlers;
    }

    protected void filterByForceAuthentication(edu.internet2.middleware.shibboleth.idp.session.Session idpSession, LoginContext loginContext, Map<String, LoginHandler> loginHandlers) throws ForceAuthenticationException {
        LOG.debug("Forced authentication is required, filtering possible login handlers accordingly");
        ArrayList<AuthenticationMethodInformation> activeMethods = new ArrayList<AuthenticationMethodInformation>();
        if (idpSession != null) {
            activeMethods.addAll(idpSession.getAuthenticationMethods().values());
        }
        loginHandlers.remove("urn:oasis:names:tc:SAML:2.0:ac:classes:PreviousSession");
        for (AuthenticationMethodInformation activeMethod : activeMethods) {
            LoginHandler loginHandler = loginHandlers.get(activeMethod.getAuthenticationMethod());
            if (loginHandler == null || loginHandler.supportsForceAuthentication()) continue;
            for (String handlerSupportedMethods : loginHandler.getSupportedAuthenticationMethods()) {
                loginHandlers.remove(handlerSupportedMethods);
            }
        }
        LOG.debug("Authentication handlers remaining after forced authentication requirement filtering: {}", loginHandlers);
        if (loginHandlers.isEmpty()) {
            LOG.info("Force authentication requested but no login handlers available to support it");
            throw new ForceAuthenticationException();
        }
    }

    protected void filterByPassiveAuthentication(edu.internet2.middleware.shibboleth.idp.session.Session idpSession, LoginContext loginContext, Map<String, LoginHandler> loginHandlers) throws PassiveAuthenticationException {
        LOG.debug("Passive authentication is required, filtering poassible login handlers accordingly.");
        if (idpSession == null) {
            loginHandlers.remove("urn:oasis:names:tc:SAML:2.0:ac:classes:PreviousSession");
        }
        Iterator<Map.Entry<String, LoginHandler>> authnMethodItr = loginHandlers.entrySet().iterator();
        while (authnMethodItr.hasNext()) {
            LoginHandler loginHandler = authnMethodItr.next().getValue();
            if (loginHandler.supportsPassive()) continue;
            authnMethodItr.remove();
        }
        LOG.debug("Authentication handlers remaining after passive authentication requirement filtering: {}", loginHandlers);
        if (loginHandlers.isEmpty()) {
            LOG.warn("Passive authentication required but no login handlers available to support it");
            throw new PassiveAuthenticationException();
        }
    }

    protected void completeAuthentication(LoginContext loginContext, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        LOG.debug("Completing user authentication process");
        edu.internet2.middleware.shibboleth.idp.session.Session idpSession = (edu.internet2.middleware.shibboleth.idp.session.Session)httpRequest.getAttribute("ShibbolethIdPSession");
        try {
            String actualAuthnMethod = DatatypeHelper.safeTrimOrNullString((String)((String)httpRequest.getAttribute("authnMethod")));
            if (actualAuthnMethod != null) {
                if (!loginContext.getRequestedAuthenticationMethods().isEmpty() && !loginContext.getRequestedAuthenticationMethods().contains(actualAuthnMethod)) {
                    String msg = MessageFormatter.format((String)"Relying patry required an authentication method of '{}' but the login handler performed '{}'", loginContext.getRequestedAuthenticationMethods(), (Object)actualAuthnMethod);
                    LOG.error(msg);
                    throw new AuthenticationException(msg);
                }
            } else {
                actualAuthnMethod = loginContext.getAttemptedAuthnMethod();
            }
            this.validateSuccessfulAuthentication(loginContext, httpRequest, actualAuthnMethod);
            Subject subject = this.getLoginHandlerSubject(httpRequest);
            if (loginContext.isForceAuthRequired()) {
                this.validateForcedReauthentication(idpSession, actualAuthnMethod, subject);
            }
            loginContext.setPrincipalAuthenticated(true);
            this.updateUserSession(loginContext, subject, actualAuthnMethod, httpRequest, httpResponse);
            LOG.debug("User {} authenticated with method {}", (Object)loginContext.getPrincipalName(), (Object)loginContext.getAuthenticationMethod());
        }
        catch (AuthenticationException e) {
            LOG.error("Authentication failed with the error:", (Throwable)e);
            loginContext.setPrincipalAuthenticated(false);
            loginContext.setAuthenticationFailure(e);
        }
        AuthenticationEngine.returnToProfileHandler(httpRequest, httpResponse);
    }

    protected void validateSuccessfulAuthentication(LoginContext loginContext, HttpServletRequest httpRequest, String authenticationMethod) throws AuthenticationException {
        LOG.debug("Validating authentication was performed successfully");
        String errorMessage = DatatypeHelper.safeTrimOrNullString((String)((String)httpRequest.getAttribute("authnError")));
        if (errorMessage != null) {
            LOG.error("Error returned from login handler for authentication method {}:\n{}", (Object)loginContext.getAttemptedAuthnMethod(), (Object)errorMessage);
            throw new AuthenticationException(errorMessage);
        }
        AuthenticationException authnException = (AuthenticationException)httpRequest.getAttribute("authnException");
        if (authnException != null) {
            throw authnException;
        }
        Subject subject = (Subject)httpRequest.getAttribute("subject");
        Principal principal = (Principal)httpRequest.getAttribute("principal");
        String principalName = DatatypeHelper.safeTrimOrNullString((String)((String)httpRequest.getAttribute("principal_name")));
        if (subject == null && principal == null && principalName == null) {
            LOG.error("No user identified by login handler.");
            throw new AuthenticationException("No user identified by login handler.");
        }
    }

    protected Subject getLoginHandlerSubject(HttpServletRequest httpRequest) throws AuthenticationException {
        Subject subject = (Subject)httpRequest.getAttribute("subject");
        Principal principal = (Principal)httpRequest.getAttribute("principal");
        String principalName = DatatypeHelper.safeTrimOrNullString((String)((String)httpRequest.getAttribute("principal_name")));
        if (subject == null && (principal != null || principalName != null)) {
            subject = new Subject();
            if (principal == null) {
                principal = new UsernamePrincipal(principalName);
            }
            subject.getPrincipals().add(principal);
        }
        return subject;
    }

    protected void validateForcedReauthentication(edu.internet2.middleware.shibboleth.idp.session.Session idpSession, String authnMethod, Subject subject) throws AuthenticationException {
        AuthenticationMethodInformation authnMethodInfo;
        if (idpSession != null && (authnMethodInfo = idpSession.getAuthenticationMethods().get(authnMethod)) != null) {
            boolean princpalMatch = false;
            for (Principal princpal : subject.getPrincipals()) {
                if (!((Object)authnMethodInfo.getAuthenticationPrincipal()).equals(princpal)) continue;
                princpalMatch = true;
                break;
            }
            if (!princpalMatch) {
                throw new ForceAuthenticationException("Authenticated principal does not match previously authenticated principal");
            }
        }
    }

    protected void updateUserSession(LoginContext loginContext, Subject authenticationSubject, String authenticationMethod, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        Principal authenticationPrincipal = authenticationSubject.getPrincipals().iterator().next();
        LOG.debug("Updating session information for principal {}", (Object)authenticationPrincipal.getName());
        edu.internet2.middleware.shibboleth.idp.session.Session idpSession = (edu.internet2.middleware.shibboleth.idp.session.Session)httpRequest.getAttribute("ShibbolethIdPSession");
        if (idpSession == null) {
            LOG.debug("Creating shibboleth session for principal {}", (Object)authenticationPrincipal.getName());
            idpSession = (edu.internet2.middleware.shibboleth.idp.session.Session)this.sessionManager.createSession();
            loginContext.setSessionID(idpSession.getSessionID());
            this.addSessionCookie(httpRequest, httpResponse, idpSession);
        }
        idpSession.setSubject(this.mergeSubjects(idpSession.getSubject(), authenticationSubject));
        LOG.debug("Recording authentication and service information in Shibboleth session for principal: {}", (Object)authenticationPrincipal.getName());
        LoginHandler loginHandler = this.handlerManager.getLoginHandlers().get(loginContext.getAttemptedAuthnMethod());
        AuthenticationMethodInformationImpl authnMethodInfo = new AuthenticationMethodInformationImpl(idpSession.getSubject(), authenticationPrincipal, authenticationMethod, new DateTime(), loginHandler.getAuthenticationDuration());
        loginContext.setAuthenticationMethodInformation(authnMethodInfo);
        idpSession.getAuthenticationMethods().put(authnMethodInfo.getAuthenticationMethod(), authnMethodInfo);
        this.sessionManager.indexSession((Session)idpSession, authnMethodInfo.getAuthenticationPrincipal().getName());
        ServiceInformationImpl serviceInfo = new ServiceInformationImpl(loginContext.getRelyingPartyId(), new DateTime(), authnMethodInfo);
        idpSession.getServicesInformation().put(serviceInfo.getEntityID(), serviceInfo);
    }

    protected Subject mergeSubjects(Subject subject1, Subject subject2) {
        if (subject1 == null && subject2 == null) {
            return new Subject();
        }
        if (subject1 == null) {
            return subject2;
        }
        if (subject2 == null) {
            return subject1;
        }
        HashSet<Principal> principals = new HashSet<Principal>(3);
        principals.addAll(subject1.getPrincipals());
        principals.addAll(subject2.getPrincipals());
        HashSet<Object> publicCredentials = new HashSet<Object>(3);
        if (this.retainSubjectsPublicCredentials) {
            LOG.debug("Merging in subjects public credentials");
            publicCredentials.addAll(subject1.getPublicCredentials());
            publicCredentials.addAll(subject2.getPublicCredentials());
        }
        HashSet<Object> privateCredentials = new HashSet<Object>(3);
        if (this.retainSubjectsPrivateCredentials) {
            LOG.debug("Merging in subjects private credentials");
            privateCredentials.addAll(subject1.getPrivateCredentials());
            privateCredentials.addAll(subject2.getPrivateCredentials());
        }
        return new Subject(false, principals, publicCredentials, privateCredentials);
    }

    protected void addSessionCookie(HttpServletRequest httpRequest, HttpServletResponse httpResponse, edu.internet2.middleware.shibboleth.idp.session.Session userSession) {
        httpRequest.setAttribute("ShibbolethIdPSession", (Object)userSession);
        byte[] remoteAddress = httpRequest.getRemoteAddr().getBytes();
        byte[] sessionId = userSession.getSessionID().getBytes();
        String signature = null;
        try {
            MessageDigest digester = MessageDigest.getInstance("SHA");
            digester.update(userSession.getSessionSecret());
            digester.update(remoteAddress);
            digester.update(sessionId);
            signature = Base64.encodeBytes((byte[])digester.digest());
        }
        catch (GeneralSecurityException e) {
            LOG.error("Unable to compute signature over session cookie material", (Throwable)e);
        }
        LOG.debug("Adding IdP session cookie to HTTP response");
        StringBuilder cookieValue = new StringBuilder();
        cookieValue.append(Base64.encodeBytes((byte[])remoteAddress, (int)8)).append("|");
        cookieValue.append(Base64.encodeBytes((byte[])sessionId, (int)8)).append("|");
        cookieValue.append(signature);
        Cookie sessionCookie = new Cookie(IDP_SESSION_COOKIE_NAME, HTTPTransportUtils.urlEncode((String)cookieValue.toString()));
        sessionCookie.setVersion(1);
        sessionCookie.setPath(httpRequest.getContextPath() == "" ? "/" : httpRequest.getContextPath());
        sessionCookie.setSecure(httpRequest.isSecure());
        httpResponse.addCookie(sessionCookie);
    }
}

