/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp;

import edu.internet2.middleware.shibboleth.common.attribute.resolver.AttributeResolutionException;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.AttributeResolver;
import edu.internet2.middleware.shibboleth.common.relyingparty.RelyingPartyConfiguration;
import edu.internet2.middleware.shibboleth.common.relyingparty.RelyingPartyConfigurationManager;
import edu.internet2.middleware.shibboleth.idp.Version;
import edu.internet2.middleware.shibboleth.idp.util.HttpServletHelper;
import edu.internet2.middleware.shibboleth.idp.util.IPRange;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.opensaml.xml.security.x509.X509Credential;
import org.opensaml.xml.util.Base64;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.LazyList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusServlet
extends HttpServlet {
    private static final long serialVersionUID = -5280549109235107879L;
    private final String IP_PARAM_NAME = "AllowedIPs";
    private final Logger log = LoggerFactory.getLogger(StatusServlet.class);
    private LazyList<IPRange> allowedIPs;
    private DateTimeFormatter dateFormat;
    private DateTime startTime;
    private AttributeResolver<?> attributeResolver;
    private RelyingPartyConfigurationManager rpConfigManager;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.allowedIPs = new LazyList();
        String cidrBlocks = DatatypeHelper.safeTrimOrNullString((String)config.getInitParameter("AllowedIPs"));
        if (cidrBlocks != null) {
            for (String cidrBlock : cidrBlocks.split(" ")) {
                this.allowedIPs.add((Object)IPRange.parseCIDRBlock(cidrBlock));
            }
        }
        this.dateFormat = ISODateTimeFormat.dateTimeNoMillis();
        this.startTime = new DateTime((Chronology)ISOChronology.getInstanceUTC());
        this.attributeResolver = HttpServletHelper.getAttributeResolver(config.getServletContext());
        this.rpConfigManager = HttpServletHelper.getRelyingPartyConfirmationManager(config.getServletContext());
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.isAuthenticated(request)) {
            response.sendError(401);
            return;
        }
        response.setContentType("text/plain");
        PrintWriter output = response.getWriter();
        this.printOperatingEnvironmentInformation(output);
        output.println();
        this.printIdPInformation(output);
        output.println();
        this.printRelyingPartyConfigurationsInformation(output, request.getParameter("relyingParty"));
        output.flush();
    }

    protected boolean isAuthenticated(HttpServletRequest request) throws ServletException {
        this.log.debug("Attempting to authenticate client '{}'", (Object)request.getRemoteAddr());
        try {
            InetAddress clientAddress = InetAddress.getByName(request.getRemoteAddr());
            for (IPRange range : this.allowedIPs) {
                if (!range.contains(clientAddress)) continue;
                return true;
            }
            return false;
        }
        catch (UnknownHostException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void printOperatingEnvironmentInformation(PrintWriter out) {
        Runtime runtime = Runtime.getRuntime();
        out.println("### Operating Environment Information");
        out.println("operating_system: " + System.getProperty("os.name"));
        out.println("operating_system_version: " + System.getProperty("os.version"));
        out.println("operating_system_architecture: " + System.getProperty("os.arch"));
        out.println("jdk_version: " + System.getProperty("java.version"));
        out.println("available_cores: " + runtime.availableProcessors());
        out.println("used_memory: " + runtime.totalMemory() / 0x100000L + "MB");
        out.println("maximum_memory: " + runtime.maxMemory() / 0x100000L + "MB");
        out.println("current_time: " + new DateTime((Chronology)ISOChronology.getInstanceUTC()).toString(this.dateFormat));
    }

    protected void printIdPInformation(PrintWriter out) {
        Package pkg = Version.class.getPackage();
        out.println("### Identity Provider Information");
        out.println("idp_version: " + pkg.getImplementationVersion());
        out.println("idp_start_time: " + this.startTime.toString(this.dateFormat));
        try {
            this.attributeResolver.validate();
            out.println("attribute_resolver_valid: " + Boolean.TRUE);
        }
        catch (AttributeResolutionException e) {
            out.println("attribute_resolver_valid: " + Boolean.FALSE);
        }
    }

    protected void printRelyingPartyConfigurationsInformation(PrintWriter out, String relyingPartyId) {
        out.println("### Relying Party Configurations");
        if (relyingPartyId == null) {
            for (RelyingPartyConfiguration config : this.rpConfigManager.getRelyingPartyConfigurations().values()) {
                this.printRelyingPartyConfigurationInformation(out, config);
                out.println();
            }
        } else {
            RelyingPartyConfiguration config = this.rpConfigManager.getRelyingPartyConfiguration(relyingPartyId);
            this.printRelyingPartyConfigurationInformation(out, config);
            out.println();
        }
    }

    protected void printRelyingPartyConfigurationInformation(PrintWriter out, RelyingPartyConfiguration config) {
        out.println("relying_party_id: " + config.getRelyingPartyId());
        out.println("idp_entity_id: " + config.getProviderId());
        if (config.getDefaultAuthenticationMethod() != null) {
            out.println("default_authentication_method: " + config.getDefaultAuthenticationMethod());
        } else {
            out.println("default_authentication_method: none");
        }
        try {
            X509Credential signingCredential = (X509Credential)config.getDefaultSigningCredential();
            out.println("default_signing_tls_key: " + Base64.encodeBytes((byte[])signingCredential.getEntityCertificate().getEncoded(), (int)8));
        }
        catch (Throwable t) {
            // empty catch block
        }
        for (String profileId : config.getProfileConfigurations().keySet()) {
            out.println("configured_communication_profile: " + profileId);
        }
    }
}

