/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.common.binding.security;

import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.util.storage.ReplayCache;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.security.SecurityPolicyException;
import org.opensaml.ws.security.SecurityPolicyRule;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageReplayRule
implements SecurityPolicyRule {
    private final Logger log = LoggerFactory.getLogger(MessageReplayRule.class);
    private ReplayCache replayCache;
    private boolean requiredRule;

    public MessageReplayRule(ReplayCache newReplayCache) {
        this.replayCache = newReplayCache;
        this.requiredRule = true;
    }

    public boolean isRequiredRule() {
        return this.requiredRule;
    }

    public void setRequiredRule(boolean required) {
        this.requiredRule = required;
    }

    public void evaluate(MessageContext messageContext) throws SecurityPolicyException {
        if (!(messageContext instanceof SAMLMessageContext)) {
            this.log.debug("Invalid message context type, this policy rule only supports SAMLMessageContext");
            return;
        }
        SAMLMessageContext samlMsgCtx = (SAMLMessageContext)messageContext;
        String messageIsuer = DatatypeHelper.safeTrimOrNullString((String)samlMsgCtx.getInboundMessageIssuer());
        if (messageIsuer == null && this.requiredRule) {
            this.log.warn("Message contained no Issuer ID, replay check not possible");
            throw new SecurityPolicyException("Message contained no Issuer ID, replay check not possible");
        }
        String messageId = DatatypeHelper.safeTrimOrNullString((String)samlMsgCtx.getInboundSAMLMessageId());
        if (messageId == null && this.requiredRule) {
            this.log.error("Message contained no ID, replay check not possible");
            throw new SecurityPolicyException("SAML message from issuer " + messageIsuer + " did not contain an ID");
        }
        if (this.replayCache.isReplay(messageIsuer, messageId)) {
            this.log.warn("Replay detected of message '" + messageId + "' from issuer " + messageIsuer);
            throw new SecurityPolicyException("Rejecting replayed message ID '" + messageId + "' from issuer " + messageIsuer);
        }
    }
}

