/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.common.binding.security;

import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.security.SecurityPolicyException;
import org.opensaml.ws.security.SecurityPolicyRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueInstantRule
implements SecurityPolicyRule {
    private final Logger log = LoggerFactory.getLogger(IssueInstantRule.class);
    private int clockSkew;
    private int expires;
    private boolean requiredRule;

    public IssueInstantRule(int newClockSkew, int newExpires) {
        this.clockSkew = newClockSkew;
        this.expires = newExpires;
        this.requiredRule = true;
    }

    public boolean isRequiredRule() {
        return this.requiredRule;
    }

    public void setRequiredRule(boolean required) {
        this.requiredRule = required;
    }

    public void evaluate(MessageContext messageContext) throws SecurityPolicyException {
        if (!(messageContext instanceof SAMLMessageContext)) {
            this.log.debug("Invalid message context type, this policy rule only supports SAMLMessageContext");
            return;
        }
        SAMLMessageContext samlMsgCtx = (SAMLMessageContext)messageContext;
        if (samlMsgCtx.getInboundSAMLMessageIssueInstant() == null) {
            if (this.requiredRule) {
                this.log.warn("Inbound SAML message issue instant not present in message context");
                throw new SecurityPolicyException("Inbound SAML message issue instant not present in message context");
            }
            return;
        }
        DateTime issueInstant = samlMsgCtx.getInboundSAMLMessageIssueInstant();
        DateTime now = new DateTime();
        DateTime latestValid = now.plusSeconds(this.clockSkew);
        DateTime expiration = issueInstant.plusSeconds(this.clockSkew + this.expires);
        if (issueInstant.isAfter((ReadableInstant)latestValid)) {
            this.log.warn("Message was not yet valid: message time was {}, latest valid is: {}", (Object)issueInstant, (Object)latestValid);
            throw new SecurityPolicyException("Message was rejected because was issued in the future");
        }
        if (expiration.isBefore((ReadableInstant)now)) {
            this.log.error("Message was expired: message issue time was '" + issueInstant + "', message expired at: '" + expiration + "', current time: '" + now + "'");
            throw new SecurityPolicyException("Message was rejected due to issue instant expiration");
        }
    }
}

