/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.profile.saml2;

import edu.internet2.middleware.shibboleth.common.attribute.AttributeRequestException;
import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.encoding.AttributeEncoder;
import edu.internet2.middleware.shibboleth.common.attribute.encoding.AttributeEncodingException;
import edu.internet2.middleware.shibboleth.common.attribute.encoding.SAML2NameIDEncoder;
import edu.internet2.middleware.shibboleth.common.attribute.provider.SAML2AttributeAuthority;
import edu.internet2.middleware.shibboleth.common.log.AuditLogEntry;
import edu.internet2.middleware.shibboleth.common.profile.ProfileException;
import edu.internet2.middleware.shibboleth.common.profile.provider.BaseSAMLProfileRequestContext;
import edu.internet2.middleware.shibboleth.common.relyingparty.provider.CryptoOperationRequirementLevel;
import edu.internet2.middleware.shibboleth.common.relyingparty.provider.saml2.AbstractSAML2ProfileConfiguration;
import edu.internet2.middleware.shibboleth.common.session.Session;
import edu.internet2.middleware.shibboleth.idp.profile.AbstractSAMLProfileHandler;
import edu.internet2.middleware.shibboleth.idp.profile.saml2.BaseSAML2ProfileRequestContext;
import edu.internet2.middleware.shibboleth.idp.session.ServiceInformation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.common.SAMLVersion;
import org.opensaml.common.binding.encoding.SAMLMessageEncoder;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.AttributeQuery;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.saml2.core.Audience;
import org.opensaml.saml2.core.AudienceRestriction;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.Conditions;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.NameIDPolicy;
import org.opensaml.saml2.core.ProxyRestriction;
import org.opensaml.saml2.core.RequestAbstractType;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.Statement;
import org.opensaml.saml2.core.Status;
import org.opensaml.saml2.core.StatusCode;
import org.opensaml.saml2.core.StatusMessage;
import org.opensaml.saml2.core.StatusResponseType;
import org.opensaml.saml2.core.Subject;
import org.opensaml.saml2.core.SubjectConfirmation;
import org.opensaml.saml2.core.SubjectConfirmationData;
import org.opensaml.saml2.encryption.Encrypter;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.security.MetadataCredentialResolver;
import org.opensaml.security.MetadataCriteria;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.ws.transport.http.HTTPInTransport;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilder;
import org.opensaml.xml.encryption.EncryptionException;
import org.opensaml.xml.encryption.EncryptionParameters;
import org.opensaml.xml.encryption.KeyEncryptionParameters;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityConfiguration;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.security.criteria.EntityIDCriteria;
import org.opensaml.xml.security.criteria.UsageCriteria;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.SignatureException;
import org.opensaml.xml.signature.Signer;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSAML2ProfileHandler
extends AbstractSAMLProfileHandler {
    public static final SAMLVersion SAML_VERSION = SAMLVersion.VERSION_20;
    private Logger log = LoggerFactory.getLogger(AbstractSAML2ProfileHandler.class);
    private SAMLObjectBuilder<Response> responseBuilder = (SAMLObjectBuilder)this.getBuilderFactory().getBuilder(Response.DEFAULT_ELEMENT_NAME);
    private SAMLObjectBuilder<Status> statusBuilder = (SAMLObjectBuilder)this.getBuilderFactory().getBuilder(Status.DEFAULT_ELEMENT_NAME);
    private SAMLObjectBuilder<StatusCode> statusCodeBuilder = (SAMLObjectBuilder)this.getBuilderFactory().getBuilder(StatusCode.DEFAULT_ELEMENT_NAME);
    private SAMLObjectBuilder<StatusMessage> statusMessageBuilder = (SAMLObjectBuilder)this.getBuilderFactory().getBuilder(StatusMessage.DEFAULT_ELEMENT_NAME);
    private SAMLObjectBuilder<Assertion> assertionBuilder;
    private SAMLObjectBuilder<Issuer> issuerBuilder = (SAMLObjectBuilder)this.getBuilderFactory().getBuilder(Issuer.DEFAULT_ELEMENT_NAME);
    private SAMLObjectBuilder<Subject> subjectBuilder;
    private SAMLObjectBuilder<SubjectConfirmation> subjectConfirmationBuilder;
    private SAMLObjectBuilder<SubjectConfirmationData> subjectConfirmationDataBuilder;
    private SAMLObjectBuilder<Conditions> conditionsBuilder;
    private SAMLObjectBuilder<AudienceRestriction> audienceRestrictionBuilder;
    private SAMLObjectBuilder<ProxyRestriction> proxyRestrictionBuilder;
    private SAMLObjectBuilder<Audience> audienceBuilder;
    private XMLObjectBuilder<Signature> signatureBuilder;

    protected AbstractSAML2ProfileHandler() {
        this.assertionBuilder = (SAMLObjectBuilder)this.getBuilderFactory().getBuilder(Assertion.DEFAULT_ELEMENT_NAME);
        this.subjectBuilder = (SAMLObjectBuilder)this.getBuilderFactory().getBuilder(Subject.DEFAULT_ELEMENT_NAME);
        this.subjectConfirmationBuilder = (SAMLObjectBuilder)this.getBuilderFactory().getBuilder(SubjectConfirmation.DEFAULT_ELEMENT_NAME);
        this.subjectConfirmationDataBuilder = (SAMLObjectBuilder)this.getBuilderFactory().getBuilder(SubjectConfirmationData.DEFAULT_ELEMENT_NAME);
        this.conditionsBuilder = (SAMLObjectBuilder)this.getBuilderFactory().getBuilder(Conditions.DEFAULT_ELEMENT_NAME);
        this.audienceRestrictionBuilder = (SAMLObjectBuilder)this.getBuilderFactory().getBuilder(AudienceRestriction.DEFAULT_ELEMENT_NAME);
        this.proxyRestrictionBuilder = (SAMLObjectBuilder)this.getBuilderFactory().getBuilder(ProxyRestriction.DEFAULT_ELEMENT_NAME);
        this.audienceBuilder = (SAMLObjectBuilder)this.getBuilderFactory().getBuilder(Audience.DEFAULT_ELEMENT_NAME);
        this.signatureBuilder = this.getBuilderFactory().getBuilder(Signature.DEFAULT_ELEMENT_NAME);
    }

    @Override
    protected void populateRequestContext(BaseSAMLProfileRequestContext requestContext) throws ProfileException {
        BaseSAML2ProfileRequestContext saml2Request = (BaseSAML2ProfileRequestContext)requestContext;
        try {
            super.populateRequestContext(requestContext);
        }
        catch (ProfileException e) {
            if (saml2Request.getFailureStatus() == null) {
                saml2Request.setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Requester", null, e.getMessage()));
            }
            throw e;
        }
    }

    @Override
    protected void populateUserInformation(BaseSAMLProfileRequestContext requestContext) {
        NameID subject;
        edu.internet2.middleware.shibboleth.idp.session.Session userSession = this.getUserSession(requestContext.getInboundMessageTransport());
        if (userSession == null && (subject = (NameID)requestContext.getSubjectNameIdentifier()) != null && subject.getValue() != null) {
            userSession = this.getUserSession(subject.getValue());
        }
        if (userSession != null) {
            requestContext.setUserSession((Session)userSession);
            requestContext.setPrincipalName(userSession.getPrincipalName());
            ServiceInformation serviceInfo = userSession.getServicesInformation().get(requestContext.getInboundMessageIssuer());
            if (serviceInfo != null) {
                requestContext.setPrincipalAuthenticationMethod(serviceInfo.getAuthenticationMethod().getAuthenticationMethod());
            }
        }
    }

    protected void checkSamlVersion(BaseSAML2ProfileRequestContext<?, ?, ?> requestContext) throws ProfileException {
        SAMLVersion version = ((RequestAbstractType)requestContext.getInboundSAMLMessage()).getVersion();
        if (version.getMajorVersion() < 2) {
            requestContext.setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:VersionMismatch", "urn:oasis:names:tc:SAML:2.0:status:RequestVersionTooLow", null));
            throw new ProfileException("SAML request version too low");
        }
        if (version.getMajorVersion() > 2 || version.getMinorVersion() > 0) {
            requestContext.setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:VersionMismatch", "urn:oasis:names:tc:SAML:2.0:status:RequestVersionTooHigh", null));
            throw new ProfileException("SAML request version too high");
        }
    }

    protected Response buildResponse(BaseSAML2ProfileRequestContext<?, ?, ?> requestContext, String subjectConfirmationMethod, List<Statement> statements) throws ProfileException {
        Response samlResponse;
        block7: {
            DateTime issueInstant = new DateTime();
            samlResponse = (Response)this.responseBuilder.buildObject();
            samlResponse.setIssueInstant(issueInstant);
            this.populateStatusResponse(requestContext, (StatusResponseType)samlResponse);
            Assertion assertion = null;
            if (statements != null && !statements.isEmpty()) {
                assertion = this.buildAssertion(requestContext, issueInstant);
                assertion.getStatements().addAll(statements);
                assertion.setSubject(this.buildSubject(requestContext, subjectConfirmationMethod, issueInstant));
                this.signAssertion(requestContext, assertion);
                SAMLMessageEncoder encoder = this.getMessageEncoders().get(requestContext.getPeerEntityEndpoint().getBinding());
                try {
                    if (((AbstractSAML2ProfileConfiguration)requestContext.getProfileConfiguration()).getEncryptAssertion() == CryptoOperationRequirementLevel.always || ((AbstractSAML2ProfileConfiguration)requestContext.getProfileConfiguration()).getEncryptAssertion() == CryptoOperationRequirementLevel.conditional && !encoder.providesMessageConfidentiality(requestContext)) {
                        this.log.debug("Attempting to encrypt assertion to relying party {}", (Object)requestContext.getInboundMessageIssuer());
                        try {
                            Encrypter encrypter = this.getEncrypter(requestContext.getInboundMessageIssuer());
                            samlResponse.getEncryptedAssertions().add(encrypter.encrypt(assertion));
                            break block7;
                        }
                        catch (SecurityException e) {
                            this.log.error("Unable to construct encrypter", (Throwable)e);
                            requestContext.setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Responder", null, "Unable to encrypt assertion"));
                            throw new ProfileException("Unable to construct encrypter", (Exception)((Object)e));
                        }
                        catch (EncryptionException e) {
                            this.log.error("Unable to encrypt assertion", (Throwable)e);
                            requestContext.setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Responder", null, "Unable to encrypt assertion"));
                            throw new ProfileException("Unable to encrypt assertion", (Exception)((Object)e));
                        }
                    }
                    samlResponse.getAssertions().add(assertion);
                }
                catch (MessageEncodingException e) {
                    this.log.error("Unable to determine if outbound encoding {} can provide confidentiality", (Object)encoder.getBindingURI());
                    throw new ProfileException("Unable to determine if assertions should be encrypted");
                }
            }
        }
        Status status = this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Success", null, null);
        samlResponse.setStatus(status);
        return samlResponse;
    }

    protected Assertion buildAssertion(BaseSAML2ProfileRequestContext<?, ?, ?> requestContext, DateTime issueInstant) {
        Assertion assertion = (Assertion)this.assertionBuilder.buildObject();
        assertion.setID(this.getIdGenerator().generateIdentifier());
        assertion.setIssueInstant(issueInstant);
        assertion.setVersion(SAMLVersion.VERSION_20);
        assertion.setIssuer(this.buildEntityIssuer(requestContext));
        Conditions conditions = this.buildConditions(requestContext, issueInstant);
        assertion.setConditions(conditions);
        return assertion;
    }

    protected Issuer buildEntityIssuer(BaseSAML2ProfileRequestContext<?, ?, ?> requestContext) {
        Issuer issuer = (Issuer)this.issuerBuilder.buildObject();
        issuer.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
        issuer.setValue(requestContext.getLocalEntityId());
        return issuer;
    }

    protected Conditions buildConditions(BaseSAML2ProfileRequestContext<?, ?, ?> requestContext, DateTime issueInstant) {
        AbstractSAML2ProfileConfiguration profileConfig = (AbstractSAML2ProfileConfiguration)requestContext.getProfileConfiguration();
        Conditions conditions = (Conditions)this.conditionsBuilder.buildObject();
        conditions.setNotBefore(issueInstant);
        conditions.setNotOnOrAfter(issueInstant.plus(profileConfig.getAssertionLifetime()));
        AudienceRestriction audienceRestriction = (AudienceRestriction)this.audienceRestrictionBuilder.buildObject();
        Audience audience = (Audience)this.audienceBuilder.buildObject();
        audience.setAudienceURI(requestContext.getInboundMessageIssuer());
        audienceRestriction.getAudiences().add(audience);
        Collection audiences = profileConfig.getAssertionAudiences();
        if (audiences != null && audiences.size() > 0) {
            for (String audienceUri : audiences) {
                audience = (Audience)this.audienceBuilder.buildObject();
                audience.setAudienceURI(audienceUri);
                audienceRestriction.getAudiences().add(audience);
            }
        }
        conditions.getAudienceRestrictions().add(audienceRestriction);
        audiences = profileConfig.getProxyAudiences();
        if (audiences != null && audiences.size() > 0) {
            ProxyRestriction proxyRestriction = (ProxyRestriction)this.proxyRestrictionBuilder.buildObject();
            for (String audienceUri : audiences) {
                audience = (Audience)this.audienceBuilder.buildObject();
                audience.setAudienceURI(audienceUri);
                proxyRestriction.getAudiences().add(audience);
            }
            proxyRestriction.setProxyCount(Integer.valueOf(profileConfig.getProxyCount()));
            conditions.getConditions().add(proxyRestriction);
        }
        return conditions;
    }

    protected void populateStatusResponse(BaseSAML2ProfileRequestContext<?, ?, ?> requestContext, StatusResponseType response) {
        response.setID(this.getIdGenerator().generateIdentifier());
        response.setInResponseTo(requestContext.getInboundSAMLMessageId());
        response.setIssuer(this.buildEntityIssuer(requestContext));
        response.setVersion(SAMLVersion.VERSION_20);
    }

    protected void resolveAttributes(BaseSAML2ProfileRequestContext<?, ?, ?> requestContext) throws ProfileException {
        AbstractSAML2ProfileConfiguration profileConfiguration = (AbstractSAML2ProfileConfiguration)requestContext.getProfileConfiguration();
        SAML2AttributeAuthority attributeAuthority = profileConfiguration.getAttributeAuthority();
        try {
            this.log.debug("Resolving attributes for principal {} of SAML request from relying party {}", (Object)requestContext.getPrincipalName(), (Object)requestContext.getInboundMessageIssuer());
            Map principalAttributes = attributeAuthority.getAttributes(requestContext);
            requestContext.setAttributes(principalAttributes);
        }
        catch (AttributeRequestException e) {
            this.log.error("Error resolving attributes for SAML request " + requestContext.getInboundSAMLMessageId() + " from relying party " + requestContext.getInboundMessageIssuer(), (Throwable)e);
            requestContext.setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Responder", null, "Error resolving attributes"));
            throw new ProfileException("Error resolving attributes for SAML request " + requestContext.getInboundSAMLMessageId() + " from relying party " + requestContext.getInboundMessageIssuer(), (Exception)((Object)e));
        }
    }

    protected AttributeStatement buildAttributeStatement(BaseSAML2ProfileRequestContext<?, ?, ?> requestContext) throws ProfileException {
        this.log.debug("Creating attribute statement in response to SAML request {} from relying party {}", (Object)requestContext.getInboundSAMLMessageId(), (Object)requestContext.getInboundMessageIssuer());
        AbstractSAML2ProfileConfiguration profileConfiguration = (AbstractSAML2ProfileConfiguration)requestContext.getProfileConfiguration();
        SAML2AttributeAuthority attributeAuthority = profileConfiguration.getAttributeAuthority();
        try {
            if (requestContext.getInboundSAMLMessage() instanceof AttributeQuery) {
                return attributeAuthority.buildAttributeStatement((AttributeQuery)requestContext.getInboundSAMLMessage(), requestContext.getAttributes().values());
            }
            return attributeAuthority.buildAttributeStatement(null, requestContext.getAttributes().values());
        }
        catch (AttributeRequestException e) {
            this.log.error("Error encoding attributes for principal " + requestContext.getPrincipalName(), (Throwable)e);
            requestContext.setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Responder", null, "Error resolving attributes"));
            throw new ProfileException("Error encoding attributes for principal " + requestContext.getPrincipalName(), (Exception)((Object)e));
        }
    }

    protected void resolvePrincipal(BaseSAML2ProfileRequestContext<?, ?, ?> requestContext) throws ProfileException {
        AbstractSAML2ProfileConfiguration profileConfiguration = (AbstractSAML2ProfileConfiguration)requestContext.getProfileConfiguration();
        if (profileConfiguration == null) {
            this.log.error("Unable to resolve principal, no SAML 2 profile configuration for relying party " + requestContext.getInboundMessageIssuer());
            requestContext.setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Responder", "urn:oasis:names:tc:SAML:2.0:status:RequestDenied", "Error resolving principal"));
            throw new ProfileException("Unable to resolve principal, no SAML 2 profile configuration for relying party " + requestContext.getInboundMessageIssuer());
        }
        SAML2AttributeAuthority attributeAuthority = profileConfiguration.getAttributeAuthority();
        this.log.debug("Resolving principal name for subject of SAML request {} from relying party {}", (Object)requestContext.getInboundSAMLMessageId(), (Object)requestContext.getInboundMessageIssuer());
        try {
            String principal = attributeAuthority.getPrincipal(requestContext);
            requestContext.setPrincipalName(principal);
        }
        catch (AttributeRequestException e) {
            this.log.error("Error resolving attributes for SAML request " + requestContext.getInboundSAMLMessageId() + " from relying party " + requestContext.getInboundMessageIssuer(), (Throwable)e);
            requestContext.setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Responder", "urn:oasis:names:tc:SAML:2.0:status:UnknownPrincipal", "Error resolving principal"));
            throw new ProfileException("Error resolving attributes for SAML request " + requestContext.getInboundSAMLMessageId() + " from relying party " + requestContext.getInboundMessageIssuer(), (Exception)((Object)e));
        }
    }

    protected void signAssertion(BaseSAML2ProfileRequestContext<?, ?, ?> requestContext, Assertion assertion) throws ProfileException {
        SPSSODescriptor ssoDescriptor;
        this.log.debug("Determining if SAML assertion to relying party {} should be signed", (Object)requestContext.getInboundMessageIssuer());
        boolean signAssertion = false;
        SAMLMessageEncoder encoder = this.getMessageEncoders().get(requestContext.getPeerEntityEndpoint().getBinding());
        AbstractSAML2ProfileConfiguration profileConfig = (AbstractSAML2ProfileConfiguration)requestContext.getProfileConfiguration();
        try {
            if (profileConfig.getSignAssertions() == CryptoOperationRequirementLevel.always || profileConfig.getSignAssertions() == CryptoOperationRequirementLevel.conditional && !encoder.providesMessageIntegrity(requestContext)) {
                signAssertion = true;
                this.log.debug("IdP relying party configuration {} indicates to sign assertions: {}", (Object)requestContext.getRelyingPartyConfiguration().getRelyingPartyId(), (Object)signAssertion);
            }
        }
        catch (MessageEncodingException e) {
            this.log.error("Unable to determine if outbound encoding {} can provide integrity protection", (Object)encoder.getBindingURI());
            throw new ProfileException("Unable to determine if outbound message should be signed");
        }
        if (!signAssertion && requestContext.getPeerEntityRoleMetadata() instanceof SPSSODescriptor && (ssoDescriptor = (SPSSODescriptor)requestContext.getPeerEntityRoleMetadata()).getWantAssertionsSigned() != null) {
            signAssertion = ssoDescriptor.getWantAssertionsSigned();
            this.log.debug("Entity metadata for relying party {} indicates to sign assertions: {}", (Object)requestContext.getInboundMessageIssuer(), (Object)signAssertion);
        }
        if (!signAssertion) {
            return;
        }
        this.log.debug("Determining signing credntial for assertion to relying party {}", (Object)requestContext.getInboundMessageIssuer());
        Credential signatureCredential = profileConfig.getSigningCredential();
        if (signatureCredential == null) {
            signatureCredential = requestContext.getRelyingPartyConfiguration().getDefaultSigningCredential();
        }
        if (signatureCredential == null) {
            throw new ProfileException("No signing credential is specified for relying party configuration " + requestContext.getRelyingPartyConfiguration().getProviderId() + " or it's SAML2 attribute query profile configuration");
        }
        this.log.debug("Signing assertion to relying party {}", (Object)requestContext.getInboundMessageIssuer());
        Signature signature = (Signature)this.signatureBuilder.buildObject(Signature.DEFAULT_ELEMENT_NAME);
        signature.setSigningCredential(signatureCredential);
        try {
            SecurityHelper.prepareSignatureParams((Signature)signature, (Credential)signatureCredential, null, null);
        }
        catch (SecurityException e) {
            throw new ProfileException("Error preparing signature for signing", (Exception)((Object)e));
        }
        assertion.setSignature(signature);
        Marshaller assertionMarshaller = Configuration.getMarshallerFactory().getMarshaller((XMLObject)assertion);
        try {
            assertionMarshaller.marshall((XMLObject)assertion);
            Signer.signObject((Signature)signature);
        }
        catch (MarshallingException e) {
            this.log.error("Unable to marshall assertion for signing", (Throwable)e);
            throw new ProfileException("Unable to marshall assertion for signing", (Exception)((Object)e));
        }
        catch (SignatureException e) {
            this.log.error("Unable to sign assertion", (Throwable)e);
            throw new ProfileException("Unable to sign assertion", (Exception)((Object)e));
        }
    }

    protected Status buildStatus(String topLevelCode, String secondLevelCode, String failureMessage) {
        Status status = (Status)this.statusBuilder.buildObject();
        StatusCode statusCode = (StatusCode)this.statusCodeBuilder.buildObject();
        statusCode.setValue(DatatypeHelper.safeTrimOrNullString((String)topLevelCode));
        status.setStatusCode(statusCode);
        if (secondLevelCode != null) {
            StatusCode secondLevelStatusCode = (StatusCode)this.statusCodeBuilder.buildObject();
            secondLevelStatusCode.setValue(DatatypeHelper.safeTrimOrNullString((String)secondLevelCode));
            statusCode.setStatusCode(secondLevelStatusCode);
        }
        if (failureMessage != null) {
            StatusMessage msg = (StatusMessage)this.statusMessageBuilder.buildObject();
            msg.setMessage(failureMessage);
            status.setStatusMessage(msg);
        }
        return status;
    }

    protected Subject buildSubject(BaseSAML2ProfileRequestContext<?, ?, ?> requestContext, String confirmationMethod, DateTime issueInstant) throws ProfileException {
        Subject subject;
        block8: {
            AuthnRequest authnRequest;
            NameIDPolicy policy;
            subject = (Subject)this.subjectBuilder.buildObject();
            subject.getSubjectConfirmations().add(this.buildSubjectConfirmation(requestContext, confirmationMethod, issueInstant));
            NameID nameID = this.buildNameId(requestContext);
            if (nameID == null) {
                return subject;
            }
            requestContext.setSubjectNameIdentifier((SAMLObject)nameID);
            boolean nameIdEncRequiredByAuthnRequest = false;
            if (requestContext.getInboundSAMLMessage() instanceof AuthnRequest && (policy = (authnRequest = (AuthnRequest)requestContext.getInboundSAMLMessage()).getNameIDPolicy()) != null && DatatypeHelper.safeEquals((Object)policy.getFormat(), (Object)"urn:oasis:names:tc:SAML:2.0:nameid-format:encrypted")) {
                nameIdEncRequiredByAuthnRequest = true;
            }
            SAMLMessageEncoder encoder = this.getMessageEncoders().get(requestContext.getPeerEntityEndpoint().getBinding());
            try {
                if (nameIdEncRequiredByAuthnRequest || ((AbstractSAML2ProfileConfiguration)requestContext.getProfileConfiguration()).getEncryptNameID() == CryptoOperationRequirementLevel.always || ((AbstractSAML2ProfileConfiguration)requestContext.getProfileConfiguration()).getEncryptNameID() == CryptoOperationRequirementLevel.conditional && !encoder.providesMessageConfidentiality(requestContext)) {
                    this.log.debug("Attempting to encrypt NameID to relying party {}", (Object)requestContext.getInboundMessageIssuer());
                    try {
                        Encrypter encrypter = this.getEncrypter(requestContext.getInboundMessageIssuer());
                        subject.setEncryptedID(encrypter.encrypt(nameID));
                        break block8;
                    }
                    catch (SecurityException e) {
                        this.log.error("Unable to construct encrypter", (Throwable)e);
                        requestContext.setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Responder", null, "Unable to encrypt NameID"));
                        throw new ProfileException("Unable to construct encrypter", (Exception)((Object)e));
                    }
                    catch (EncryptionException e) {
                        this.log.error("Unable to encrypt NameID", (Throwable)e);
                        requestContext.setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Responder", null, "Unable to encrypt NameID"));
                        throw new ProfileException("Unable to encrypt NameID", (Exception)((Object)e));
                    }
                }
                subject.setNameID(nameID);
            }
            catch (MessageEncodingException e) {
                this.log.error("Unable to determine if outbound encoding {} can provide confidentiality", (Object)encoder.getBindingURI());
                throw new ProfileException("Unable to determine if assertions should be encrypted");
            }
        }
        return subject;
    }

    protected SubjectConfirmation buildSubjectConfirmation(BaseSAML2ProfileRequestContext<?, ?, ?> requestContext, String confirmationMethod, DateTime issueInstant) {
        SubjectConfirmationData confirmationData = (SubjectConfirmationData)this.subjectConfirmationDataBuilder.buildObject();
        HTTPInTransport inTransport = (HTTPInTransport)requestContext.getInboundMessageTransport();
        confirmationData.setAddress(inTransport.getPeerAddress());
        confirmationData.setInResponseTo(requestContext.getInboundSAMLMessageId());
        confirmationData.setNotOnOrAfter(issueInstant.plus(((AbstractSAML2ProfileConfiguration)requestContext.getProfileConfiguration()).getAssertionLifetime()));
        Endpoint relyingPartyEndpoint = requestContext.getPeerEntityEndpoint();
        if (relyingPartyEndpoint != null) {
            if (relyingPartyEndpoint.getResponseLocation() != null) {
                confirmationData.setRecipient(relyingPartyEndpoint.getResponseLocation());
            } else {
                confirmationData.setRecipient(relyingPartyEndpoint.getLocation());
            }
        }
        SubjectConfirmation subjectConfirmation = (SubjectConfirmation)this.subjectConfirmationBuilder.buildObject();
        subjectConfirmation.setMethod(confirmationMethod);
        subjectConfirmation.setSubjectConfirmationData(confirmationData);
        return subjectConfirmation;
    }

    protected NameID buildNameId(BaseSAML2ProfileRequestContext<?, ?, ?> requestContext) throws ProfileException {
        Map principalAttributes;
        AuthnRequest authnRequest;
        this.log.debug("Building assertion NameID for principal/relying party:{}/{}", (Object)requestContext.getPrincipalName(), (Object)requestContext.getInboundMessageIssuer());
        String requiredNameFormat = null;
        if (requestContext.getInboundSAMLMessage() instanceof AuthnRequest && (authnRequest = (AuthnRequest)requestContext.getInboundSAMLMessage()).getNameIDPolicy() != null && (requiredNameFormat = DatatypeHelper.safeTrimOrNullString((String)authnRequest.getNameIDPolicy().getFormat())) != null && (requiredNameFormat.equals("urn:oasis:names:tc:SAML:2.0:nameid-format:encrypted") || requiredNameFormat.equals("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified"))) {
            requiredNameFormat = null;
        }
        List<String> supportedNameFormats = this.getNameFormats(requestContext);
        if (requiredNameFormat != null) {
            supportedNameFormats.clear();
            supportedNameFormats.add(requiredNameFormat);
        }
        if ((principalAttributes = requestContext.getAttributes()) == null || principalAttributes.isEmpty()) {
            if (requiredNameFormat != null) {
                requestContext.setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Responder", "urn:oasis:names:tc:SAML:2.0:status:InvalidNameIDPolicy", "Format not supported: " + requiredNameFormat));
                throw new ProfileException("No attributes for principal, so NameID format required by relying party is not supported");
            }
            this.log.debug("No attributes for principal {}, no name identifier will be created.", (Object)requestContext.getPrincipalName());
            return null;
        }
        if (!supportedNameFormats.isEmpty()) {
            this.log.debug("SP-supported name formats: {}", supportedNameFormats);
        } else {
            this.log.debug("SP indicated no preferred name formats.");
        }
        try {
            for (BaseAttribute attribute : principalAttributes.values()) {
                for (AttributeEncoder encoder : attribute.getEncoders()) {
                    if (!(encoder instanceof SAML2NameIDEncoder)) continue;
                    SAML2NameIDEncoder nameIdEncoder = (SAML2NameIDEncoder)encoder;
                    if (!supportedNameFormats.isEmpty() && !supportedNameFormats.contains(nameIdEncoder.getNameFormat())) continue;
                    this.log.debug("Using attribute {} supporting NameID format {} to create the NameID.", (Object)attribute.getId(), (Object)nameIdEncoder.getNameFormat());
                    return (NameID)nameIdEncoder.encode(attribute);
                }
            }
            if (requiredNameFormat != null) {
                requestContext.setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Responder", "urn:oasis:names:tc:SAML:2.0:status:InvalidNameIDPolicy", "Format not supported: " + requiredNameFormat));
                throw new ProfileException("No attributes for principal support NameID format required by relying party");
            }
            this.log.debug("No attributes for principal {} support an encoding into a supported name ID format.", (Object)requestContext.getPrincipalName());
            return null;
        }
        catch (AttributeEncodingException e) {
            this.log.error("Unable to encode NameID attribute", (Throwable)e);
            requestContext.setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Responder", null, "Unable to construct NameID"));
            throw new ProfileException("Unable to encode NameID attribute", (Exception)((Object)e));
        }
    }

    protected Response buildErrorResponse(BaseSAML2ProfileRequestContext<?, ?, ?> requestContext) {
        Response samlResponse = (Response)this.responseBuilder.buildObject();
        samlResponse.setIssueInstant(new DateTime());
        this.populateStatusResponse(requestContext, (StatusResponseType)samlResponse);
        samlResponse.setStatus(requestContext.getFailureStatus());
        return samlResponse;
    }

    protected Encrypter getEncrypter(String peerEntityId) throws SecurityException {
        SecurityConfiguration securityConfiguration = Configuration.getGlobalSecurityConfiguration();
        EncryptionParameters dataEncParams = SecurityHelper.buildDataEncryptionParams(null, (SecurityConfiguration)securityConfiguration, null);
        Credential keyEncryptionCredential = this.getKeyEncryptionCredential(peerEntityId);
        if (keyEncryptionCredential == null) {
            this.log.error("Could not resolve a key encryption credential for peer entity: {}", (Object)peerEntityId);
            throw new SecurityException("Could not resolve key encryption credential");
        }
        String wrappedJCAKeyAlgorithm = SecurityHelper.getKeyAlgorithmFromURI((String)dataEncParams.getAlgorithm());
        KeyEncryptionParameters keyEncParams = SecurityHelper.buildKeyEncryptionParams((Credential)keyEncryptionCredential, (String)wrappedJCAKeyAlgorithm, (SecurityConfiguration)securityConfiguration, null, null);
        Encrypter encrypter = new Encrypter(dataEncParams, keyEncParams);
        encrypter.setKeyPlacement(Encrypter.KeyPlacement.INLINE);
        return encrypter;
    }

    protected Credential getKeyEncryptionCredential(String peerEntityId) throws SecurityException {
        MetadataCredentialResolver kekCredentialResolver = new MetadataCredentialResolver(this.getMetadataProvider());
        CriteriaSet criteriaSet = new CriteriaSet();
        criteriaSet.add((Object)new EntityIDCriteria(peerEntityId));
        criteriaSet.add((Object)new MetadataCriteria(SPSSODescriptor.DEFAULT_ELEMENT_NAME, "urn:oasis:names:tc:SAML:2.0:protocol"));
        criteriaSet.add((Object)new UsageCriteria(UsageType.ENCRYPTION));
        return kekCredentialResolver.resolveSingle(criteriaSet);
    }

    @Override
    protected void writeAuditLogEntry(BaseSAMLProfileRequestContext context) {
        SAML2AuditLogEntry auditLogEntry = new SAML2AuditLogEntry();
        auditLogEntry.setSAMLResponse((StatusResponseType)context.getOutboundSAMLMessage());
        auditLogEntry.setMessageProfile(this.getProfileId());
        auditLogEntry.setPrincipalAuthenticationMethod(context.getPrincipalAuthenticationMethod());
        auditLogEntry.setPrincipalName(context.getPrincipalName());
        auditLogEntry.setAssertingPartyId(context.getLocalEntityId());
        auditLogEntry.setRelyingPartyId(context.getInboundMessageIssuer());
        auditLogEntry.setRequestBinding(context.getMessageDecoder().getBindingURI());
        auditLogEntry.setRequestId(context.getInboundSAMLMessageId());
        auditLogEntry.setResponseBinding(context.getMessageEncoder().getBindingURI());
        auditLogEntry.setResponseId(context.getOutboundSAMLMessageId());
        if (context.getReleasedAttributes() != null) {
            auditLogEntry.getReleasedAttributes().addAll(context.getReleasedAttributes());
        }
        this.getAduitLog().info(auditLogEntry.toString());
    }

    protected class SAML2AuditLogEntry
    extends AuditLogEntry {
        private StatusResponseType samlResponse;

        protected SAML2AuditLogEntry() {
        }

        public StatusResponseType getSAMLResponse() {
            return this.samlResponse;
        }

        public void setSAMLResponse(StatusResponseType response) {
            this.samlResponse = response;
        }

        public String toString() {
            List assertions;
            StringBuilder entryString = new StringBuilder(super.toString());
            NameID nameIdentifier = null;
            StringBuilder assertionIds = new StringBuilder();
            if (this.samlResponse instanceof Response && (assertions = ((Response)this.samlResponse).getAssertions()) != null && !assertions.isEmpty()) {
                for (Assertion assertion : assertions) {
                    assertionIds.append(assertion.getID());
                    assertionIds.append(",");
                    if (nameIdentifier != null || assertion.getSubject() == null) continue;
                    nameIdentifier = assertion.getSubject().getNameID();
                }
            }
            if (nameIdentifier != null) {
                entryString.append(nameIdentifier.getValue());
            }
            entryString.append("|");
            entryString.append(assertionIds.toString());
            entryString.append("|");
            return entryString.toString();
        }
    }
}

