/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.profile.saml1;

import java.util.List;
import org.opensaml.common.binding.BasicEndpointSelector;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShibbolethSSOEndpointSelector
extends BasicEndpointSelector {
    private final Logger log = LoggerFactory.getLogger(ShibbolethSSOEndpointSelector.class);
    private String spAssertionConsumerService;

    public String getSpAssertionConsumerService() {
        return this.spAssertionConsumerService;
    }

    public void setSpAssertionConsumerService(String acs) {
        this.spAssertionConsumerService = DatatypeHelper.safeTrimOrNullString((String)acs);
    }

    public Endpoint selectEndpoint() {
        if (this.getEntityRoleMetadata() == null) {
            this.log.debug("Unable to select endpoint, no entity role metadata available.");
            return null;
        }
        if (this.spAssertionConsumerService != null) {
            return this.selectEndpointByACS();
        }
        return super.selectEndpoint();
    }

    protected Endpoint selectEndpointByACS() {
        this.log.debug("Selecting endpoint from metadata corresponding to provided ACS URL: {}", (Object)this.getSpAssertionConsumerService());
        List endpoints = this.getEntityRoleMetadata().getEndpoints();
        this.log.debug("Relying party role contains {} endpoints", (Object)endpoints.size());
        if (endpoints != null && endpoints.size() > 0) {
            for (Endpoint endpoint : endpoints) {
                if (endpoint == null || !this.getSupportedIssuerBindings().contains(endpoint.getBinding())) continue;
                if (endpoint.getLocation().equalsIgnoreCase(this.spAssertionConsumerService)) {
                    return endpoint;
                }
                if (DatatypeHelper.isEmpty((String)endpoint.getResponseLocation()) || !endpoint.getResponseLocation().equalsIgnoreCase(this.spAssertionConsumerService)) continue;
                return endpoint;
            }
        }
        this.log.debug("No endpoint meets selection criteria for SAML entity {}", (Object)this.getEntityMetadata().getEntityID());
        return null;
    }
}

