/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.profile.saml1;

import edu.internet2.middleware.shibboleth.idp.profile.saml1.ShibbolethSSOProfileHandler;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.common.binding.decoding.SAMLMessageDecoder;
import org.opensaml.saml1.binding.decoding.BaseSAML1MessageDecoder;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.transport.http.HTTPInTransport;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShibbolethSSODecoder
extends BaseSAML1MessageDecoder
implements SAMLMessageDecoder {
    private final Logger log = LoggerFactory.getLogger(ShibbolethSSODecoder.class);

    public ShibbolethSSODecoder() {
        super(null);
    }

    public String getBindingURI() {
        return "urn:mace:shibboleth:1.0:profiles:AuthnRequest";
    }

    protected void doDecode(MessageContext messageContext) throws MessageDecodingException {
        if (!(messageContext instanceof ShibbolethSSOProfileHandler.ShibbolethSSORequestContext)) {
            this.log.error("Invalid message context type, this decoder only support ShibbolethSSORequestContext");
            throw new MessageDecodingException("Invalid message context type, this decoder only support ShibbolethSSORequestContext");
        }
        if (!(messageContext.getInboundMessageTransport() instanceof HTTPInTransport)) {
            this.log.error("Invalid inbound message transport type, this decoder only support HTTPInTransport");
            throw new MessageDecodingException("Invalid inbound message transport type, this decoder only support HTTPInTransport");
        }
        ShibbolethSSOProfileHandler.ShibbolethSSORequestContext requestContext = (ShibbolethSSOProfileHandler.ShibbolethSSORequestContext)messageContext;
        HTTPInTransport transport = (HTTPInTransport)messageContext.getInboundMessageTransport();
        String providerId = DatatypeHelper.safeTrimOrNullString((String)transport.getParameterValue("providerId"));
        if (providerId == null) {
            this.log.error("No providerId parameter given in Shibboleth SSO authentication request.");
            throw new MessageDecodingException("No providerId parameter given in Shibboleth SSO authentication request.");
        }
        requestContext.setInboundMessageIssuer(providerId);
        String shire = DatatypeHelper.safeTrimOrNullString((String)transport.getParameterValue("shire"));
        if (shire == null) {
            this.log.error("No shire parameter given in Shibboleth SSO authentication request.");
            throw new MessageDecodingException("No shire parameter given in Shibboleth SSO authentication request.");
        }
        requestContext.setSpAssertionConsumerService(shire);
        String target = DatatypeHelper.safeTrimOrNullString((String)transport.getParameterValue("target"));
        if (target == null) {
            this.log.error("No target parameter given in Shibboleth SSO authentication request.");
            throw new MessageDecodingException("No target parameter given in Shibboleth SSO authentication request.");
        }
        requestContext.setRelayState(target);
        String timeStr = DatatypeHelper.safeTrimOrNullString((String)transport.getParameterValue("time"));
        if (timeStr != null) {
            long time = Long.parseLong(timeStr) * 1000L;
            requestContext.setInboundSAMLMessageIssueInstant(new DateTime(time, (Chronology)ISOChronology.getInstanceUTC()));
        }
        this.populateRelyingPartyMetadata((SAMLMessageContext)requestContext);
    }

    protected boolean isIntendedDestinationEndpointURIRequired(SAMLMessageContext samlMsgCtx) {
        return false;
    }

    protected String getIntendedDestinationEndpointURI(SAMLMessageContext samlMsgCtx) throws MessageDecodingException {
        return null;
    }
}

