/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.config.profile.authn;

import edu.internet2.middleware.shibboleth.idp.config.profile.authn.AbstractLoginHandlerBeanDefinitionParser;
import edu.internet2.middleware.shibboleth.idp.config.profile.authn.IPAddressLoginHandlerFactoryBean;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class IPAddressLoginHandlerBeanDefinitionParser
extends AbstractLoginHandlerBeanDefinitionParser {
    public static final QName SCHEMA_TYPE = new QName("urn:mace:shibboleth:2.0:idp:profile-handler", "IPAddress");
    public static final QName IP_ENTRY_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:idp:profile-handler", "IPEntry");
    private final Logger log = LoggerFactory.getLogger(IPAddressLoginHandlerBeanDefinitionParser.class);

    protected Class getBeanClass(Element element) {
        return IPAddressLoginHandlerFactoryBean.class;
    }

    protected void doParse(Element config, BeanDefinitionBuilder builder) {
        super.doParse(config, builder);
        boolean defaultDeny = XMLHelper.getAttributeValueAsBoolean((Attr)config.getAttributeNodeNS(null, "defaultDeny"));
        this.log.debug("Setting defaultDeny to: {}", (Object)defaultDeny);
        builder.addPropertyValue("defaultDeny", (Object)defaultDeny);
        String username = DatatypeHelper.safeTrim((String)config.getAttributeNS(null, "username"));
        this.log.debug("Setting username to: {}", (Object)username);
        builder.addPropertyValue("username", (Object)username);
        Map children = XMLHelper.getChildElements((Element)config);
        List ipEntries = (List)children.get(IP_ENTRY_ELEMENT_NAME);
        ArrayList<String> addresses = new ArrayList<String>();
        for (Element element : ipEntries) {
            String address = DatatypeHelper.safeTrimOrNullString((String)element.getTextContent());
            if (address == null) continue;
            this.log.debug("Adding IP Address: {}", (Object)address);
            addresses.add(address);
        }
        builder.addPropertyValue("addresses", addresses);
    }
}

