/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.authn.provider;

import edu.internet2.middleware.shibboleth.idp.authn.AuthenticationEngine;
import edu.internet2.middleware.shibboleth.idp.authn.provider.AbstractLoginHandler;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPAddressLoginHandler
extends AbstractLoginHandler {
    private final Logger log = LoggerFactory.getLogger(IPAddressLoginHandler.class);
    private String authnMethodURI = "urn:oasis:names:tc:SAML:2.0:ac:classes:InternetProtocol";
    private String username;
    private boolean defaultDeny;
    private List<IPEntry> ipList;

    public void setEntries(List<String> entries, boolean defaultDeny) {
        this.defaultDeny = defaultDeny;
        this.ipList = new CopyOnWriteArrayList<IPEntry>();
        for (String addr : entries) {
            try {
                this.ipList.add(new IPEntry(addr));
            }
            catch (UnknownHostException ex) {
                this.log.error("IPAddressHandler: Error parsing IP entry \"" + addr + "\". Ignoring.");
            }
        }
    }

    @Override
    public boolean supportsPassive() {
        return true;
    }

    @Override
    public boolean supportsForceAuthentication() {
        return true;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String name) {
        this.username = name;
    }

    @Override
    public void login(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        if (this.defaultDeny) {
            this.handleDefaultDeny(httpRequest, httpResponse);
        } else {
            this.handleDefaultAllow(httpRequest, httpResponse);
        }
        AuthenticationEngine.returnToAuthenticationEngine(httpRequest, httpResponse);
    }

    protected void handleDefaultDeny(HttpServletRequest request, HttpServletResponse response) {
        boolean ipAllowed = this.searchIpList((ServletRequest)request);
        if (ipAllowed) {
            this.log.debug("Authenticated user by IP address");
            request.setAttribute("principal_name", (Object)this.username);
        }
    }

    protected void handleDefaultAllow(HttpServletRequest request, HttpServletResponse response) {
        boolean ipDenied = this.searchIpList((ServletRequest)request);
        if (!ipDenied) {
            this.log.debug("Authenticated user by IP address");
            request.setAttribute("principal_name", (Object)this.username);
        }
    }

    private boolean searchIpList(ServletRequest request) {
        boolean found = false;
        try {
            InetAddress addr = InetAddress.getByName(request.getRemoteAddr());
            BitSet addrbits = this.byteArrayToBitSet(addr.getAddress());
            for (IPEntry entry : this.ipList) {
                BitSet netaddr = entry.getNetworkAddress();
                BitSet netmask = entry.getNetmask();
                addrbits.and(netmask);
                if (!addrbits.equals(netaddr)) continue;
                found = true;
                break;
            }
        }
        catch (UnknownHostException ex) {
            this.log.error("Error resolving hostname.", (Throwable)ex);
            return false;
        }
        return found;
    }

    protected BitSet byteArrayToBitSet(byte[] bytes) {
        BitSet bits = new BitSet();
        for (int i = 0; i < bytes.length * 8; ++i) {
            if ((bytes[bytes.length - i / 8 - 1] & 1 << i % 8) <= 0) continue;
            bits.set(i);
        }
        return bits;
    }

    protected class IPEntry {
        private final BitSet networkAddress;
        private final BitSet netmask;

        public IPEntry(String entry) throws UnknownHostException {
            if (entry == null || entry.length() == 0) {
                throw new UnknownHostException("entry is null.");
            }
            int cidrOffset = entry.indexOf("/");
            if (cidrOffset == -1) {
                IPAddressLoginHandler.this.log.error("Invalid entry \"" + entry + "\" -- it lacks a netmask component.");
                throw new UnknownHostException("entry lacks a netmask component.");
            }
            if (entry.indexOf("/", cidrOffset + 1) != -1) {
                IPAddressLoginHandler.this.log.error("Invalid entry \"" + entry + "\" -- too many \"/\" present.");
                throw new UnknownHostException("entry has too many netmask components.");
            }
            String networkString = entry.substring(0, cidrOffset);
            String netmaskString = entry.substring(cidrOffset + 1, entry.length());
            InetAddress tempAddr = InetAddress.getByName(networkString);
            this.networkAddress = IPAddressLoginHandler.this.byteArrayToBitSet(tempAddr.getAddress());
            int masklen = Integer.parseInt(netmaskString);
            int addrlen = this.networkAddress.length();
            if (tempAddr instanceof Inet4Address && masklen > 32) {
                throw new UnknownHostException("Netmask is too large for an IPv4 address: " + masklen);
            }
            if (tempAddr instanceof Inet6Address && masklen > 128) {
                throw new UnknownHostException("Netmask is too large for an IPv6 address: " + masklen);
            }
            this.netmask = new BitSet(addrlen);
            this.netmask.set(addrlen - masklen, addrlen, true);
        }

        public BitSet getNetworkAddress() {
            return this.networkAddress;
        }

        public BitSet getNetmask() {
            return this.netmask;
        }
    }
}

