/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.authn;

import edu.internet2.middleware.shibboleth.common.session.Session;
import edu.internet2.middleware.shibboleth.common.session.SessionManager;
import edu.internet2.middleware.shibboleth.common.util.HttpHelper;
import edu.internet2.middleware.shibboleth.idp.authn.AuthenticationException;
import edu.internet2.middleware.shibboleth.idp.authn.ForceAuthenticationException;
import edu.internet2.middleware.shibboleth.idp.authn.LoginContext;
import edu.internet2.middleware.shibboleth.idp.authn.LoginContextEntry;
import edu.internet2.middleware.shibboleth.idp.authn.LoginHandler;
import edu.internet2.middleware.shibboleth.idp.authn.PassiveAuthenticationException;
import edu.internet2.middleware.shibboleth.idp.authn.UsernamePrincipal;
import edu.internet2.middleware.shibboleth.idp.profile.IdPProfileHandlerManager;
import edu.internet2.middleware.shibboleth.idp.session.AuthenticationMethodInformation;
import edu.internet2.middleware.shibboleth.idp.session.impl.AuthenticationMethodInformationImpl;
import edu.internet2.middleware.shibboleth.idp.session.impl.ServiceInformationImpl;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joda.time.DateTime;
import org.opensaml.common.IdentifierGenerator;
import org.opensaml.common.impl.SecureRandomIdentifierGenerator;
import org.opensaml.util.storage.StorageService;
import org.opensaml.ws.transport.http.HTTPTransportUtils;
import org.opensaml.xml.util.Base64;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationEngine
extends HttpServlet {
    public static final String LOGIN_CONTEXT_PARTITION_NAME_INIT_PARAM_NAME = "loginContextPartitionName";
    public static final String LOGIN_CONTEXT_LIFETIME_INIT_PARAM_NAME = "loginContextEntryLifetime";
    public static final String IDP_SESSION_COOKIE_NAME = "_idp_session";
    public static final String LOGIN_CONTEXT_KEY_NAME = "_idp_authn_lc_key";
    private static final long serialVersionUID = -8479060989001890156L;
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationEngine.class);
    private static StorageService<String, LoginContextEntry> storageService;
    private static String loginContextPartitionName;
    private static long loginContextEntryLifetime;
    private static IdentifierGenerator idGen;
    private IdPProfileHandlerManager handlerManager;
    private SessionManager<edu.internet2.middleware.shibboleth.idp.session.Session> sessionManager;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String handlerManagerId = config.getInitParameter("handlerManagerId");
        if (DatatypeHelper.isEmpty((String)handlerManagerId)) {
            handlerManagerId = "shibboleth.HandlerManager";
        }
        this.handlerManager = (IdPProfileHandlerManager)((Object)this.getServletContext().getAttribute(handlerManagerId));
        String sessionManagerId = config.getInitParameter("sessionManagedId");
        if (DatatypeHelper.isEmpty((String)sessionManagerId)) {
            sessionManagerId = "shibboleth.SessionManager";
        }
        this.sessionManager = (SessionManager)this.getServletContext().getAttribute(sessionManagerId);
        String storageServiceId = config.getInitParameter("storageServiceId");
        if (DatatypeHelper.isEmpty((String)storageServiceId)) {
            storageServiceId = "shibboleth.StorageService";
        }
        storageService = (StorageService)this.getServletContext().getAttribute(storageServiceId);
        String partitionName = DatatypeHelper.safeTrimOrNullString((String)config.getInitParameter(LOGIN_CONTEXT_PARTITION_NAME_INIT_PARAM_NAME));
        loginContextPartitionName = partitionName != null ? partitionName : "loginContexts";
        String lifetime = DatatypeHelper.safeTrimOrNullString((String)config.getInitParameter(LOGIN_CONTEXT_LIFETIME_INIT_PARAM_NAME));
        loginContextEntryLifetime = lifetime != null ? Long.parseLong(lifetime) : 1800000L;
        try {
            idGen = new SecureRandomIdentifierGenerator();
        }
        catch (NoSuchAlgorithmException e) {
            throw new ServletException("Error create random number generator", (Throwable)e);
        }
    }

    protected static LoginContext retrieveLoginContext(HttpServletRequest httpRequest, boolean removeFromStorageService) {
        Cookie[] requestCookies;
        LoginContext loginContext = (LoginContext)httpRequest.getAttribute("shib2.logincontext");
        if (loginContext != null) {
            LOG.trace("Login context retrieved from HTTP request attribute");
            return loginContext;
        }
        String contextId = DatatypeHelper.safeTrimOrNullString((String)((String)httpRequest.getAttribute(LOGIN_CONTEXT_KEY_NAME)));
        if (contextId == null && (requestCookies = httpRequest.getCookies()) != null) {
            for (Cookie requestCookie : requestCookies) {
                if (!DatatypeHelper.safeEquals((Object)requestCookie.getName(), (Object)LOGIN_CONTEXT_KEY_NAME)) continue;
                LOG.trace("Located cookie with login context key");
                contextId = requestCookie.getValue();
                break;
            }
        }
        LOG.trace("Using login context key {} to look up login context", (Object)contextId);
        LoginContextEntry entry = removeFromStorageService ? (LoginContextEntry)((Object)storageService.remove(loginContextPartitionName, (Object)contextId)) : (LoginContextEntry)((Object)storageService.get(loginContextPartitionName, (Object)contextId));
        if (entry == null) {
            LOG.trace("No entry for login context found in storage service.");
            return null;
        }
        if (entry.isExpired()) {
            LOG.trace("Login context entry found in storage service but it was expired.");
            return null;
        }
        LOG.trace("Login context entry found in storage service.");
        return entry.getLoginContext();
    }

    public static void returnToAuthenticationEngine(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        LOG.debug("Returning control to authentication engine");
        LoginContext loginContext = AuthenticationEngine.retrieveLoginContext(httpRequest, false);
        if (loginContext == null) {
            LOG.error("No login context available, unable to return to authentication engine");
            AuthenticationEngine.forwardRequest("/idp-error.jsp", httpRequest, httpResponse);
        } else {
            AuthenticationEngine.forwardRequest(loginContext.getAuthenticationEngineURL(), httpRequest, httpResponse);
        }
    }

    public static void returnToProfileHandler(LoginContext loginContext, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        LOG.debug("Returning control to profile handler at: {}", (Object)loginContext.getProfileHandlerURL());
        httpRequest.setAttribute("shib2.logincontext", (Object)loginContext);
        Cookie lcKeyCookie = new Cookie(LOGIN_CONTEXT_KEY_NAME, "");
        lcKeyCookie.setMaxAge(0);
        httpResponse.addCookie(lcKeyCookie);
        AuthenticationEngine.forwardRequest(loginContext.getProfileHandlerURL(), httpRequest, httpResponse);
    }

    protected static void forwardRequest(String forwardPath, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        try {
            RequestDispatcher dispatcher = httpRequest.getRequestDispatcher(forwardPath);
            dispatcher.forward((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            return;
        }
        catch (IOException e) {
            LOG.error("Unable to return control back to authentication engine", (Throwable)e);
        }
        catch (ServletException e) {
            LOG.error("Unable to return control back to authentication engine", (Throwable)e);
        }
    }

    protected void service(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException, IOException {
        LoginContext loginContext;
        LOG.debug("Processing incoming request");
        if (httpResponse.isCommitted()) {
            LOG.error("HTTP Response already committed");
        }
        if ((loginContext = AuthenticationEngine.retrieveLoginContext(httpRequest, true)) == null) {
            LOG.error("Incoming request does not have attached login context");
            throw new ServletException("Incoming request does not have attached login context");
        }
        if (!loginContext.getAuthenticationAttempted()) {
            this.startUserAuthentication(loginContext, httpRequest, httpResponse);
        } else {
            this.completeAuthentication(loginContext, httpRequest, httpResponse);
        }
    }

    protected void startUserAuthentication(LoginContext loginContext, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        LOG.debug("Beginning user authentication process.");
        try {
            LoginHandler loginHandler;
            edu.internet2.middleware.shibboleth.idp.session.Session idpSession = (edu.internet2.middleware.shibboleth.idp.session.Session)httpRequest.getAttribute("ShibbolethIdPSession");
            if (idpSession != null) {
                LOG.debug("Existing IdP session available for principal {}", (Object)idpSession.getPrincipalName());
            }
            Map<String, LoginHandler> possibleLoginHandlers = this.determinePossibleLoginHandlers(idpSession, loginContext);
            LOG.debug("Possible authentication handlers for this request: {}", possibleLoginHandlers);
            if (loginContext.isForceAuthRequired()) {
                this.filterByForceAuthentication(idpSession, loginContext, possibleLoginHandlers);
            }
            if (loginContext.isPassiveAuthRequired()) {
                this.filterByPassiveAuthentication(idpSession, loginContext, possibleLoginHandlers);
            }
            LOG.debug("Possible authentication handlers after filtering: {}", possibleLoginHandlers);
            if (idpSession != null && possibleLoginHandlers.containsKey("urn:oasis:names:tc:SAML:2.0:ac:classes:PreviousSession")) {
                loginContext.setAttemptedAuthnMethod("urn:oasis:names:tc:SAML:2.0:ac:classes:PreviousSession");
                loginHandler = possibleLoginHandlers.get("urn:oasis:names:tc:SAML:2.0:ac:classes:PreviousSession");
            } else {
                possibleLoginHandlers.remove("urn:oasis:names:tc:SAML:2.0:ac:classes:PreviousSession");
                Map.Entry<String, LoginHandler> chosenLoginHandler = possibleLoginHandlers.entrySet().iterator().next();
                loginContext.setAttemptedAuthnMethod(chosenLoginHandler.getKey());
                loginHandler = chosenLoginHandler.getValue();
            }
            LOG.debug("Authenticating user with login handler of type {}", (Object)loginHandler.getClass().getName());
            loginContext.setAuthenticationAttempted();
            loginContext.setAuthenticationEngineURL(HttpHelper.getRequestUriWithoutContext((HttpServletRequest)httpRequest));
            this.storeLoginContext(loginContext, httpRequest, httpResponse);
            loginHandler.login(httpRequest, httpResponse);
        }
        catch (AuthenticationException e) {
            loginContext.setAuthenticationFailure(e);
            AuthenticationEngine.returnToProfileHandler(loginContext, httpRequest, httpResponse);
        }
    }

    protected Map<String, LoginHandler> determinePossibleLoginHandlers(edu.internet2.middleware.shibboleth.idp.session.Session idpSession, LoginContext loginContext) throws AuthenticationException {
        HashMap<String, LoginHandler> supportedLoginHandlers = new HashMap<String, LoginHandler>(this.handlerManager.getLoginHandlers());
        LOG.debug("Filtering configured login handlers by requested athentication methods.");
        LOG.debug("Configured LoginHandlers: {}", supportedLoginHandlers);
        LOG.debug("Requested authentication methods: {}", loginContext.getRequestedAuthenticationMethods());
        if (loginContext.getRequestedAuthenticationMethods().isEmpty()) {
            LOG.trace("No preference given for authentication methods");
            return supportedLoginHandlers;
        }
        if (supportedLoginHandlers.containsKey("urn:oasis:names:tc:SAML:2.0:ac:classes:PreviousSession") && idpSession != null && loginContext.getRequestedAuthenticationMethods() != null) {
            boolean retainPreviousSession = false;
            Map<String, AuthenticationMethodInformation> currentAuthnMethods = idpSession.getAuthenticationMethods();
            for (String currentAuthnMethod : currentAuthnMethods.keySet()) {
                if (!loginContext.getRequestedAuthenticationMethods().contains(currentAuthnMethod)) continue;
                retainPreviousSession = true;
                break;
            }
            if (!retainPreviousSession) {
                supportedLoginHandlers.remove("urn:oasis:names:tc:SAML:2.0:ac:classes:PreviousSession");
            }
        }
        Iterator supportedLoginHandlerItr = supportedLoginHandlers.entrySet().iterator();
        while (supportedLoginHandlerItr.hasNext()) {
            Map.Entry supportedLoginHandler = supportedLoginHandlerItr.next();
            if (((String)supportedLoginHandler.getKey()).equals("urn:oasis:names:tc:SAML:2.0:ac:classes:PreviousSession") || loginContext.getRequestedAuthenticationMethods().contains(supportedLoginHandler.getKey())) continue;
            supportedLoginHandlerItr.remove();
        }
        if (supportedLoginHandlers.isEmpty()) {
            LOG.error("No authentication method, requested by the service provider, is supported");
            throw new AuthenticationException("No authentication method, requested by the service provider, is supported");
        }
        return supportedLoginHandlers;
    }

    protected void filterByForceAuthentication(edu.internet2.middleware.shibboleth.idp.session.Session idpSession, LoginContext loginContext, Map<String, LoginHandler> loginHandlers) throws ForceAuthenticationException {
        LOG.debug("Forced authentication is required, filtering possible login handlers accordingly");
        ArrayList<AuthenticationMethodInformation> activeMethods = new ArrayList<AuthenticationMethodInformation>();
        if (idpSession != null) {
            activeMethods.addAll(idpSession.getAuthenticationMethods().values());
        }
        loginHandlers.remove("urn:oasis:names:tc:SAML:2.0:ac:classes:PreviousSession");
        for (AuthenticationMethodInformation activeMethod : activeMethods) {
            LoginHandler loginHandler = loginHandlers.get(activeMethod.getAuthenticationMethod());
            if (loginHandler == null || loginHandler.supportsForceAuthentication()) continue;
            for (String handlerSupportedMethods : loginHandler.getSupportedAuthenticationMethods()) {
                loginHandlers.remove(handlerSupportedMethods);
            }
        }
        LOG.debug("Authentication handlers remaining after forced authentication requirement filtering: {}", loginHandlers);
        if (loginHandlers.isEmpty()) {
            LOG.info("Force authentication requested but no login handlers available to support it");
            throw new ForceAuthenticationException();
        }
    }

    protected void filterByPassiveAuthentication(edu.internet2.middleware.shibboleth.idp.session.Session idpSession, LoginContext loginContext, Map<String, LoginHandler> loginHandlers) throws PassiveAuthenticationException {
        LOG.debug("Passive authentication is required, filtering poassible login handlers accordingly.");
        if (idpSession == null) {
            loginHandlers.remove("urn:oasis:names:tc:SAML:2.0:ac:classes:PreviousSession");
        }
        Iterator<Map.Entry<String, LoginHandler>> authnMethodItr = loginHandlers.entrySet().iterator();
        while (authnMethodItr.hasNext()) {
            LoginHandler loginHandler = authnMethodItr.next().getValue();
            if (loginHandler.supportsPassive()) continue;
            authnMethodItr.remove();
        }
        LOG.debug("Authentication handlers remaining after passive authentication requirement filtering: {}", loginHandlers);
        if (loginHandlers.isEmpty()) {
            LOG.error("Passive authentication required but no login handlers available to support it");
            throw new PassiveAuthenticationException();
        }
    }

    protected void storeLoginContext(LoginContext loginContext, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        String contextId = idGen.generateIdentifier();
        storageService.put(loginContextPartitionName, (Object)contextId, (Object)new LoginContextEntry(loginContext, loginContextEntryLifetime));
        httpRequest.setAttribute(LOGIN_CONTEXT_KEY_NAME, (Object)contextId);
        Cookie cookie = new Cookie(LOGIN_CONTEXT_KEY_NAME, contextId);
        String contextPath = httpRequest.getContextPath();
        if (DatatypeHelper.isEmpty((String)contextPath)) {
            cookie.setPath("/");
        } else {
            cookie.setPath(contextPath);
        }
        cookie.setSecure(httpRequest.isSecure());
        cookie.setMaxAge(-1);
        httpResponse.addCookie(cookie);
    }

    protected void completeAuthentication(LoginContext loginContext, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        LOG.debug("Completing user authentication process");
        edu.internet2.middleware.shibboleth.idp.session.Session idpSession = (edu.internet2.middleware.shibboleth.idp.session.Session)httpRequest.getAttribute("ShibbolethIdPSession");
        try {
            String actualAuthnMethod = DatatypeHelper.safeTrimOrNullString((String)((String)httpRequest.getAttribute("authnMethod")));
            if (actualAuthnMethod == null) {
                actualAuthnMethod = loginContext.getAttemptedAuthnMethod();
            } else {
                LOG.debug("Authentication method overriden by LoginHandler.  It was {} and is now {}", (Object)loginContext.getAttemptedAuthnMethod(), (Object)actualAuthnMethod);
            }
            this.validateSuccessfulAuthentication(loginContext, httpRequest, actualAuthnMethod);
            Subject subject = this.getLoginHandlerSubject(httpRequest);
            if (loginContext.isForceAuthRequired()) {
                this.validateForcedReauthentication(idpSession, actualAuthnMethod, subject);
            }
            loginContext.setPrincipalAuthenticated(true);
            this.updateUserSession(loginContext, subject, actualAuthnMethod, httpRequest, httpResponse);
            LOG.debug("User {} authenticated with method {}", (Object)loginContext.getPrincipalName(), (Object)loginContext.getAuthenticationMethod());
        }
        catch (AuthenticationException e) {
            LOG.error("Authentication failed with the error:", (Throwable)e);
            loginContext.setPrincipalAuthenticated(false);
            loginContext.setAuthenticationFailure(e);
        }
        AuthenticationEngine.returnToProfileHandler(loginContext, httpRequest, httpResponse);
    }

    protected void validateSuccessfulAuthentication(LoginContext loginContext, HttpServletRequest httpRequest, String authenticationMethod) throws AuthenticationException {
        LOG.debug("Validating authentication was performed successfully");
        String errorMessage = DatatypeHelper.safeTrimOrNullString((String)((String)httpRequest.getAttribute("authnError")));
        if (errorMessage != null) {
            LOG.error("Error returned from login handler for authentication method {}:\n{}", (Object)loginContext.getAttemptedAuthnMethod(), (Object)errorMessage);
            throw new AuthenticationException(errorMessage);
        }
        Subject subject = (Subject)httpRequest.getAttribute("subject");
        Principal principal = (Principal)httpRequest.getAttribute("principal");
        String principalName = DatatypeHelper.safeTrimOrNullString((String)((String)httpRequest.getAttribute("principal_name")));
        if (subject == null && principal == null && principalName == null) {
            LOG.error("No user identified by login handler.");
            throw new AuthenticationException("No user identified by login handler.");
        }
    }

    protected Subject getLoginHandlerSubject(HttpServletRequest httpRequest) throws AuthenticationException {
        Subject subject = (Subject)httpRequest.getAttribute("subject");
        Principal principal = (Principal)httpRequest.getAttribute("principal");
        String principalName = DatatypeHelper.safeTrimOrNullString((String)((String)httpRequest.getAttribute("principal_name")));
        if (subject == null && (principal != null || principalName != null)) {
            subject = new Subject();
            if (principal == null) {
                principal = new UsernamePrincipal(principalName);
            }
            subject.getPrincipals().add(principal);
        }
        return subject;
    }

    protected void validateForcedReauthentication(edu.internet2.middleware.shibboleth.idp.session.Session idpSession, String authnMethod, Subject subject) throws AuthenticationException {
        AuthenticationMethodInformation authnMethodInfo;
        if (idpSession != null && (authnMethodInfo = idpSession.getAuthenticationMethods().get(authnMethod)) != null) {
            boolean princpalMatch = false;
            for (Principal princpal : subject.getPrincipals()) {
                if (!((Object)authnMethodInfo.getAuthenticationPrincipal()).equals(princpal)) continue;
                princpalMatch = true;
                break;
            }
            if (!princpalMatch) {
                throw new ForceAuthenticationException("Authenticated principal does not match previously authenticated principal");
            }
        }
    }

    protected void updateUserSession(LoginContext loginContext, Subject authenticationSubject, String authenticationMethod, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        Principal authenticationPrincipal = authenticationSubject.getPrincipals().iterator().next();
        LOG.debug("Updating session information for principal {}", (Object)authenticationPrincipal.getName());
        edu.internet2.middleware.shibboleth.idp.session.Session idpSession = (edu.internet2.middleware.shibboleth.idp.session.Session)httpRequest.getAttribute("ShibbolethIdPSession");
        if (idpSession == null) {
            LOG.debug("Creating shibboleth session for principal {}", (Object)authenticationPrincipal.getName());
            idpSession = (edu.internet2.middleware.shibboleth.idp.session.Session)this.sessionManager.createSession();
            loginContext.setSessionID(idpSession.getSessionID());
            this.addSessionCookie(httpRequest, httpResponse, idpSession);
        }
        idpSession.setSubject(this.mergeSubjects(idpSession.getSubject(), authenticationSubject));
        LOG.debug("Recording authentication and service information in Shibboleth session for principal: {}", (Object)authenticationPrincipal.getName());
        LoginHandler loginHandler = this.handlerManager.getLoginHandlers().get(loginContext.getAttemptedAuthnMethod());
        AuthenticationMethodInformationImpl authnMethodInfo = new AuthenticationMethodInformationImpl(idpSession.getSubject(), authenticationPrincipal, authenticationMethod, new DateTime(), loginHandler.getAuthenticationDuration());
        loginContext.setAuthenticationMethodInformation(authnMethodInfo);
        idpSession.getAuthenticationMethods().put(authnMethodInfo.getAuthenticationMethod(), authnMethodInfo);
        this.sessionManager.indexSession((Session)idpSession, authnMethodInfo.getAuthenticationPrincipal().getName());
        ServiceInformationImpl serviceInfo = new ServiceInformationImpl(loginContext.getRelyingPartyId(), new DateTime(), authnMethodInfo);
        idpSession.getServicesInformation().put(serviceInfo.getEntityID(), serviceInfo);
    }

    protected Subject mergeSubjects(Subject subject1, Subject subject2) {
        if (subject1 == null) {
            return subject2;
        }
        if (subject2 == null) {
            return subject1;
        }
        if (subject1 == null && subject2 == null) {
            return new Subject();
        }
        HashSet<Principal> principals = new HashSet<Principal>();
        principals.addAll(subject1.getPrincipals());
        principals.addAll(subject2.getPrincipals());
        HashSet<Object> publicCredentials = new HashSet<Object>();
        publicCredentials.addAll(subject1.getPublicCredentials());
        publicCredentials.addAll(subject2.getPublicCredentials());
        HashSet<Object> privateCredentials = new HashSet<Object>();
        privateCredentials.addAll(subject1.getPrivateCredentials());
        privateCredentials.addAll(subject2.getPrivateCredentials());
        return new Subject(false, principals, publicCredentials, privateCredentials);
    }

    protected void addSessionCookie(HttpServletRequest httpRequest, HttpServletResponse httpResponse, edu.internet2.middleware.shibboleth.idp.session.Session userSession) {
        httpRequest.setAttribute("ShibbolethIdPSession", (Object)userSession);
        byte[] remoteAddress = httpRequest.getRemoteAddr().getBytes();
        byte[] sessionId = userSession.getSessionID().getBytes();
        String signature = null;
        try {
            MessageDigest digester = MessageDigest.getInstance("SHA");
            digester.update(userSession.getSessionSecret());
            digester.update(remoteAddress);
            digester.update(sessionId);
            signature = Base64.encodeBytes((byte[])digester.digest());
        }
        catch (GeneralSecurityException e) {
            LOG.error("Unable to compute signature over session cookie material", (Throwable)e);
        }
        LOG.debug("Adding IdP session cookie to HTTP response");
        StringBuilder cookieValue = new StringBuilder();
        cookieValue.append(Base64.encodeBytes((byte[])remoteAddress, (int)8)).append("|");
        cookieValue.append(Base64.encodeBytes((byte[])sessionId, (int)8)).append("|");
        cookieValue.append(signature);
        Cookie sessionCookie = new Cookie(IDP_SESSION_COOKIE_NAME, HTTPTransportUtils.urlEncode((String)cookieValue.toString()));
        String contextPath = httpRequest.getContextPath();
        if (DatatypeHelper.isEmpty((String)contextPath)) {
            sessionCookie.setPath("/");
        } else {
            sessionCookie.setPath(contextPath);
        }
        sessionCookie.setSecure(httpRequest.isSecure());
        sessionCookie.setMaxAge(-1);
        httpResponse.addCookie(sessionCookie);
    }
}

