/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.util;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opensaml.util.storage.StorageService;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventingMapBasedStorageService<KeyType, ValueType>
implements StorageService<KeyType, ValueType>,
ApplicationContextAware {
    private ApplicationContext appCtx;
    private Map<String, Map<KeyType, ValueType>> store = new ConcurrentHashMap<String, Map<KeyType, ValueType>>();

    public boolean contains(String partition, Object key) {
        if (partition == null || key == null) {
            return false;
        }
        if (this.store.containsKey(partition)) {
            return this.store.get(partition).containsKey(key);
        }
        return false;
    }

    public ValueType get(String partition, Object key) {
        if (partition == null || key == null) {
            return null;
        }
        if (this.store.containsKey(partition)) {
            return this.store.get(partition).get(key);
        }
        return null;
    }

    public Iterator<KeyType> getKeys(String partition) {
        EventingMapBasedStorageService eventingMapBasedStorageService = this;
        eventingMapBasedStorageService.getClass();
        return eventingMapBasedStorageService.new PartitionEntryIterator(partition);
    }

    public Iterator<String> getPartitions() {
        return new PartitionIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueType put(String partition, KeyType key, ValueType value) {
        Map<KeyType, ValueType> partitionMap;
        if (partition == null || key == null) {
            return null;
        }
        Map<String, Map<KeyType, ValueType>> map = this.store;
        synchronized (map) {
            partitionMap = this.store.get(partition);
            if (partitionMap == null) {
                partitionMap = new ConcurrentHashMap<KeyType, ValueType>();
                this.store.put(partition, partitionMap);
            }
        }
        ValueType replacedEntry = partitionMap.put(key, value);
        EventingMapBasedStorageService eventingMapBasedStorageService = this;
        eventingMapBasedStorageService.getClass();
        this.appCtx.publishEvent((ApplicationEvent)eventingMapBasedStorageService.new AddEntryEvent(this, partition, key, value));
        return replacedEntry;
    }

    public ValueType remove(String partition, KeyType key) {
        if (partition == null || key == null) {
            return null;
        }
        if (this.store.containsKey(partition)) {
            ValueType removedEntry = this.store.get(partition).remove(key);
            EventingMapBasedStorageService eventingMapBasedStorageService = this;
            eventingMapBasedStorageService.getClass();
            this.appCtx.publishEvent((ApplicationEvent)eventingMapBasedStorageService.new RemoveEntryEvent(this, partition, key, removedEntry));
            return removedEntry;
        }
        return null;
    }

    public void setApplicationContext(ApplicationContext ctx) {
        ApplicationContext rootContext = ctx;
        while (rootContext.getParent() != null) {
            rootContext = rootContext.getParent();
        }
        this.appCtx = rootContext;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AddEntryEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = -1939512157260059492L;
        private StorageService<KeyType, ValueType> storageService;
        private String partition;
        private KeyType key;
        private ValueType value;

        public AddEntryEvent(StorageService<KeyType, ValueType> storageService, String partition, KeyType key, ValueType value) {
            super(storageService);
            this.storageService = storageService;
            this.partition = partition;
            this.key = key;
            this.value = value;
        }

        public StorageService<KeyType, ValueType> getStorageService() {
            return this.storageService;
        }

        public String getPartition() {
            return this.partition;
        }

        public KeyType getKey() {
            return this.key;
        }

        public ValueType getValue() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PartitionEntryIterator
    implements Iterator<KeyType> {
        private String partition;
        private Iterator<KeyType> keysItr;
        private KeyType currentKey;

        public PartitionEntryIterator(String partition) {
            this.partition = partition;
            this.keysItr = ((Map)EventingMapBasedStorageService.this.store.get(partition)).keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.keysItr.hasNext();
        }

        @Override
        public KeyType next() {
            this.currentKey = this.keysItr.next();
            return this.currentKey;
        }

        @Override
        public void remove() {
            EventingMapBasedStorageService.this.remove(this.partition, this.currentKey);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PartitionIterator
    implements Iterator<String> {
        private Iterator<String> partitionItr;
        private String currentParition;

        public PartitionIterator() {
            this.partitionItr = EventingMapBasedStorageService.this.store.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.partitionItr.hasNext();
        }

        @Override
        public String next() {
            this.currentParition = this.partitionItr.next();
            return this.currentParition;
        }

        @Override
        public void remove() {
            Iterator partitionEntries = EventingMapBasedStorageService.this.getKeys(this.currentParition);
            while (partitionEntries.hasNext()) {
                partitionEntries.next();
                partitionEntries.remove();
            }
            EventingMapBasedStorageService.this.store.remove(this.currentParition);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RemoveEntryEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = 7414605158323325366L;
        private StorageService<KeyType, ValueType> storageService;
        private String partition;
        private KeyType key;
        private ValueType value;

        public RemoveEntryEvent(StorageService<KeyType, ValueType> storageService, String partition, KeyType key, ValueType value) {
            super(storageService);
            this.storageService = storageService;
            this.partition = partition;
            this.key = key;
            this.value = value;
        }

        public StorageService<KeyType, ValueType> getStorageService() {
            return this.storageService;
        }

        public String getPartition() {
            return this.partition;
        }

        public KeyType getKey() {
            return this.key;
        }

        public ValueType getValue() {
            return this.value;
        }
    }
}

