/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config.resource;

import edu.internet2.middleware.shibboleth.common.config.resource.AbstractResourceBeanDefinitionParser;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import org.opensaml.util.resource.FilesystemResource;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class FilesystemResourceBeanDefinitionParser
extends AbstractResourceBeanDefinitionParser {
    public static final QName SCHEMA_TYPE = new QName("urn:mace:shibboleth:2.0:resource", "FilesystemResource");
    private final Logger log = LoggerFactory.getLogger(FilesystemResourceBeanDefinitionParser.class);

    protected Class getBeanClass(Element arg0) {
        return FilesystemResource.class;
    }

    protected String resolveId(Element configElement, AbstractBeanDefinition beanDefinition, ParserContext parserContext) {
        return String.valueOf(FilesystemResource.class.getName()) + ":" + DatatypeHelper.safeTrimOrNullString((String)configElement.getAttributeNS(null, "file"));
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        String file = DatatypeHelper.safeTrimOrNullString((String)element.getAttributeNS(null, "file"));
        if (file.startsWith("file:")) {
            try {
                builder.addConstructorArgValue((Object)new URI(file));
            }
            catch (URISyntaxException e) {
                this.log.error("Illegal file: URI syntax", (Throwable)e);
                throw new BeanCreationException("Illegal file: URI syntax");
            }
        } else {
            builder.addConstructorArgValue((Object)file);
        }
    }
}

