/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config.attribute.filtering;

import edu.internet2.middleware.shibboleth.common.config.SpringConfigurationUtils;
import edu.internet2.middleware.shibboleth.common.config.attribute.filtering.AttributeFilterPolicyFactoryBean;
import edu.internet2.middleware.shibboleth.common.config.attribute.filtering.BaseFilterBeanDefinitionParser;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class AttributeFilterPolicyBeanDefinitionParser
extends BaseFilterBeanDefinitionParser {
    public static final QName ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:afp", "AttributeFilterPolicy");
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:afp", "AttributeFilterPolicyType");
    private static Logger log = LoggerFactory.getLogger(AttributeFilterPolicyBeanDefinitionParser.class);

    protected Class getBeanClass(Element arg0) {
        return AttributeFilterPolicyFactoryBean.class;
    }

    protected String resolveId(Element configElement, AbstractBeanDefinition beanDefinition, ParserContext parserContext) {
        if (!configElement.hasAttributeNS(null, "id")) {
            log.warn("AttributeFilterPolicy elements should include an 'id' attribute.  This is not currently required but may be in future versions.");
        }
        return this.getQualifiedId(configElement, configElement.getLocalName(), configElement.getAttributeNS(null, "id"));
    }

    protected void doParse(Element config, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(config, parserContext, builder);
        String policyId = DatatypeHelper.safeTrimOrNullString((String)config.getAttributeNS(null, "id"));
        log.info("Parsing configuration for attribute filter policy {}", (Object)policyId);
        builder.addPropertyValue("policyId", (Object)policyId);
        Map childrenMap = XMLHelper.getChildElements((Element)config);
        List children = (List)childrenMap.get(new QName("urn:mace:shibboleth:2.0:afp", "PolicyRequirementRule"));
        if (children != null && children.size() > 0) {
            builder.addPropertyValue("policyRequirement", (Object)SpringConfigurationUtils.parseInnerCustomElement((Element)children.get(0), parserContext));
        } else {
            children = (List)childrenMap.get(new QName("urn:mace:shibboleth:2.0:afp", "PolicyRequirementRuleReference"));
            String reference = this.getAbsoluteReference(config, "PolicyRequirementRule", ((Element)children.get(0)).getTextContent());
            builder.addPropertyReference("policyRequirement", reference);
        }
        ManagedList attributeRules = new ManagedList();
        children = (List)childrenMap.get(new QName("urn:mace:shibboleth:2.0:afp", "AttributeRule"));
        if (children != null && children.size() > 0) {
            attributeRules.addAll((Collection)SpringConfigurationUtils.parseInnerCustomElements(children, parserContext));
        }
        if ((children = (List)childrenMap.get(new QName("urn:mace:shibboleth:2.0:afp", "AttributeRuleReference"))) != null && children.size() > 0) {
            for (Element child : children) {
                String reference = this.getAbsoluteReference(config, "AttributeRule", child.getTextContent());
                attributeRules.add((Object)new RuntimeBeanReference(reference));
            }
        }
        builder.addPropertyValue("attributeRules", (Object)attributeRules);
    }
}

