/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.attributeDefinition;

import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.provider.BasicAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.provider.ScopedAttributeValue;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.AttributeResolutionException;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.ShibbolethResolutionContext;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.attributeDefinition.BaseAttributeDefinition;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrescopedAttributeDefinition
extends BaseAttributeDefinition {
    private final Logger log = LoggerFactory.getLogger(PrescopedAttributeDefinition.class);
    private String scopeDelimiter;

    public PrescopedAttributeDefinition(String delimiter) {
        this.scopeDelimiter = delimiter;
    }

    @Override
    public BaseAttribute<ScopedAttributeValue> doResolve(ShibbolethResolutionContext resolutionContext) throws AttributeResolutionException {
        BasicAttribute<ScopedAttributeValue> attribute = new BasicAttribute<ScopedAttributeValue>();
        attribute.setId(this.getId());
        Collection<Object> values = this.getValuesFromAllDependencies(resolutionContext);
        if (values == null || values.isEmpty()) {
            return attribute;
        }
        for (Object value : values) {
            if (!(value instanceof String)) continue;
            String[] stringValues = ((String)value).split(this.scopeDelimiter);
            if (stringValues.length < 2) {
                this.log.error("Input attribute value {} does not contain delimited {} and can not be split", value, (Object)this.scopeDelimiter);
                throw new AttributeResolutionException("Input attribute value can not be split.");
            }
            attribute.getValues().add(new ScopedAttributeValue(stringValues[0], stringValues[1]));
        }
        return attribute;
    }

    public String getScopeDelimited() {
        return this.scopeDelimiter;
    }

    @Override
    public void validate() throws AttributeResolutionException {
    }
}

