/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.CallerData;
import ch.qos.logback.classic.spi.LoggerRemoteView;
import ch.qos.logback.classic.spi.ThrowableProxy;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import org.slf4j.MDC;
import org.slf4j.Marker;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.impl.LogbackMDCAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingEvent
implements Serializable {
    private static final long serialVersionUID = 3075964498087694229L;
    private static final int NULL_ARGUMENT_ARRAY = -1;
    private static final String NULL_ARGUMENT_ARRAY_ELEMENT = "NULL_ARGUMENT_ARRAY_ELEMENT";
    private static long startTime = System.currentTimeMillis();
    transient String fqnOfLoggerClass;
    private String threadName;
    private transient Level level;
    private String message;
    private String formattedMessage;
    private transient Object[] argumentArray;
    private ThrowableProxy throwableProxy;
    private CallerData[] callerDataArray;
    private LoggerRemoteView loggerRemoteView;
    private Marker marker;
    private Map<String, String> mdcPropertyMap;
    private long timeStamp;

    public LoggingEvent() {
    }

    public LoggingEvent(String fqcn, Logger logger, Level level, String message, Throwable throwable, Object[] argArray) {
        this.fqnOfLoggerClass = fqcn;
        this.loggerRemoteView = logger.getLoggerRemoteView();
        this.level = level;
        this.message = message;
        if (throwable != null) {
            this.throwableProxy = new ThrowableProxy(throwable);
        }
        this.argumentArray = argArray;
        this.formattedMessage = argArray != null ? MessageFormatter.arrayFormat((String)message, (Object[])argArray) : message;
        this.timeStamp = System.currentTimeMillis();
        LogbackMDCAdapter logbackMDCAdapter = (LogbackMDCAdapter)MDC.getMDCAdapter();
        this.mdcPropertyMap = logbackMDCAdapter.getPropertyMap();
    }

    public void setArgumentArray(Object[] argArray) {
        if (this.argumentArray != null) {
            throw new IllegalStateException("argArray has been already set");
        }
        this.argumentArray = argArray;
    }

    public Object[] getArgumentArray() {
        return this.argumentArray;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getThreadName() {
        if (this.threadName == null) {
            this.threadName = Thread.currentThread().getName();
        }
        return this.threadName;
    }

    public void setThreadName(String threadName) throws IllegalStateException {
        if (this.threadName != null) {
            throw new IllegalStateException("threadName has been already set");
        }
        this.threadName = threadName;
    }

    public ThrowableProxy getThrowableProxy() {
        return this.throwableProxy;
    }

    public void setThrowableProxy(ThrowableProxy tp) {
        if (this.throwableProxy != null) {
            throw new IllegalStateException("ThrowableProxy has been already set.");
        }
        this.throwableProxy = tp;
    }

    public void prepareForDeferredProcessing() {
        this.getThreadName();
    }

    public LoggerRemoteView getLoggerRemoteView() {
        return this.loggerRemoteView;
    }

    public void setLoggerRemoteView(LoggerRemoteView loggerRemoteView) {
        this.loggerRemoteView = loggerRemoteView;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        if (this.message != null) {
            throw new IllegalStateException("The message for this event has been set already.");
        }
        this.message = message;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public void setLevel(Level level) {
        if (this.level != null) {
            throw new IllegalStateException("The level has been already set for this event.");
        }
        this.level = level;
    }

    public static final long getStartTime() {
        return startTime;
    }

    public CallerData[] getCallerData() {
        if (this.callerDataArray == null && this.fqnOfLoggerClass != null) {
            this.callerDataArray = CallerData.extract(new Throwable(), this.fqnOfLoggerClass);
        }
        return this.callerDataArray;
    }

    public void setCallerInformation(CallerData[] callerDataArray) {
        this.callerDataArray = callerDataArray;
    }

    public Marker getMarker() {
        return this.marker;
    }

    public void setMarker(Marker marker) {
        if (this.marker != null) {
            throw new IllegalStateException("The marker has been already set for this event.");
        }
        this.marker = marker;
    }

    public String getFormattedMessage() {
        return this.formattedMessage;
    }

    public Map<String, String> getMDCPropertyMap() {
        return this.mdcPropertyMap;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.level.levelInt);
        if (this.argumentArray != null) {
            int len = this.argumentArray.length;
            out.writeInt(len);
            for (int i = 0; i < this.argumentArray.length; ++i) {
                if (this.argumentArray[i] != null) {
                    out.writeObject(this.argumentArray[i].toString());
                    continue;
                }
                out.writeObject(NULL_ARGUMENT_ARRAY_ELEMENT);
            }
        } else {
            out.writeInt(-1);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int levelInt = in.readInt();
        this.level = Level.toLevel(levelInt);
        int argArrayLen = in.readInt();
        if (argArrayLen != -1) {
            this.argumentArray = new String[argArrayLen];
            for (int i = 0; i < argArrayLen; ++i) {
                Object val = in.readObject();
                if (NULL_ARGUMENT_ARRAY_ELEMENT.equals(val)) continue;
                this.argumentArray[i] = val;
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(this.level).append("] ");
        sb.append(this.getFormattedMessage());
        return sb.toString();
    }
}

