/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.servlets;

import edu.vt.middleware.ldap.Ldap;
import edu.vt.middleware.ldap.LdapPool;
import java.io.IOException;
import java.util.Iterator;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class AttributeServlet
extends HttpServlet {
    private static final Log LOG = LogFactory.getLog((Class)(class$edu$vt$middleware$ldap$servlets$AttributeServlet == null ? (class$edu$vt$middleware$ldap$servlets$AttributeServlet = AttributeServlet.class$("edu.vt.middleware.ldap.servlets.AttributeServlet")) : class$edu$vt$middleware$ldap$servlets$AttributeServlet));
    private LdapPool pool;
    static /* synthetic */ Class class$edu$vt$middleware$ldap$servlets$AttributeServlet;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String propertiesFile = this.getInitParameter("edu.vt.middleware.ldap.servlets.propertiesFile");
        if (propertiesFile != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("edu.vt.middleware.ldap.servlets.propertiesFile = " + propertiesFile));
            }
            this.pool = new LdapPool(propertiesFile);
        } else {
            this.pool = new LdapPool();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String attribute = request.getParameter("attr");
        byte[] value = null;
        String content = request.getParameter("content-type");
        if (content != null && content.equalsIgnoreCase("octet")) {
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "attachment; filename=\"" + attribute + ".bin\"");
        } else {
            response.setContentType("text/plain");
        }
        try {
            Ldap ldap = null;
            try {
                ldap = (Ldap)this.pool.borrowObject();
                Iterator i = ldap.search(request.getParameter("query"), request.getParameterValues("attr"));
                if (i != null) {
                    while (i.hasNext()) {
                        SearchResult sr = (SearchResult)i.next();
                        if (sr == null) continue;
                        if (attribute != null) {
                            Attribute attr;
                            Attributes attrs = sr.getAttributes();
                            if (attrs == null || (attr = attrs.get(attribute)) == null) continue;
                            Object rawValue = attr.get();
                            try {
                                String stringValue = (String)rawValue;
                                value = stringValue.getBytes();
                            }
                            catch (ClassCastException e) {
                                value = (byte[])rawValue;
                            }
                            continue;
                        }
                        value = sr.getName().getBytes();
                    }
                }
            }
            finally {
                this.pool.returnObject(ldap);
            }
            if (value != null) {
                ServletOutputStream out = response.getOutputStream();
                out.write(value);
                out.flush();
                out.close();
            }
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Error performing search", (Throwable)e);
            }
            throw new ServletException(e.getMessage());
        }
    }

    public void destroy() {
        super.destroy();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

