/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.jaas;

import com.sun.security.auth.callback.TextCallbackHandler;
import edu.vt.middleware.ldap.Authenticator;
import edu.vt.middleware.ldap.Ldap;
import edu.vt.middleware.ldap.LdapProperties;
import edu.vt.middleware.ldap.LdapUtil;
import edu.vt.middleware.ldap.jaas.LdapCredential;
import edu.vt.middleware.ldap.jaas.LdapPrincipal;
import edu.vt.middleware.ldap.jaas.LdapRole;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class LdapLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean success;
    private Set principals;
    private Set credentials;
    private Authenticator auth;
    private Ldap ldap;
    private String[] userRoleAttribute;
    private String roleFilter;
    private String[] roleAttribute;
    static /* synthetic */ Class class$edu$vt$middleware$ldap$jaas$LdapPrincipal;
    static /* synthetic */ Class class$edu$vt$middleware$ldap$jaas$LdapRole;
    static /* synthetic */ Class class$edu$vt$middleware$ldap$jaas$LdapCredential;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        this.principals = new TreeSet();
        this.credentials = new HashSet();
        this.auth = new Authenticator();
        LdapProperties authProperties = new LdapProperties();
        this.ldap = new Ldap();
        LdapProperties ldapProperties = new LdapProperties();
        Iterator i = options.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = (String)options.get(key);
            if (key.equalsIgnoreCase("userRoleAttribute")) {
                this.userRoleAttribute = value.split(",");
                continue;
            }
            if (key.startsWith("role")) {
                if (key.equalsIgnoreCase("roleAttribute")) {
                    this.roleAttribute = value.split(",");
                    continue;
                }
                if (key.equalsIgnoreCase("roleFilter")) {
                    this.roleFilter = value;
                    continue;
                }
                String propName = key.substring("role".length(), key.length());
                StringBuffer newKey = new StringBuffer().append(Character.toLowerCase(propName.charAt(0))).append(propName.substring(1));
                ldapProperties.setProperty(newKey.toString(), value);
                continue;
            }
            authProperties.setProperty(key, value);
            if (ldapProperties.isPropertySet(key)) continue;
            ldapProperties.setProperty(key, value);
        }
        authProperties.initialize(this.auth);
        ldapProperties.initialize(this.ldap);
    }

    public boolean login() throws LoginException {
        try {
            NameCallback nameCb = new NameCallback("Enter user: ");
            PasswordCallback passCb = new PasswordCallback("Enter user password: ", false);
            if (this.callbackHandler != null) {
                this.callbackHandler.handle(new Callback[]{nameCb, passCb});
            }
            ArrayList roles = new ArrayList();
            if (this.userRoleAttribute != null) {
                try {
                    Attributes attrs = this.auth.authenticate(nameCb.getName(), passCb.getPassword(), this.userRoleAttribute);
                    roles.addAll(this.attributesToRoles(attrs));
                    this.success = true;
                }
                catch (AuthenticationException e) {
                    this.success = false;
                }
            } else {
                this.success = this.auth.authenticate(nameCb.getName(), passCb.getPassword());
            }
            if (!this.success) {
                throw new LoginException("Authentication failed.");
            }
            if (this.roleAttribute != null && this.roleFilter != null) {
                try {
                    Object[] filterArgs = new Object[]{this.auth.getDn(nameCb.getName()), nameCb.getName()};
                    Iterator results = this.ldap.search(this.roleFilter, filterArgs, this.roleAttribute);
                    while (results.hasNext()) {
                        SearchResult sr = (SearchResult)results.next();
                        roles.addAll(this.attributesToRoles(sr.getAttributes()));
                    }
                }
                catch (NamingException e) {
                    this.success = false;
                    throw new LoginException(e.getMessage());
                }
            }
            this.principals.add(new LdapPrincipal(nameCb.getName()));
            if (!roles.isEmpty()) {
                Iterator i = roles.iterator();
                while (i.hasNext()) {
                    this.principals.add((LdapRole)i.next());
                }
            }
            this.credentials.add(new LdapCredential(passCb.getPassword()));
        }
        catch (IOException e) {
            throw new LoginException(e.toString());
        }
        catch (UnsupportedCallbackException e) {
            throw new LoginException(e.toString());
        }
        catch (NamingException e) {
            throw new LoginException(e.toString());
        }
        return true;
    }

    public boolean commit() throws LoginException {
        if (this.success) {
            if (this.subject.isReadOnly()) {
                throw new LoginException("Subject is read-only.");
            }
            this.subject.getPrincipals().addAll(this.principals);
            this.subject.getPrivateCredentials().addAll(this.credentials);
        }
        this.principals.clear();
        this.credentials.clear();
        return true;
    }

    public boolean abort() {
        this.success = false;
        this.logout();
        return true;
    }

    public boolean logout() {
        this.principals.clear();
        this.credentials.clear();
        Iterator i = this.subject.getPrincipals(class$edu$vt$middleware$ldap$jaas$LdapPrincipal == null ? (class$edu$vt$middleware$ldap$jaas$LdapPrincipal = LdapLoginModule.class$("edu.vt.middleware.ldap.jaas.LdapPrincipal")) : class$edu$vt$middleware$ldap$jaas$LdapPrincipal).iterator();
        while (i.hasNext()) {
            LdapPrincipal p = (LdapPrincipal)i.next();
            this.subject.getPrincipals().remove(p);
        }
        i = this.subject.getPrincipals(class$edu$vt$middleware$ldap$jaas$LdapRole == null ? (class$edu$vt$middleware$ldap$jaas$LdapRole = LdapLoginModule.class$("edu.vt.middleware.ldap.jaas.LdapRole")) : class$edu$vt$middleware$ldap$jaas$LdapRole).iterator();
        while (i.hasNext()) {
            LdapRole r = (LdapRole)i.next();
            this.subject.getPrincipals().remove(r);
        }
        i = this.subject.getPrivateCredentials(class$edu$vt$middleware$ldap$jaas$LdapCredential == null ? (class$edu$vt$middleware$ldap$jaas$LdapCredential = LdapLoginModule.class$("edu.vt.middleware.ldap.jaas.LdapCredential")) : class$edu$vt$middleware$ldap$jaas$LdapCredential).iterator();
        while (i.hasNext()) {
            LdapCredential c = (LdapCredential)i.next();
            this.subject.getPrivateCredentials().remove(c);
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        LoginContext lc = new LoginContext("vt-ldap", new TextCallbackHandler());
        lc.login();
        System.out.println("Authentication/Authorization succeeded");
        Set<Principal> principals = lc.getSubject().getPrincipals();
        System.out.println("Subject Principal(s): ");
        Iterator<Principal> i = principals.iterator();
        while (i.hasNext()) {
            Principal p = i.next();
            System.out.println("  " + p.getName());
        }
        lc.logout();
    }

    private List attributesToRoles(Attributes attributes) throws NamingException {
        ArrayList<LdapRole> roles = new ArrayList<LdapRole>();
        Map m = LdapUtil.parseAttributes(attributes, true);
        if (!m.isEmpty()) {
            Iterator mapIter = m.values().iterator();
            while (mapIter.hasNext()) {
                List l = (List)mapIter.next();
                Iterator listIter = l.iterator();
                while (listIter.hasNext()) {
                    roles.add(new LdapRole((String)listIter.next()));
                }
            }
        }
        return roles;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

