/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap;

import edu.vt.middleware.ldap.Authenticator;
import edu.vt.middleware.ldap.Ldap;
import edu.vt.middleware.ldap.LdapConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class LdapProperties {
    public static final String PROPERTIES_FILE = "/ldap.properties";
    private static final Log LOG = LogFactory.getLog((Class)(class$edu$vt$middleware$ldap$LdapProperties == null ? (class$edu$vt$middleware$ldap$LdapProperties = LdapProperties.class$("edu.vt.middleware.ldap.LdapProperties")) : class$edu$vt$middleware$ldap$LdapProperties));
    private static final ArrayList AUTH_PROPERTIES = new ArrayList<String>(Arrays.asList("edu.vt.middleware.ldap.auth.userField", "edu.vt.middleware.ldap.auth.constructDn", "edu.vt.middleware.ldap.auth.subtreeSearch", "edu.vt.middleware.ldap.auth.authorizationFilter"));
    private Properties config;
    private String propertiesFile;
    static /* synthetic */ Class class$edu$vt$middleware$ldap$LdapProperties;
    static /* synthetic */ Class class$java$lang$String;

    public LdapProperties() {
        this.config = new Properties();
    }

    public LdapProperties(String propertiesFile) {
        this.usePropertiesFile(propertiesFile);
    }

    public void useDefaultPropertiesFile() {
        this.usePropertiesFile(PROPERTIES_FILE);
    }

    public void usePropertiesFile(String propertiesFile) {
        this.propertiesFile = propertiesFile;
        this.config = this.loadProperties(this.propertiesFile);
    }

    private Properties loadProperties(String propertiesFile) {
        InputStream is;
        block18: {
            is = (class$edu$vt$middleware$ldap$LdapProperties == null ? (class$edu$vt$middleware$ldap$LdapProperties = LdapProperties.class$("edu.vt.middleware.ldap.LdapProperties")) : class$edu$vt$middleware$ldap$LdapProperties).getResourceAsStream(propertiesFile);
            if (is == null) {
                File file;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Did not find properties from resource");
                }
                try {
                    file = new File(URI.create(propertiesFile));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Supplied properties is a URI");
                    }
                }
                catch (IllegalArgumentException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Supplied properties is not a URI");
                    }
                    file = new File(propertiesFile);
                }
                try {
                    is = new FileInputStream(file);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Found properties from file system");
                    }
                    break block18;
                }
                catch (IOException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Did not find properties from file system");
                    }
                    break block18;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Found properties from classpath");
            }
        }
        Properties properties = new Properties();
        if (is != null) {
            try {
                properties.load(is);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Loaded ldap properties from input stream");
                }
                is.close();
            }
            catch (IOException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Error using input stream", (Throwable)e);
                }
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Input stream was null, no properties loaded");
        }
        return properties;
    }

    public String getPropertiesFile() {
        return this.propertiesFile;
    }

    public Properties getProperties() {
        return this.config;
    }

    public void setProperty(String key, String value) {
        if (AUTH_PROPERTIES.contains("edu.vt.middleware.ldap.auth." + key)) {
            this.config.setProperty("edu.vt.middleware.ldap.auth." + key, value);
        } else {
            this.config.setProperty("edu.vt.middleware.ldap." + key, value);
        }
    }

    public boolean isPropertySet(String key) {
        boolean exists = false;
        exists = AUTH_PROPERTIES.contains("edu.vt.middleware.ldap.auth." + key) ? this.config.containsKey("edu.vt.middleware.ldap.auth." + key) : this.config.containsKey("edu.vt.middleware.ldap." + key);
        return exists;
    }

    public void initialize(Ldap ldap) {
        this.setLdapConfig(ldap, "edu.vt.middleware.ldap.");
    }

    public void initialize(Authenticator auth) {
        this.setLdapConfig(auth, "edu.vt.middleware.ldap.");
        this.setLdapConfig(auth, "edu.vt.middleware.ldap.auth.");
        if (this.config != null) {
            Iterator<Object> i = this.config.keySet().iterator();
            while (i.hasNext()) {
                String prop = (String)i.next();
                if (!AUTH_PROPERTIES.contains(prop) || prop.indexOf("edu.vt.middleware.ldap.auth.") == -1 || prop.indexOf(".", "edu.vt.middleware.ldap.auth.".length()) != -1) continue;
                Object[] values = new String[]{this.config.getProperty(prop)};
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(prop + " = " + this.config.getProperty(prop)));
                }
                if (values == null) continue;
                this.invokeMethod(this.getSetterMethodName(prop), auth, values);
            }
        }
    }

    private void setLdapConfig(Ldap ldap, String propertiesDomain) {
        if (this.config != null) {
            LdapConfig ldapConfig = ldap.getLdapConfig();
            if (ldapConfig == null) {
                ldapConfig = new LdapConfig();
            }
            Iterator<Object> i = this.config.keySet().iterator();
            while (i.hasNext()) {
                String prop = (String)i.next();
                if (AUTH_PROPERTIES.contains(prop) || prop.indexOf(propertiesDomain) == -1 || prop.indexOf(".", propertiesDomain.length()) != -1) continue;
                Object[] values = new String[]{this.config.getProperty(prop)};
                if (LOG.isTraceEnabled()) {
                    if (prop.endsWith("Credential")) {
                        LOG.trace((Object)(prop + " = <suppressed>"));
                    } else {
                        LOG.trace((Object)(prop + " = " + this.config.getProperty(prop)));
                    }
                }
                if (values == null) continue;
                this.invokeMethod(this.getSetterMethodName(prop), ldapConfig, values);
            }
            ldap.setLdapConfig(ldapConfig);
        }
    }

    private String getSetterMethodName(String property) {
        String name = property.substring(property.lastIndexOf(".") + 1, property.length());
        StringBuffer method = new StringBuffer("set").append(Character.toUpperCase(name.charAt(0))).append(name.substring(1));
        return method.toString();
    }

    private void invokeMethod(String methodName, Object object, Object[] args) {
        block8: {
            try {
                Class[] paramTypes = new Class[args.length];
                for (int i = 0; i < paramTypes.length; ++i) {
                    paramTypes[i] = class$java$lang$String == null ? LdapProperties.class$("java.lang.String") : class$java$lang$String;
                }
                Method method = object.getClass().getMethod(methodName, paramTypes);
                method.invoke(object, args);
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Called " + methodName + " for " + object.getClass().getName()));
                }
            }
            catch (NoSuchMethodException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)("Could not invoke method " + methodName), (Throwable)e);
                }
            }
            catch (InvocationTargetException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)("Could not invoke method " + methodName), (Throwable)e);
                }
            }
            catch (IllegalAccessException e) {
                if (!LOG.isErrorEnabled()) break block8;
                LOG.error((Object)("Could not access method " + methodName), (Throwable)e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

