/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap;

import edu.vt.middleware.ldap.LdapConstants;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.directory.SearchControls;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;

public class LdapConfig {
    private String contextFactory = "com.sun.jndi.ldap.LdapCtxFactory";
    private SSLSocketFactory sslSocketFactory;
    private HostnameVerifier hostnameVerifier;
    private String host;
    private String port = "389";
    private String serviceUser;
    private Object serviceCredential;
    private String base;
    private Integer searchScope = new Integer(2);
    private String authtype = "simple";
    private boolean authoritative = false;
    private boolean pooled = false;
    private boolean ignoreCase = true;
    private Integer batchSize;
    private Integer timeLimit;
    private Long countLimit;
    private boolean derefLinkFlag;
    private boolean returningObjFlag;
    private String dnsUrl;
    private String language;
    private String referral;
    private String derefAliases;
    private String binaryAttributes;
    private String saslAuthorizationId;
    private String saslRealm;
    private boolean typesOnly = false;
    private Hashtable environmentProperties = new Hashtable();
    private boolean removeUrls = true;
    private boolean logCredentials = false;
    private boolean ssl = false;
    private boolean tls = false;
    private PrintStream traceStream;

    public LdapConfig() {
    }

    public LdapConfig(String host, String base) {
        this();
        this.setHost(host);
        this.setBase(base);
    }

    public Hashtable getEnvironment() {
        Enumeration en;
        Hashtable<String, Object> environment = new Hashtable<String, Object>();
        environment.put("java.naming.factory.initial", this.contextFactory);
        if (this.authoritative) {
            environment.put("java.naming.authoritative", Boolean.valueOf(this.authoritative).toString());
        }
        if (this.pooled) {
            environment.put("com.sun.jndi.ldap.connect.pool", Boolean.valueOf(this.pooled).toString());
        }
        if (this.batchSize != null) {
            environment.put("java.naming.batchsize", this.batchSize.toString());
        }
        if (this.dnsUrl != null) {
            environment.put("java.naming.dns.url", this.dnsUrl);
        }
        if (this.language != null) {
            environment.put("java.naming.language", this.language);
        }
        if (this.referral != null) {
            environment.put("java.naming.referral", this.referral);
        }
        if (this.derefAliases != null) {
            environment.put("java.naming.ldap.derefAliases", this.derefAliases);
        }
        if (this.binaryAttributes != null) {
            environment.put("java.naming.ldap.attributes.binary", this.binaryAttributes);
        }
        if (this.saslAuthorizationId != null) {
            environment.put("java.naming.security.sasl.authorizationId", this.saslAuthorizationId);
        }
        if (this.saslRealm != null) {
            environment.put("java.naming.security.sasl.realm", this.saslRealm);
        }
        if (this.typesOnly) {
            environment.put("java.naming.ldap.typesOnly", Boolean.valueOf(this.typesOnly).toString());
        }
        if (this.ssl) {
            environment.put("java.naming.security.protocol", "ssl");
            if (this.sslSocketFactory != null) {
                environment.put("java.naming.ldap.factory.socket", this.sslSocketFactory.getClass().getName());
            }
        }
        if (this.traceStream != null) {
            environment.put("com.sun.jndi.ldap.trace.ber", this.traceStream);
        }
        if (this.host != null) {
            environment.put("java.naming.provider.url", "ldap://" + this.host + ":" + this.port);
        }
        if (!this.environmentProperties.isEmpty() && (en = this.environmentProperties.keys()) != null) {
            while (en.hasMoreElements()) {
                String name = (String)en.nextElement();
                String value = (String)this.environmentProperties.get(name);
                environment.put(name, value);
            }
        }
        return environment;
    }

    public String getContextFactory() {
        return this.contextFactory;
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public boolean useSslSocketFactory() {
        return this.sslSocketFactory != null;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public boolean useHostnameVerifier() {
        return this.hostnameVerifier != null;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String getServiceUser() {
        return this.serviceUser;
    }

    public Object getServiceCredential() {
        return this.serviceCredential;
    }

    public String getBase() {
        return this.base;
    }

    public int getSearchScope() {
        return this.searchScope;
    }

    public boolean isObjectSearchScope() {
        return this.searchScope == 0;
    }

    public boolean isOneLevelSearchScope() {
        return this.searchScope == 1;
    }

    public boolean isSubTreeSearchScope() {
        return this.searchScope == 2;
    }

    public String getAuthtype() {
        return this.authtype;
    }

    public boolean isAnonymousAuth() {
        return this.authtype.equalsIgnoreCase("none");
    }

    public boolean isSimpleAuth() {
        return this.authtype.equalsIgnoreCase("simple");
    }

    public boolean isStrongAuth() {
        return this.authtype.equalsIgnoreCase("strong");
    }

    public boolean isSaslAuth() {
        boolean authtypeSasl = false;
        for (int i = 0; i < LdapConstants.SASL_MECHANISMS.length; ++i) {
            if (!this.authtype.equalsIgnoreCase(LdapConstants.SASL_MECHANISMS[i])) continue;
            authtypeSasl = true;
            break;
        }
        return authtypeSasl;
    }

    public boolean isExternalAuth() {
        return this.authtype.equalsIgnoreCase("EXTERNAL");
    }

    public boolean isDigestMD5Auth() {
        return this.authtype.equalsIgnoreCase("DIGEST-MD5");
    }

    public boolean isCramMD5Auth() {
        return this.authtype.equalsIgnoreCase("CRAM-MD5");
    }

    public boolean isGSSAPIAuth() {
        return this.authtype.equalsIgnoreCase("GSSAPI");
    }

    public boolean getAuthoritative() {
        return this.isAuthoritative();
    }

    public boolean isAuthoritative() {
        return this.authoritative;
    }

    public boolean getPooled() {
        return this.isPooled();
    }

    public boolean isPooled() {
        return this.pooled;
    }

    public boolean getIgnoreCase() {
        return this.isIgnoreCase();
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public int getTimeLimit() {
        int limit = 0;
        if (this.timeLimit != null) {
            limit = this.timeLimit;
        }
        return limit;
    }

    public long getCountLimit() {
        long limit = 0L;
        if (this.countLimit != null) {
            limit = this.countLimit;
        }
        return limit;
    }

    public boolean getDerefLinkFlag() {
        return this.derefLinkFlag;
    }

    public boolean getReturningObjFlag() {
        return this.returningObjFlag;
    }

    public int getBatchSize() {
        int size = -1;
        if (this.batchSize != null) {
            size = this.batchSize;
        }
        return size;
    }

    public String getDnsUrl() {
        return this.dnsUrl;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getReferral() {
        return this.referral;
    }

    public String getDerefAliases() {
        return this.derefAliases;
    }

    public String getBinaryAttributes() {
        return this.binaryAttributes;
    }

    public String getSaslAuthorizationId() {
        return this.saslAuthorizationId;
    }

    public String getSaslRealm() {
        return this.saslRealm;
    }

    public boolean getTypesOnly() {
        return this.isTypesOnly();
    }

    public boolean isTypesOnly() {
        return this.typesOnly;
    }

    public Hashtable getEnvironmentProperties() {
        return this.environmentProperties;
    }

    public boolean getRemoveUrls() {
        return this.removeUrls;
    }

    public boolean getLogCredentials() {
        return this.logCredentials;
    }

    public boolean getSsl() {
        return this.isSslEnabled();
    }

    public boolean isSslEnabled() {
        return this.ssl;
    }

    public boolean getTls() {
        return this.isTlsEnabled();
    }

    public boolean isTlsEnabled() {
        return this.tls;
    }

    public void setContextFactory(String contextFactory) {
        if (contextFactory != null) {
            this.contextFactory = contextFactory;
        }
    }

    public void setSslSocketFactory(String sslSocketFactory) {
        try {
            this.sslSocketFactory = (SSLSocketFactory)Class.forName(sslSocketFactory).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    public void setHostnameVerifier(String hostnameVerifier) {
        try {
            this.hostnameVerifier = (HostnameVerifier)Class.forName(hostnameVerifier).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public void setHost(String host) {
        if (host != null) {
            int prefixLength = "://".length();
            int separatorLength = ":".length();
            String h = host;
            if (h.indexOf("://") != -1 && h.indexOf("://") + prefixLength < h.length()) {
                String scheme = h.substring(0, h.indexOf("://"));
                if (scheme.equalsIgnoreCase("ldaps")) {
                    this.useSsl(true);
                    this.setPort("636");
                }
                h = h.substring(h.indexOf("://") + prefixLength, h.length());
            }
            if (h.indexOf(":") != -1 && h.indexOf(":") + separatorLength < h.length()) {
                String p = h.substring(h.indexOf(":") + separatorLength, h.length());
                this.setPort(p);
                h = h.substring(0, h.indexOf(":"));
            }
            this.host = h;
        }
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setServiceUser(String user) {
        this.serviceUser = user;
    }

    public void setServiceCredential(String credential) {
        this.serviceCredential = credential;
    }

    public void setServiceCredential(Object credential) {
        this.serviceCredential = credential;
    }

    public void setService(String user, Object credential) {
        this.setServiceUser(user);
        this.setServiceCredential(credential);
    }

    public void setBase(String base) {
        this.base = base;
    }

    public void setSearchScope(String searchScope) {
        if (searchScope != null) {
            this.setSearchScope(Integer.parseInt(searchScope));
        }
    }

    public void setSearchScope(int searchScope) {
        this.searchScope = new Integer(searchScope);
    }

    public void useObjectSearchScope() {
        this.setSearchScope(0);
    }

    public void useOneLevelSearchScope() {
        this.setSearchScope(1);
    }

    public void useSubTreeSearchScope() {
        this.setSearchScope(2);
    }

    public void setAuthtype(String authtype) {
        if (authtype != null) {
            this.authtype = authtype;
        }
    }

    public void useAnonymousAuth() {
        this.setAuthtype("none");
    }

    public void useSimpleAuth() {
        this.setAuthtype("simple");
    }

    public void useStrongAuth() {
        this.setAuthtype("strong");
    }

    public void useExternalAuth() {
        this.setAuthtype("EXTERNAL");
    }

    public void useDigestMD5Auth() {
        this.setAuthtype("DIGEST-MD5");
    }

    public void useCramMD5Auth() {
        this.setAuthtype("CRAM-MD5");
    }

    public void useGSSAPIAuth() {
        this.setAuthtype("GSSAPI");
    }

    public void setAuthoritative(String authoritative) {
        if (authoritative != null) {
            this.setAuthoritative(Boolean.valueOf(authoritative));
        }
    }

    public void setAuthoritative(boolean authoritative) {
        this.authoritative = authoritative;
    }

    public void setPooled(String pooled) {
        if (pooled != null) {
            this.setPooled(Boolean.valueOf(pooled));
        }
    }

    public void setPooled(boolean pooled) {
        this.pooled = pooled;
    }

    public void setIgnoreCase(String ignoreCase) {
        if (ignoreCase != null) {
            this.setIgnoreCase(Boolean.valueOf(ignoreCase));
        }
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public void setTimeLimit(String timeLimit) {
        if (timeLimit != null) {
            this.setTimeLimit(Integer.parseInt(timeLimit));
        }
    }

    public void setTimeLimit(int timeLimit) {
        this.timeLimit = new Integer(timeLimit);
    }

    public void setCountLimit(String countLimit) {
        if (countLimit != null) {
            this.setCountLimit(Long.parseLong(countLimit));
        }
    }

    public void setCountLimit(long countLimit) {
        this.countLimit = new Long(countLimit);
    }

    public void setDerefLinkFlag(String derefLinkFlag) {
        if (derefLinkFlag != null) {
            this.setDerefLinkFlag(Boolean.valueOf(derefLinkFlag));
        }
    }

    public void setDerefLinkFlag(boolean derefLinkFlag) {
        this.derefLinkFlag = derefLinkFlag;
    }

    public void setReturningObjFlag(String returningObjFlag) {
        if (returningObjFlag != null) {
            this.setReturningObjFlag(Boolean.valueOf(returningObjFlag));
        }
    }

    public void setReturningObjFlag(boolean returningObjFlag) {
        this.returningObjFlag = returningObjFlag;
    }

    public void setBatchSize(String batchSize) {
        if (batchSize != null) {
            this.setBatchSize(Integer.parseInt(batchSize));
        }
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize == -1 ? null : new Integer(batchSize);
    }

    public void setDnsUrl(String dnsUrl) {
        this.dnsUrl = dnsUrl;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setReferral(String referral) {
        this.referral = referral;
    }

    public void setDerefAliases(String derefAliases) {
        this.derefAliases = derefAliases;
    }

    public void setBinaryAttributes(String binaryAttributes) {
        this.binaryAttributes = binaryAttributes;
    }

    public void setSaslAuthorizationId(String saslAuthorizationId) {
        this.saslAuthorizationId = saslAuthorizationId;
    }

    public void setSaslRealm(String saslRealm) {
        this.saslRealm = saslRealm;
    }

    public void setTypesOnly(String typesOnly) {
        if (typesOnly != null) {
            this.setTypesOnly(Boolean.valueOf(typesOnly));
        }
    }

    public void setTypesOnly(boolean typesOnly) {
        this.typesOnly = typesOnly;
    }

    public void setEnvironmentProperties(Hashtable properties) {
        Enumeration en;
        if (properties != null && (en = properties.keys()) != null) {
            while (en.hasMoreElements()) {
                String name = (String)en.nextElement();
                String value = (String)properties.get(name);
                this.setEnvironmentProperties(name, value);
            }
        }
    }

    public void setEnvironmentProperties(String name, String value) {
        if (name != null && value != null) {
            if (name.equalsIgnoreCase("java.naming.factory.initial")) {
                this.setContextFactory(value);
            } else if (name.equalsIgnoreCase("java.naming.authoritative")) {
                this.setAuthoritative(value);
            } else if (name.equalsIgnoreCase("com.sun.jndi.ldap.connect.pool")) {
                this.setPooled(value);
            } else if (name.equalsIgnoreCase("java.naming.batchsize")) {
                this.setBatchSize(value);
            } else if (name.equalsIgnoreCase("java.naming.dns.url")) {
                this.setDnsUrl(value);
            } else if (name.equalsIgnoreCase("java.naming.language")) {
                this.setLanguage(value);
            } else if (name.equalsIgnoreCase("java.naming.referral")) {
                this.setReferral(value);
            } else if (name.equalsIgnoreCase("java.naming.ldap.derefAliases")) {
                this.setDerefAliases(value);
            } else if (name.equalsIgnoreCase("java.naming.ldap.attributes.binary")) {
                this.setBinaryAttributes(value);
            } else if (name.equalsIgnoreCase("java.naming.security.sasl.authorizationId")) {
                this.setSaslAuthorizationId(value);
            } else if (name.equalsIgnoreCase("java.naming.security.sasl.realm")) {
                this.setSaslRealm(value);
            } else if (name.equalsIgnoreCase("java.naming.ldap.typesOnly")) {
                this.setTypesOnly(value);
            } else if (name.equalsIgnoreCase("java.naming.security.protocol") && value.equalsIgnoreCase("ssl")) {
                this.useSsl(true);
            } else if (name.equalsIgnoreCase("java.naming.ldap.factory.socket")) {
                this.setSslSocketFactory(value);
            } else if (name.equalsIgnoreCase("java.naming.provider.url")) {
                this.setHost(value);
            } else if (name.equalsIgnoreCase("java.naming.security.authentication")) {
                this.setAuthtype(value);
            } else if (name.equalsIgnoreCase("java.naming.security.principal")) {
                this.setServiceUser(value);
            } else if (name.equalsIgnoreCase("java.naming.security.credentials")) {
                this.setServiceCredential(value);
            } else {
                this.environmentProperties.put(name, value);
            }
        }
    }

    public void setRemoveUrls(String remove) {
        if (remove != null) {
            this.removeUrls(Boolean.valueOf(remove));
        }
    }

    public void removeUrls(boolean remove) {
        this.removeUrls = remove;
    }

    public void setLogCredentials(String log) {
        if (log != null) {
            this.logCredentials(Boolean.valueOf(log));
        }
    }

    public void logCredentials(boolean log) {
        this.logCredentials = log;
    }

    public void setSsl(String ssl) {
        if (ssl != null) {
            this.useSsl(Boolean.valueOf(ssl));
        }
    }

    public void useSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public void setTls(String tls) {
        if (tls != null) {
            this.useTls(Boolean.valueOf(tls));
        }
    }

    public void useTls(boolean tls) {
        this.tls = tls;
    }

    public SearchControls getSearchControls(String[] retAttrs) {
        SearchControls ctls = new SearchControls();
        ctls.setReturningAttributes(retAttrs);
        ctls.setSearchScope(this.getSearchScope());
        ctls.setTimeLimit(this.getTimeLimit());
        ctls.setCountLimit(this.getCountLimit());
        ctls.setDerefLinkFlag(this.getDerefLinkFlag());
        ctls.setReturningObjFlag(this.getReturningObjFlag());
        return ctls;
    }

    public static SearchControls getCompareSearchControls() {
        SearchControls ctls = new SearchControls();
        ctls.setReturningAttributes(new String[0]);
        ctls.setSearchScope(0);
        return ctls;
    }

    public void tracePackets(PrintStream stream) {
        if (stream != null) {
            this.traceStream = stream;
        }
    }
}

