/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SVNRevision {
    public static final SVNRevision HEAD = new SVNRevision("HEAD", 0);
    public static final SVNRevision WORKING = new SVNRevision("WORKING", 1);
    public static final SVNRevision PREVIOUS = new SVNRevision("PREV", 3);
    public static final SVNRevision BASE = new SVNRevision("BASE", 2);
    public static final SVNRevision COMMITTED = new SVNRevision("COMMITTED", 4);
    public static final SVNRevision UNDEFINED = new SVNRevision("UNDEFINED", 30);
    private static final Map ourValidRevisions = new HashMap();
    private static Pattern ISO_8601_EXTENDED_DATE_ONLY_PATTERN;
    private static Pattern ISO_8601_EXTENDED_UTC_PATTERN;
    private static Pattern ISO_8601_EXTENDED_OFFSET_PATTERN;
    private static Pattern ISO_8601_BASIC_DATE_ONLY_PATTERN;
    private static Pattern ISO_8601_BASIC_UTC_PATTERN;
    private static Pattern ISO_8601_BASIC_OFFSET_PATTERN;
    private static Pattern ISO_8601_GNU_FORMAT_PATTERN;
    private static Pattern SVN_LOG_DATE_FORMAT_PATTERN;
    private static Pattern TIME_ONLY_PATTERN;
    private static final Collection ourTimeFormatPatterns;
    private long myRevision;
    private String myName;
    private Date myDate;
    private int myID;
    static /* synthetic */ Class class$org$tmatesoft$svn$core$wc$SVNRevision;

    private SVNRevision(long number) {
        this.myRevision = number;
        this.myName = null;
        this.myID = 10;
    }

    private SVNRevision(String name, int id) {
        this(-1L);
        this.myName = name;
        this.myID = id;
    }

    private SVNRevision(Date date) {
        this(-1L);
        this.myDate = date;
        this.myID = 20;
    }

    public String getName() {
        return this.myName;
    }

    public long getNumber() {
        return this.myRevision;
    }

    public Date getDate() {
        return this.myDate;
    }

    public boolean isValid() {
        return this != UNDEFINED && (this.myDate != null || this.myRevision >= 0L || this.myName != null);
    }

    public int getID() {
        return this.myID;
    }

    public int hashCode() {
        if (this.myRevision >= 0L) {
            return (int)this.myRevision & 0xFFFFFFFF;
        }
        if (this.myDate != null) {
            return this.myDate.hashCode();
        }
        if (this.myName != null) {
            return this.myName.hashCode();
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != (class$org$tmatesoft$svn$core$wc$SVNRevision == null ? (class$org$tmatesoft$svn$core$wc$SVNRevision = SVNRevision.class$("org.tmatesoft.svn.core.wc.SVNRevision")) : class$org$tmatesoft$svn$core$wc$SVNRevision)) {
            return false;
        }
        SVNRevision r = (SVNRevision)o;
        if (this.myRevision >= 0L) {
            return this.myRevision == r.getNumber();
        }
        if (this.myDate != null) {
            return this.myDate.equals(r.getDate());
        }
        if (this.myName != null) {
            return this.myName.equals(r.getName());
        }
        return !r.isValid();
    }

    public static boolean isValidRevisionNumber(long revision) {
        return revision >= 0L;
    }

    public static SVNRevision create(long revisionNumber) {
        if (revisionNumber < 0L) {
            return UNDEFINED;
        }
        return new SVNRevision(revisionNumber);
    }

    public static SVNRevision create(Date date) {
        return new SVNRevision(date);
    }

    public boolean isLocal() {
        boolean remote = !this.isValid() || this == HEAD || this.getNumber() >= 0L || this.getDate() != null;
        return !remote;
    }

    public static SVNRevision parse(String value) {
        if (value == null) {
            return UNDEFINED;
        }
        if (value.startsWith("-r")) {
            value = value.substring("-r".length());
        }
        if ((value = value.trim()).startsWith("{") && value.endsWith("}")) {
            value = value.substring(1);
            value = value.substring(0, value.length() - 1);
            try {
                Calendar date = Calendar.getInstance();
                Iterator patterns = ourTimeFormatPatterns.iterator();
                while (patterns.hasNext()) {
                    Pattern pattern = (Pattern)patterns.next();
                    Matcher matcher = pattern.matcher(value);
                    if (!matcher.matches()) continue;
                    if (pattern == ISO_8601_EXTENDED_DATE_ONLY_PATTERN || pattern == ISO_8601_BASIC_DATE_ONLY_PATTERN) {
                        int year = Integer.parseInt(matcher.group(1));
                        int month = Integer.parseInt(matcher.group(2));
                        int day = Integer.parseInt(matcher.group(3));
                        date.clear();
                        date.set(year, month - 1, day);
                    } else if (pattern == ISO_8601_EXTENDED_UTC_PATTERN || pattern == ISO_8601_EXTENDED_OFFSET_PATTERN || pattern == ISO_8601_BASIC_UTC_PATTERN || pattern == ISO_8601_BASIC_OFFSET_PATTERN || pattern == ISO_8601_GNU_FORMAT_PATTERN || pattern == SVN_LOG_DATE_FORMAT_PATTERN) {
                        int year = Integer.parseInt(matcher.group(1));
                        int month = Integer.parseInt(matcher.group(2));
                        int day = Integer.parseInt(matcher.group(3));
                        int hours = Integer.parseInt(matcher.group(4));
                        int minutes = Integer.parseInt(matcher.group(5));
                        int seconds = 0;
                        int milliseconds = 0;
                        if (matcher.group(6) != null) {
                            seconds = Integer.parseInt(matcher.group(7));
                            if (matcher.group(8) != null) {
                                String millis = matcher.group(9);
                                millis = millis.length() <= 3 ? millis : millis.substring(0, 3);
                                milliseconds = Integer.parseInt(millis);
                            }
                        }
                        date.clear();
                        date.set(year, month - 1, day, hours, minutes, seconds);
                        date.set(14, milliseconds);
                        if (pattern == ISO_8601_EXTENDED_OFFSET_PATTERN || pattern == ISO_8601_BASIC_OFFSET_PATTERN || pattern == ISO_8601_GNU_FORMAT_PATTERN) {
                            int zoneOffsetInMillis = "+".equals(matcher.group(10)) ? 1 : -1;
                            int hoursOffset = Integer.parseInt(matcher.group(11));
                            int minutesOffset = matcher.group(12) != null ? Integer.parseInt(matcher.group(13)) : 0;
                            date.set(15, zoneOffsetInMillis *= (hoursOffset * 3600 + minutesOffset * 60) * 1000);
                        } else if (pattern == SVN_LOG_DATE_FORMAT_PATTERN && matcher.group(10) != null) {
                            int zoneOffsetInMillis = "+".equals(matcher.group(11)) ? 1 : -1;
                            int hoursOffset = Integer.parseInt(matcher.group(12));
                            int minutesOffset = matcher.group(13) != null ? Integer.parseInt(matcher.group(13)) : 0;
                            date.set(15, zoneOffsetInMillis *= (hoursOffset * 3600 + minutesOffset * 60) * 1000);
                        }
                    } else if (pattern == TIME_ONLY_PATTERN) {
                        int hours = Integer.parseInt(matcher.group(1));
                        int minutes = Integer.parseInt(matcher.group(2));
                        int seconds = 0;
                        int milliseconds = 0;
                        if (matcher.group(3) != null) {
                            seconds = Integer.parseInt(matcher.group(4));
                            if (matcher.group(5) != null) {
                                String millis = matcher.group(6);
                                millis = millis.length() <= 3 ? millis : millis.substring(0, 3);
                                milliseconds = Integer.parseInt(millis);
                            }
                        }
                        date.set(11, hours);
                        date.set(12, minutes);
                        date.set(13, seconds);
                        date.set(14, milliseconds);
                    }
                    return SVNRevision.create(date.getTime());
                }
                return UNDEFINED;
            }
            catch (NumberFormatException e) {
                return UNDEFINED;
            }
        }
        try {
            long number = Long.parseLong(value);
            return SVNRevision.create(number);
        }
        catch (NumberFormatException nfe) {
            SVNRevision revision = (SVNRevision)ourValidRevisions.get(value.toUpperCase());
            if (revision == null) {
                return UNDEFINED;
            }
            return revision;
        }
    }

    public String toString() {
        if (this.myRevision >= 0L) {
            return Long.toString(this.myRevision);
        }
        if (this.myName != null) {
            return this.myName;
        }
        if (this.myDate != null) {
            return DateFormat.getDateTimeInstance().format(this.myDate);
        }
        return "{invalid revision}";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ourValidRevisions.put(HEAD.getName(), HEAD);
        ourValidRevisions.put(WORKING.getName(), WORKING);
        ourValidRevisions.put(PREVIOUS.getName(), PREVIOUS);
        ourValidRevisions.put(BASE.getName(), BASE);
        ourValidRevisions.put(COMMITTED.getName(), COMMITTED);
        ISO_8601_EXTENDED_DATE_ONLY_PATTERN = Pattern.compile("(\\d{4})-(\\d{1,2})-(\\d{1,2})");
        ISO_8601_EXTENDED_UTC_PATTERN = Pattern.compile("(\\d{4})-(\\d{1,2})-(\\d{1,2})T(\\d{1,2}):(\\d{2})(:(\\d{2})([.,](\\d{1,6}))?)?(?:Z)?");
        ISO_8601_EXTENDED_OFFSET_PATTERN = Pattern.compile("(\\d{4})-(\\d{1,2})-(\\d{1,2})T(\\d{1,2}):(\\d{2})(:(\\d{2})([.,](\\d{1,6}))?)?([+-])(\\d{2})(:(\\d{2}))?");
        ISO_8601_BASIC_DATE_ONLY_PATTERN = Pattern.compile("(\\d{4})(\\d{2})(\\d{2})");
        ISO_8601_BASIC_UTC_PATTERN = Pattern.compile("(\\d{4})(\\d{2})(\\d{2})T(\\d{2})(\\d{2})((\\d{2})([.,](\\d{1,6}))?)?(?:Z)?");
        ISO_8601_BASIC_OFFSET_PATTERN = Pattern.compile("(\\d{4})(\\d{2})(\\d{2})T(\\d{2})(\\d{2})((\\d{2})([.,](\\d{1,6}))?)?([+-])(\\d{2})((\\d{2}))?");
        ISO_8601_GNU_FORMAT_PATTERN = Pattern.compile("(\\d{4})-(\\d{1,2})-(\\d{1,2})T(\\d{1,2}):(\\d{2})(:(\\d{2})([.,](\\d{1,6}))?)?([+-])(\\d{2})((\\d{2}))?");
        SVN_LOG_DATE_FORMAT_PATTERN = Pattern.compile("(\\d{4})-(\\d{1,2})-(\\d{1,2}) (\\d{1,2}):(\\d{2})(:(\\d{2})([.,](\\d{1,6}))?)?( ([+-])(\\d{2})(\\d{2})?)?");
        TIME_ONLY_PATTERN = Pattern.compile("(\\d{1,2}):(\\d{2})(:(\\d{2})([.,](\\d{1,6}))?)?");
        ourTimeFormatPatterns = new LinkedList();
        ourTimeFormatPatterns.add(ISO_8601_EXTENDED_DATE_ONLY_PATTERN);
        ourTimeFormatPatterns.add(ISO_8601_EXTENDED_UTC_PATTERN);
        ourTimeFormatPatterns.add(ISO_8601_EXTENDED_OFFSET_PATTERN);
        ourTimeFormatPatterns.add(ISO_8601_BASIC_DATE_ONLY_PATTERN);
        ourTimeFormatPatterns.add(ISO_8601_BASIC_UTC_PATTERN);
        ourTimeFormatPatterns.add(ISO_8601_BASIC_OFFSET_PATTERN);
        ourTimeFormatPatterns.add(SVN_LOG_DATE_FORMAT_PATTERN);
        ourTimeFormatPatterns.add(ISO_8601_GNU_FORMAT_PATTERN);
        ourTimeFormatPatterns.add(TIME_ONLY_PATTERN);
    }
}

