/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNFormatUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNTimeUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslatorOutputStream;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.wc.ISVNOptions;

public class SVNTranslator {
    public static final byte[] CRLF = new byte[]{13, 10};
    public static final byte[] LF = new byte[]{10};
    public static final byte[] CR = new byte[]{13};
    public static final byte[] NATIVE = System.getProperty("line.separator").getBytes();

    public static void translate(SVNAdminArea adminArea, String name, String srcPath, String dstPath, boolean expand) throws SVNException {
        SVNTranslator.translate(adminArea, name, adminArea.getFile(srcPath), adminArea.getFile(dstPath), expand);
    }

    public static void translate(SVNAdminArea adminArea, String name, File src, File dst, boolean expand) throws SVNException {
        File dst2 = dst;
        SVNVersionedProperties props = adminArea.getProperties(name);
        String keywords = props.getPropertyValue("svn:keywords");
        String eolStyle = props.getPropertyValue("svn:eol-style");
        boolean special = props.getPropertyValue("svn:special") != null;
        Map keywordsMap = null;
        if (keywords != null) {
            if (expand) {
                SVNEntry entry = adminArea.getEntry(name, true);
                ISVNOptions options = adminArea.getWCAccess().getOptions();
                String url = entry.getURL();
                String author = entry.getAuthor();
                String date = entry.getCommittedDate();
                String rev = Long.toString(entry.getCommittedRevision());
                keywordsMap = SVNTranslator.computeKeywords(keywords, url, author, date, rev, options);
            } else {
                keywordsMap = SVNTranslator.computeKeywords(keywords, null, null, null, null, null);
            }
        }
        byte[] eols = !expand ? SVNTranslator.getBaseEOL(eolStyle) : SVNTranslator.getWorkingEOL(eolStyle);
        SVNTranslator.translate(src, dst2, eols, keywordsMap, special, expand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void translate(File src, File dst, byte[] eol, Map keywords, boolean special, boolean expand) throws SVNException {
        if (src == null || dst == null) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.INCORRECT_PARAMS));
            return;
        }
        if (src.equals(dst)) {
            return;
        }
        if (special) {
            if (dst.exists()) {
                dst.delete();
            }
            if (SVNFileUtil.isWindows) {
                SVNFileUtil.copyFile(src, dst, true);
            } else if (expand) {
                SVNFileUtil.createSymlink(dst, src);
            } else {
                SVNFileUtil.detranslateSymlink(src, dst);
            }
            return;
        }
        if (eol == null && (keywords == null || keywords.isEmpty())) {
            SVNFileUtil.copyFile(src, dst, false);
            return;
        }
        OutputStream os = SVNFileUtil.openFileForWriting(dst);
        SVNTranslatorOutputStream tos = new SVNTranslatorOutputStream(os, eol, false, keywords, expand);
        InputStream is = SVNFileUtil.openFileForReading(src);
        try {
            SVNTranslator.copy(is, tos);
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
            SVNErrorManager.error(err, e);
        }
        finally {
            SVNFileUtil.closeFile(tos);
            SVNFileUtil.closeFile(os);
            SVNFileUtil.closeFile(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkNewLines(File file) {
        if (file == null || !file.exists() || file.isDirectory()) {
            return true;
        }
        InputStream is = null;
        try {
            int r;
            is = SVNFileUtil.openFileForReading(file);
            byte[] lastFoundEOL = null;
            byte[] currentEOL = null;
            while ((r = is.read()) >= 0) {
                if (r == 10) {
                    currentEOL = LF;
                } else if (r == 13) {
                    currentEOL = CR;
                    r = is.read();
                    if (r == 10) {
                        currentEOL = CRLF;
                    }
                }
                if (lastFoundEOL == null) {
                    lastFoundEOL = currentEOL;
                    continue;
                }
                if (currentEOL == null || lastFoundEOL == currentEOL) continue;
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        catch (SVNException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            SVNFileUtil.closeFile(is);
        }
        return true;
    }

    public static void copy(InputStream src, OutputStream dst) throws IOException {
        byte[] buffer = new byte[8192];
        int read;
        while ((read = src.read(buffer)) > 0) {
            dst.write(buffer, 0, read);
        }
        return;
    }

    public static Map computeKeywords(String keywords, String u, String a, String d, String r, ISVNOptions options) {
        if (keywords == null) {
            return Collections.EMPTY_MAP;
        }
        boolean expand = u != null;
        byte[] date = null;
        byte[] idDate = null;
        byte[] url = null;
        byte[] rev = null;
        byte[] author = null;
        byte[] name = null;
        byte[] id = null;
        Date jDate = d == null ? null : SVNTimeUtil.parseDate(d);
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        try {
            StringTokenizer tokens = new StringTokenizer(keywords, " \t\n\b\r\f");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                if ("LastChangedDate".equalsIgnoreCase(token) || "Date".equalsIgnoreCase(token)) {
                    date = expand && date == null ? SVNFormatUtil.formatHumanDate(jDate, options).getBytes("UTF-8") : date;
                    map.put("LastChangedDate", date);
                    map.put("Date", date);
                    continue;
                }
                if ("LastChangedRevision".equalsIgnoreCase(token) || "Revision".equalsIgnoreCase(token) || "Rev".equalsIgnoreCase(token)) {
                    rev = expand && rev == null ? r.getBytes("UTF-8") : rev;
                    map.put("LastChangedRevision", rev);
                    map.put("Revision", rev);
                    map.put("Rev", rev);
                    continue;
                }
                if ("LastChangedBy".equalsIgnoreCase(token) || "Author".equalsIgnoreCase(token)) {
                    author = expand && author == null ? (a == null ? new byte[]{} : a.getBytes("UTF-8")) : author;
                    map.put("LastChangedBy", author);
                    map.put("Author", author);
                    continue;
                }
                if ("HeadURL".equalsIgnoreCase(token) || "URL".equalsIgnoreCase(token)) {
                    url = expand && url == null ? SVNEncodingUtil.uriDecode(u).getBytes("UTF-8") : url;
                    map.put("HeadURL", url);
                    map.put("URL", url);
                    continue;
                }
                if (!"Id".equalsIgnoreCase(token)) continue;
                if (expand && id == null) {
                    rev = rev == null ? r.getBytes("UTF-8") : rev;
                    idDate = idDate == null ? SVNFormatUtil.formatDate(jDate).getBytes("UTF-8") : idDate;
                    byte[] byArray = name = name == null ? SVNEncodingUtil.uriDecode(SVNPathUtil.tail(u)).getBytes("UTF-8") : name;
                    author = author == null ? (a == null ? new byte[]{} : a.getBytes("UTF-8")) : author;
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    bos.write(name);
                    bos.write(32);
                    bos.write(rev);
                    bos.write(32);
                    bos.write(idDate);
                    bos.write(32);
                    bos.write(author);
                    bos.close();
                    id = bos.toByteArray();
                }
                map.put("Id", expand ? id : null);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return map;
    }

    public static byte[] getEOL(String propertyValue) {
        if ("native".equals(propertyValue)) {
            return NATIVE;
        }
        if ("LF".equals(propertyValue)) {
            return LF;
        }
        if ("CR".equals(propertyValue)) {
            return CR;
        }
        if ("CRLF".equals(propertyValue)) {
            return CRLF;
        }
        return null;
    }

    public static byte[] getBaseEOL(String eolStyle) {
        if ("native".equals(eolStyle)) {
            return LF;
        }
        if ("CR".equals(eolStyle)) {
            return CR;
        }
        if ("LF".equals(eolStyle)) {
            return LF;
        }
        if ("CRLF".equals(eolStyle)) {
            return CRLF;
        }
        return null;
    }

    public static byte[] getWorkingEOL(String eolStyle) {
        if ("native".equals(eolStyle)) {
            return NATIVE;
        }
        if ("CR".equals(eolStyle)) {
            return CR;
        }
        if ("LF".equals(eolStyle)) {
            return LF;
        }
        if ("CRLF".equals(eolStyle)) {
            return CRLF;
        }
        return null;
    }
}

