/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNTimeUtil;
import org.tmatesoft.svn.core.internal.wc.SVNAdminUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNLog;
import org.tmatesoft.svn.core.internal.wc.admin.SVNLogImpl;
import org.tmatesoft.svn.core.internal.wc.admin.SVNLogRunner;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.wc.ISVNCommitParameters;
import org.tmatesoft.svn.core.wc.ISVNMerger;
import org.tmatesoft.svn.core.wc.ISVNMergerFactory;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.util.SVNDebugLog;

public abstract class SVNAdminArea {
    private static volatile boolean ourIsCleanupSafe;
    private File myDirectory;
    private SVNWCAccess myWCAccess;
    private File myAdminRoot;
    protected Map myBaseProperties;
    protected Map myProperties;
    protected Map myWCProperties;
    protected Map myEntries;
    private Map myRevertProperties;
    protected boolean myWasLocked;
    private ISVNCommitParameters myCommitParameters;
    static /* synthetic */ Class class$org$tmatesoft$svn$core$internal$wc$DefaultSVNMerger;

    public static synchronized void setSafeCleanup(boolean safe) {
        ourIsCleanupSafe = safe;
    }

    public static synchronized boolean isSafeCleanup() {
        return ourIsCleanupSafe;
    }

    public abstract boolean isLocked() throws SVNException;

    public abstract boolean isVersioned();

    protected abstract boolean isEntryPropertyApplicable(String var1);

    public abstract boolean lock(boolean var1) throws SVNException;

    public abstract boolean unlock() throws SVNException;

    public abstract SVNVersionedProperties getBaseProperties(String var1) throws SVNException;

    public abstract SVNVersionedProperties getRevertProperties(String var1) throws SVNException;

    public abstract SVNVersionedProperties getWCProperties(String var1) throws SVNException;

    public abstract SVNVersionedProperties getProperties(String var1) throws SVNException;

    public abstract void saveVersionedProperties(SVNLog var1, boolean var2) throws SVNException;

    public abstract void saveWCProperties(boolean var1) throws SVNException;

    public abstract void saveEntries(boolean var1) throws SVNException;

    public abstract String getThisDirName();

    public abstract boolean hasPropModifications(String var1) throws SVNException;

    public abstract boolean hasProperties(String var1) throws SVNException;

    public abstract SVNAdminArea createVersionedDirectory(File var1, String var2, String var3, String var4, long var5, boolean var7) throws SVNException;

    public abstract SVNAdminArea upgradeFormat(SVNAdminArea var1) throws SVNException;

    public abstract void postUpgradeFormat(int var1) throws SVNException;

    public abstract void postCommit(String var1, long var2, boolean var4, SVNErrorCode var5) throws SVNException;

    public void updateURL(String rootURL, boolean recursive) throws SVNException {
        SVNWCAccess wcAccess = this.getWCAccess();
        Iterator ents = this.entries(false);
        while (ents.hasNext()) {
            SVNEntry entry = (SVNEntry)ents.next();
            if (!this.getThisDirName().equals(entry.getName()) && entry.isDirectory() && recursive) {
                SVNAdminArea childDir = wcAccess.retrieve(this.getFile(entry.getName()));
                if (childDir == null) continue;
                String childURL = SVNPathUtil.append(rootURL, SVNEncodingUtil.uriEncode(entry.getName()));
                childDir.updateURL(childURL, recursive);
                continue;
            }
            entry.setURL(this.getThisDirName().equals(entry.getName()) ? rootURL : SVNPathUtil.append(rootURL, SVNEncodingUtil.uriEncode(entry.getName())));
        }
        this.saveEntries(false);
    }

    public boolean hasTextModifications(String name, boolean forceComparision) throws SVNException {
        return this.hasTextModifications(name, forceComparision, true, false);
    }

    public boolean hasTextModifications(String name, boolean forceComparison, boolean compareTextBase, boolean compareChecksum) throws SVNException {
        SVNEntry entry = this.getEntry(name, false);
        SVNFileType fType = SVNFileType.getType(this.getFile(name));
        if (!forceComparison && fType != SVNFileType.SYMLINK) {
            long tstamp;
            long textTimeAsLong;
            if (entry == null || entry.isDirectory()) {
                return false;
            }
            String textTime = entry.getTextTime();
            if (textTime != null && (textTimeAsLong = SVNFileUtil.roundTimeStamp(SVNTimeUtil.parseDateAsLong(textTime))) == (tstamp = SVNFileUtil.roundTimeStamp(this.getFile(name).lastModified()))) {
                return false;
            }
        }
        if (fType != SVNFileType.FILE && fType != SVNFileType.SYMLINK) {
            return false;
        }
        File textFile = this.getFile(name);
        File baseFile = this.getBaseFile(name, false);
        if (!baseFile.isFile()) {
            return true;
        }
        boolean differs = this.compareAndVerify(textFile, baseFile, compareTextBase, compareChecksum);
        if (!differs && this.isLocked()) {
            entry.setTextTime(SVNTimeUtil.formatDate(new Date(textFile.lastModified())));
            this.saveEntries(false);
        }
        return differs;
    }

    /*
     * Exception decompiling
     */
    private boolean compareAndVerify(File text, File baseFile, boolean compareTextBase, boolean checksum) throws SVNException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 8[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getRelativePath(SVNAdminArea anchor) {
        String absoluteAnchor = anchor.getRoot().getAbsolutePath();
        String ownAbsolutePath = this.getRoot().getAbsolutePath();
        String relativePath = ownAbsolutePath.substring(absoluteAnchor.length());
        if ((relativePath = relativePath.replace(File.separatorChar, '/')).startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        if (relativePath.endsWith("/")) {
            relativePath = relativePath.substring(0, relativePath.length() - 1);
        }
        return relativePath;
    }

    public boolean tweakEntry(String name, String newURL, String reposRoot, long newRevision, boolean remove) throws SVNException {
        boolean rewrite = false;
        SVNEntry entry = this.getEntry(name, true);
        if (entry == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "No such entry: ''{0}''", name);
            SVNErrorManager.error(err);
        }
        if (!(newURL == null || entry.getURL() != null && newURL.equals(entry.getURL()))) {
            rewrite = true;
            entry.setURL(newURL);
        }
        if (reposRoot != null && (entry.getRepositoryRootURL() == null || !reposRoot.equals(entry.getRepositoryRoot())) && entry.getURL() != null && SVNPathUtil.isAncestor(reposRoot, entry.getURL())) {
            boolean setReposRoot = true;
            if (this.getThisDirName().equals(entry.getName())) {
                Iterator entries = this.entries(true);
                while (entries.hasNext()) {
                    SVNEntry childEntry = (SVNEntry)entries.next();
                    if (childEntry.getRepositoryRoot() != null || childEntry.getURL() == null || SVNPathUtil.isAncestor(reposRoot, entry.getURL())) continue;
                    setReposRoot = false;
                    break;
                }
            }
            if (setReposRoot) {
                rewrite = true;
                entry.setRepositoryRoot(reposRoot);
            }
        }
        if (newRevision >= 0L && !entry.isScheduledForAddition() && !entry.isScheduledForReplacement() && entry.getRevision() != newRevision) {
            rewrite = true;
            entry.setRevision(newRevision);
        }
        if (remove && (entry.isDeleted() || entry.isAbsent() && entry.getRevision() != newRevision)) {
            this.deleteEntry(name);
            rewrite = true;
        }
        return rewrite;
    }

    public boolean isKillMe() {
        return this.getAdminFile("KILLME").isFile();
    }

    public boolean markResolved(String name, boolean text, boolean props) throws SVNException {
        File file;
        if (!text && !props) {
            return false;
        }
        SVNEntry entry = this.getEntry(name, true);
        if (entry == null) {
            return false;
        }
        boolean filesDeleted = false;
        boolean updateEntry = false;
        if (text && entry.getConflictOld() != null) {
            file = this.getFile(entry.getConflictOld());
            filesDeleted |= file.isFile();
            updateEntry = true;
            SVNFileUtil.deleteFile(file);
        }
        if (text && entry.getConflictNew() != null) {
            file = this.getFile(entry.getConflictNew());
            filesDeleted |= file.isFile();
            updateEntry = true;
            SVNFileUtil.deleteFile(file);
        }
        if (text && entry.getConflictWorking() != null) {
            file = this.getFile(entry.getConflictWorking());
            filesDeleted |= file.isFile();
            updateEntry = true;
            SVNFileUtil.deleteFile(file);
        }
        if (props && entry.getPropRejectFile() != null) {
            file = this.getFile(entry.getPropRejectFile());
            filesDeleted |= file.isFile();
            updateEntry = true;
            SVNFileUtil.deleteFile(file);
        }
        if (updateEntry) {
            if (text) {
                entry.setConflictOld(null);
                entry.setConflictNew(null);
                entry.setConflictWorking(null);
            }
            if (props) {
                entry.setPropRejectFile(null);
            }
            this.saveEntries(false);
        }
        return filesDeleted;
    }

    public void restoreFile(String name) throws SVNException {
        boolean needsLock;
        SVNVersionedProperties props = this.getProperties(name);
        SVNEntry entry = this.getEntry(name, true);
        boolean special = props.getPropertyValue("svn:special") != null;
        File src = this.getBaseFile(name, false);
        File dst = this.getFile(name);
        SVNTranslator.translate(this, name, SVNFileUtil.getBasePath(src), SVNFileUtil.getBasePath(dst), true);
        boolean executable = props.getPropertyValue("svn:executable") != null;
        boolean bl = needsLock = props.getPropertyValue("svn:needs-lock") != null;
        if (needsLock) {
            SVNFileUtil.setReadonly(dst, entry.getLockToken() == null);
        }
        if (executable) {
            SVNFileUtil.setExecutable(dst, true);
        }
        this.markResolved(name, true, false);
        if (this.myWCAccess.getOptions().isUseCommitTimes() && !special) {
            entry.setTextTime(entry.getCommittedDate());
            long tstamp = SVNTimeUtil.parseDate(entry.getCommittedDate()).getTime();
            dst.setLastModified(tstamp);
        } else {
            long tstamp = System.currentTimeMillis();
            dst.setLastModified(tstamp);
            entry.setTextTime(SVNTimeUtil.formatDate(new Date(tstamp)));
        }
        this.saveEntries(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNStatusType mergeProperties(String name, Map serverBaseProps, Map propDiff, boolean baseMerge, boolean dryRun, SVNLog log) throws SVNException {
        serverBaseProps = serverBaseProps == null ? Collections.EMPTY_MAP : serverBaseProps;
        propDiff = propDiff == null ? Collections.EMPTY_MAP : propDiff;
        SVNVersionedProperties working = this.getProperties(name);
        Map workingProps = working.asMap();
        SVNVersionedProperties base = this.getBaseProperties(name);
        ArrayList<String> conflicts = new ArrayList<String>();
        SVNStatusType result = propDiff.isEmpty() ? SVNStatusType.UNCHANGED : SVNStatusType.CHANGED;
        Iterator propEntries = propDiff.entrySet().iterator();
        while (propEntries.hasNext()) {
            Map.Entry incomingEntry = propEntries.next();
            String propName = (String)incomingEntry.getKey();
            String toValue = (String)incomingEntry.getValue();
            String fromValue = (String)serverBaseProps.get(propName);
            String workingValue = (String)workingProps.get(propName);
            boolean isNormal = SVNProperty.isRegularProperty(propName);
            if (baseMerge) {
                base.setPropertyValue(propName, toValue);
            }
            SVNStatusType sVNStatusType = result = isNormal ? SVNStatusType.CHANGED : result;
            if (fromValue == null) {
                if (workingValue != null) {
                    if (workingValue.equals(toValue)) {
                        result = result != SVNStatusType.CONFLICTED && isNormal ? SVNStatusType.MERGED : result;
                        continue;
                    }
                    result = isNormal ? SVNStatusType.CONFLICTED : result;
                    conflicts.add(MessageFormat.format("Trying to add new property ''{0}'' with value ''{1}'',\nbut property already exists with value ''{2}''.", propName, toValue, workingValue));
                    continue;
                }
                working.setPropertyValue(propName, toValue);
                continue;
            }
            if (workingValue == null) {
                if (toValue != null) {
                    result = isNormal ? SVNStatusType.CONFLICTED : result;
                    conflicts.add(MessageFormat.format("Trying to change property ''{0}'' from ''{1}'' to ''{2}'',\nbut the property does not exist.", propName, fromValue, toValue));
                    continue;
                }
                result = result != SVNStatusType.CONFLICTED && isNormal ? SVNStatusType.MERGED : result;
                continue;
            }
            if (workingValue.equals(fromValue)) {
                working.setPropertyValue(propName, toValue);
                continue;
            }
            if (toValue == null && !workingValue.equals(fromValue)) {
                result = isNormal ? SVNStatusType.CONFLICTED : result;
                conflicts.add(MessageFormat.format("Trying to delete property ''{0}'' but value has been modified from ''{1}'' to ''{2}''.", propName, fromValue, workingValue));
                continue;
            }
            if (workingValue.equals(toValue)) {
                result = result != SVNStatusType.CONFLICTED && isNormal ? SVNStatusType.MERGED : result;
                continue;
            }
            result = isNormal ? SVNStatusType.CONFLICTED : result;
            conflicts.add(MessageFormat.format("Trying to change property ''{0}'' from ''{1}'' to ''{2}'',\nbut property already exists with value ''{3}''.", propName, fromValue, toValue, workingValue));
        }
        HashMap<String, String> command = new HashMap<String, String>();
        if (dryRun) {
            return result;
        }
        log = log == null ? this.getLog() : log;
        this.saveVersionedProperties(log, true);
        if (!conflicts.isEmpty()) {
            String prejTmpPath = this.getThisDirName().equals(name) ? "tmp/dir_conflicts" : "tmp/props/" + name;
            File prejTmpFile = SVNFileUtil.createUniqueFile(this.getAdminDirectory(), prejTmpPath, ".prej");
            prejTmpPath = SVNFileUtil.getBasePath(prejTmpFile);
            SVNEntry entry = this.getEntry(name, false);
            if (entry == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "Can''t find entry ''{0}'' in ''{1}''", new Object[]{name, this.getRoot()});
                SVNErrorManager.error(err);
            }
            String prejPath = entry.getPropRejectFile();
            this.closeEntries();
            if (prejPath == null) {
                prejPath = this.getThisDirName().equals(name) ? "dir_conflicts" : name;
                File prejFile = SVNFileUtil.createUniqueFile(this.getRoot(), prejPath, ".prej");
                prejPath = SVNFileUtil.getBasePath(prejFile);
            }
            File file = this.getFile(prejTmpPath);
            OutputStream os = SVNFileUtil.openFileForWriting(file);
            try {
                Iterator lines = conflicts.iterator();
                while (lines.hasNext()) {
                    String line = (String)lines.next();
                    os.write(SVNEncodingUtil.fuzzyEscape(line).getBytes("UTF-8"));
                }
            }
            catch (IOException e) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot write properties conflict file: {1}", e.getLocalizedMessage());
                SVNErrorManager.error(err, e);
            }
            finally {
                SVNFileUtil.closeFile(os);
            }
            command.put("name", prejTmpPath);
            command.put("dest", prejPath);
            log.addCommand("append", command, false);
            command.clear();
            command.put("name", prejTmpPath);
            log.addCommand("rm", command, false);
            command.clear();
            command.put("name", name);
            command.put(SVNProperty.shortPropertyName("svn:entry:prop-reject-file"), prejPath);
            log.addCommand("modify-entry", command, false);
        }
        return result;
    }

    public SVNStatusType mergeText(String localPath, File base, File latest, String localLabel, String baseLabel, String latestLabel, boolean leaveConflict, boolean dryRun) throws SVNException {
        return this.mergeText(localPath, base, latest, localLabel, baseLabel, latestLabel, leaveConflict, dryRun, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNStatusType mergeText(String localPath, File base, File latest, String localLabel, String baseLabel, String latestLabel, boolean leaveConflict, boolean dryRun, SVNDiffOptions options) throws SVNException {
        boolean customMerger;
        SVNEntry entry = this.getEntry(localPath, false);
        if (entry == null) {
            return SVNStatusType.UNCHANGED;
        }
        SVNVersionedProperties props = this.getProperties(localPath);
        String mimeType = props.getPropertyValue("svn:mime-type");
        SVNStatusType status = SVNStatusType.UNCHANGED;
        byte[] conflictStart = ("<<<<<<< " + localLabel).getBytes();
        byte[] conflictEnd = (">>>>>>> " + latestLabel).getBytes();
        byte[] separator = "=======".getBytes();
        ISVNMergerFactory factory = this.myWCAccess.getOptions().getMergerFactory();
        ISVNMerger merger = factory.createMerger(conflictStart, separator, conflictEnd);
        boolean bl = customMerger = merger.getClass() != (class$org$tmatesoft$svn$core$internal$wc$DefaultSVNMerger == null ? (class$org$tmatesoft$svn$core$internal$wc$DefaultSVNMerger = SVNAdminArea.class$("org.tmatesoft.svn.core.internal.wc.DefaultSVNMerger")) : class$org$tmatesoft$svn$core$internal$wc$DefaultSVNMerger);
        if (SVNProperty.isBinaryMimeType(mimeType) && !customMerger) {
            if (!dryRun) {
                File oldFile = SVNFileUtil.createUniqueFile(this.getRoot(), localPath, baseLabel);
                File newFile = SVNFileUtil.createUniqueFile(this.getRoot(), localPath, latestLabel);
                SVNFileUtil.copyFile(base, oldFile, false);
                SVNFileUtil.copyFile(latest, newFile, false);
                entry.setConflictNew(SVNFileUtil.getBasePath(newFile));
                entry.setConflictOld(SVNFileUtil.getBasePath(oldFile));
                entry.setConflictWorking(null);
                this.saveEntries(false);
            }
            status = SVNStatusType.CONFLICTED;
        } else {
            File localTmpFile = SVNFileUtil.createUniqueFile(this.getRoot(), localPath, ".tmp");
            SVNTranslator.translate(this, localPath, localPath, SVNFileUtil.getBasePath(localTmpFile), false);
            OutputStream result = null;
            File resultFile = dryRun ? null : SVNFileUtil.createUniqueFile(this.getRoot(), localPath, ".result");
            result = resultFile == null ? SVNFileUtil.DUMMY_OUT : SVNFileUtil.openFileForWriting(resultFile);
            try {
                status = SVNProperty.isBinaryMimeType(mimeType) ? merger.mergeBinary(base, localTmpFile, latest, dryRun, result) : merger.mergeText(base, localTmpFile, latest, dryRun, options, result);
            }
            finally {
                SVNFileUtil.closeFile(result);
            }
            if (dryRun) {
                localTmpFile.delete();
                if (leaveConflict && status == SVNStatusType.CONFLICTED) {
                    status = SVNStatusType.CONFLICTED_UNRESOLVED;
                }
            } else if (status != SVNStatusType.CONFLICTED) {
                SVNTranslator.translate(this, localPath, SVNFileUtil.getBasePath(resultFile), localPath, true);
            } else {
                File mineFile = SVNFileUtil.createUniqueFile(this.getRoot(), localPath, localLabel);
                String minePath = SVNFileUtil.getBasePath(mineFile);
                SVNFileUtil.copyFile(this.getFile(localPath), mineFile, false);
                File oldFile = SVNFileUtil.createUniqueFile(this.getRoot(), localPath, baseLabel);
                String oldPath = SVNFileUtil.getBasePath(oldFile);
                File newFile = SVNFileUtil.createUniqueFile(this.getRoot(), localPath, latestLabel);
                String newPath = SVNFileUtil.getBasePath(newFile);
                SVNTranslator.translate(this, localPath, base, oldFile, true);
                SVNTranslator.translate(this, localPath, latest, newFile, true);
                if (!leaveConflict) {
                    SVNTranslator.translate(this, localPath, SVNFileUtil.getBasePath(resultFile), localPath, true);
                }
                entry.setConflictNew(newPath);
                entry.setConflictOld(oldPath);
                entry.setConflictWorking(minePath);
                this.saveEntries(false);
            }
            localTmpFile.delete();
            if (resultFile != null) {
                resultFile.delete();
            }
            if (status == SVNStatusType.CONFLICTED && leaveConflict) {
                status = SVNStatusType.CONFLICTED_UNRESOLVED;
            }
        }
        if (!dryRun) {
            boolean executable;
            boolean bl2 = SVNFileUtil.isWindows ? false : (executable = props.getPropertyValue("svn:executable") != null);
            if (executable) {
                SVNFileUtil.setExecutable(this.getFile(localPath), true);
            }
            if (entry.getLockToken() == null && props.getPropertyValue("svn:needs-lock") != null) {
                SVNFileUtil.setReadonly(this.getFile(localPath), true);
            }
        }
        return status;
    }

    public InputStream getBaseFileForReading(String name, boolean tmp) throws SVNException {
        String path = tmp ? "tmp/" : "";
        path = path + "text-base/" + name + ".svn-base";
        File baseFile = this.getAdminFile(path);
        return SVNFileUtil.openFileForReading(baseFile);
    }

    public OutputStream getBaseFileForWriting(String name) throws SVNException {
        final String fileName = name;
        final File tmpFile = this.getBaseFile(name, true);
        try {
            final OutputStream os = SVNFileUtil.openFileForWriting(tmpFile);
            return new OutputStream(){
                private String myName;
                private File myTmpFile;
                {
                    this.myName = fileName;
                    this.myTmpFile = tmpFile;
                }

                public void write(int b) throws IOException {
                    os.write(b);
                }

                public void write(byte[] b) throws IOException {
                    os.write(b);
                }

                public void write(byte[] b, int off, int len) throws IOException {
                    os.write(b, off, len);
                }

                public void close() throws IOException {
                    os.close();
                    File baseFile = SVNAdminArea.this.getBaseFile(this.myName, false);
                    try {
                        SVNFileUtil.rename(this.myTmpFile, baseFile);
                    }
                    catch (SVNException e) {
                        throw new IOException(e.getMessage());
                    }
                    SVNFileUtil.setReadonly(baseFile, true);
                }
            };
        }
        catch (SVNException svne) {
            SVNErrorMessage err = svne.getErrorMessage().wrap("Your .svn/tmp directory may be missing or corrupt; run 'svn cleanup' and try again");
            SVNErrorManager.error(err);
            return null;
        }
    }

    public String getPropertyTime(String name) {
        String path = this.getThisDirName().equals(name) ? "dir-props" : "props/" + name + ".svn-work";
        File file = this.getAdminFile(path);
        return SVNTimeUtil.formatDate(new Date(file.lastModified()));
    }

    public SVNLog getLog() {
        int index = 0;
        File logFile = null;
        File tmpFile = null;
        while ((logFile = this.getAdminFile("log" + (index == 0 ? "" : "." + index))).exists()) {
            ++index;
        }
        tmpFile = this.getAdminFile("tmp/log" + (index == 0 ? "" : "." + index));
        return new SVNLogImpl(logFile, tmpFile, this);
    }

    public void runLogs() throws SVNException {
        SVNLogRunner runner = new SVNLogRunner();
        int index = 0;
        SVNLogImpl log = null;
        try {
            File logFile = null;
            while (true) {
                if (this.getWCAccess() != null) {
                    this.getWCAccess().checkCancelled();
                }
                if (((SVNLog)(log = new SVNLogImpl(logFile = this.getAdminFile("log" + (index == 0 ? "" : "." + index)), null, this))).exists()) {
                    log.run(runner);
                    SVNAdminArea.markLogProcessed(logFile);
                    ++index;
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            runner.logFailed(this);
            if (e instanceof SVNException) {
                throw (SVNException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new SVNException(SVNErrorMessage.create(SVNErrorCode.UNKNOWN), e);
        }
        runner.logCompleted(this);
        File[] logsFiles = this.getAdminDirectory().listFiles();
        if (logsFiles != null) {
            for (int i = 0; i < logsFiles.length; ++i) {
                if (!logsFiles[i].getName().startsWith("log") || !logsFiles[i].isFile()) continue;
                SVNFileUtil.deleteFile(logsFiles[i]);
            }
        }
    }

    private static void markLogProcessed(File logFile) throws SVNException {
        SVNFileUtil.deleteFile(logFile);
        SVNFileUtil.createEmptyFile(logFile);
    }

    public void removeFromRevisionControl(String name, boolean deleteWorkingFiles, boolean reportInstantError) throws SVNException {
        this.getWCAccess().checkCancelled();
        boolean isFile = !this.getThisDirName().equals(name);
        boolean leftSomething = false;
        if (isFile) {
            SVNErrorMessage err;
            File path = this.getFile(name);
            boolean textModified = false;
            boolean wasSpecial = false;
            boolean isSpecial = false;
            if (deleteWorkingFiles) {
                wasSpecial = this.getProperties(name).containsProperty("svn:special");
                boolean bl = isSpecial = SVNFileType.getType(path) == SVNFileType.SYMLINK;
                if (wasSpecial || !isSpecial) {
                    textModified = this.hasTextModifications(name, false);
                    if (reportInstantError && textModified) {
                        err = SVNErrorMessage.create(SVNErrorCode.WC_LEFT_LOCAL_MOD, "File ''{0}'' has local modifications", path);
                        SVNErrorManager.error(err);
                    }
                }
            }
            SVNPropertiesManager.deleteWCProperties(this, name, false);
            this.deleteEntry(name);
            this.saveEntries(false);
            SVNFileUtil.deleteFile(this.getFile(SVNAdminUtil.getTextBasePath(name, false)));
            SVNFileUtil.deleteFile(this.getFile(SVNAdminUtil.getPropPath(name, isFile ? SVNNodeKind.FILE : SVNNodeKind.DIR, false)));
            SVNFileUtil.deleteFile(this.getFile(SVNAdminUtil.getPropBasePath(name, isFile ? SVNNodeKind.FILE : SVNNodeKind.DIR, false)));
            if (deleteWorkingFiles) {
                if (textModified || !wasSpecial && isSpecial) {
                    err = SVNErrorMessage.create(SVNErrorCode.WC_LEFT_LOCAL_MOD);
                    SVNErrorManager.error(err);
                } else if (this.myCommitParameters == null || this.myCommitParameters.onFileDeletion(path)) {
                    SVNFileUtil.deleteFile(path);
                }
            }
        } else {
            SVNEntry dirEntry = this.getEntry(this.getThisDirName(), false);
            dirEntry.setIncomplete(true);
            this.saveEntries(false);
            SVNPropertiesManager.deleteWCProperties(this, this.getThisDirName(), false);
            Iterator entries = this.entries(false);
            while (entries.hasNext()) {
                String entryName;
                SVNEntry entry = (SVNEntry)entries.next();
                String string = entryName = this.getThisDirName().equals(entry.getName()) ? null : entry.getName();
                if (entry.isFile()) {
                    try {
                        this.removeFromRevisionControl(entryName, deleteWorkingFiles, reportInstantError);
                        continue;
                    }
                    catch (SVNException e) {
                        if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_LEFT_LOCAL_MOD) {
                            if (reportInstantError) {
                                throw e;
                            }
                            leftSomething = true;
                            continue;
                        }
                        throw e;
                    }
                }
                if (entryName == null || !entry.isDirectory()) continue;
                File entryPath = this.getFile(entryName);
                if (this.getWCAccess().isMissing(entryPath)) {
                    this.deleteEntry(entryName);
                    continue;
                }
                try {
                    SVNAdminArea entryArea = this.getWCAccess().retrieve(entryPath);
                    entryArea.removeFromRevisionControl(this.getThisDirName(), deleteWorkingFiles, reportInstantError);
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_LEFT_LOCAL_MOD) {
                        if (reportInstantError) {
                            throw e;
                        }
                        leftSomething = true;
                        continue;
                    }
                    throw e;
                }
            }
            if (!this.getWCAccess().isWCRoot(this.getRoot())) {
                this.getWCAccess().retrieve(this.getRoot().getParentFile()).deleteEntry(this.getRoot().getName());
                this.getWCAccess().retrieve(this.getRoot().getParentFile()).saveEntries(false);
            }
            this.destroyAdminArea();
            if (deleteWorkingFiles && !leftSomething && (this.myCommitParameters == null || this.myCommitParameters.onDirectoryDeletion(this.getRoot())) && !this.getRoot().delete()) {
                leftSomething = true;
            }
        }
        if (this.myBaseProperties != null) {
            this.myBaseProperties.remove(name);
        }
        if (this.myProperties != null) {
            this.myProperties.remove(name);
        }
        if (leftSomething && this.myCommitParameters == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_LEFT_LOCAL_MOD);
            SVNErrorManager.error(err);
        }
    }

    public void foldScheduling(String name, Map attributes, boolean force) throws SVNException {
        SVNErrorMessage err;
        if (!attributes.containsKey(SVNProperty.shortPropertyName("svn:entry:schedule")) || force) {
            return;
        }
        String schedule = (String)attributes.get(SVNProperty.shortPropertyName("svn:entry:schedule"));
        schedule = "".equals(schedule) ? null : schedule;
        SVNEntry entry = this.getEntry(name, true);
        if (entry == null) {
            if ("add".equals(schedule)) {
                return;
            }
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.WC_SCHEDULE_CONFLICT, "''{0}'' is not under version control", name);
            SVNErrorManager.error(err2);
        }
        SVNEntry thisDirEntry = this.getEntry(this.getThisDirName(), true);
        if (!this.getThisDirName().equals(entry.getName()) && thisDirEntry.isScheduledForDeletion()) {
            if ("add".equals(schedule)) {
                err = SVNErrorMessage.create(SVNErrorCode.WC_SCHEDULE_CONFLICT, "Can''t add ''{0}'' to deleted directory; try undeleting its parent directory first", name);
                SVNErrorManager.error(err);
            } else if ("replace".equals(schedule)) {
                err = SVNErrorMessage.create(SVNErrorCode.WC_SCHEDULE_CONFLICT, "Can''t replace ''{0}'' in deleted directory; try undeleting its parent directory first", name);
                SVNErrorManager.error(err);
            }
        }
        if (entry.isAbsent() && "add".equals(schedule)) {
            err = SVNErrorMessage.create(SVNErrorCode.WC_SCHEDULE_CONFLICT, "''{0}'' is marked as absent, so it cannot be scheduled for addition", name);
            SVNErrorManager.error(err);
        }
        if ("add".equals(entry.getSchedule())) {
            if ("delete".equals(schedule)) {
                if (!entry.isDeleted()) {
                    this.deleteEntry(name);
                } else {
                    attributes.put(SVNProperty.shortPropertyName("svn:entry:schedule"), null);
                }
            } else {
                attributes.remove(SVNProperty.shortPropertyName("svn:entry:schedule"));
            }
        } else if ("delete".equals(entry.getSchedule())) {
            if ("delete".equals(schedule)) {
                attributes.remove(SVNProperty.shortPropertyName("svn:entry:schedule"));
            } else if ("add".equals(schedule)) {
                attributes.put(SVNProperty.shortPropertyName("svn:entry:schedule"), "replace");
            }
        } else if ("replace".equals(entry.getSchedule())) {
            if ("delete".equals(schedule)) {
                attributes.put(SVNProperty.shortPropertyName("svn:entry:schedule"), "delete");
            } else if ("add".equals(schedule) || "replace".equals(schedule)) {
                attributes.remove(SVNProperty.shortPropertyName("svn:entry:schedule"));
            }
        } else if ("add".equals(schedule) && !entry.isDeleted()) {
            err = SVNErrorMessage.create(SVNErrorCode.WC_SCHEDULE_CONFLICT, "Entry ''{0}'' is already under version control", name);
            SVNErrorManager.error(err);
        } else if (schedule == null) {
            attributes.remove(SVNProperty.shortPropertyName("svn:entry:schedule"));
        }
    }

    public void modifyEntry(String name, Map attributes, boolean save, boolean force) throws SVNException {
        if (name == null) {
            name = this.getThisDirName();
        }
        boolean deleted = false;
        if (attributes.containsKey(SVNProperty.shortPropertyName("svn:entry:schedule"))) {
            SVNEntry entryBefore = this.getEntry(name, true);
            this.foldScheduling(name, attributes, force);
            SVNEntry entryAfter = this.getEntry(name, true);
            if (entryBefore != null && entryAfter == null) {
                deleted = true;
            }
        }
        if (!deleted) {
            SVNEntry rootEntry;
            SVNEntry entry = this.getEntry(name, true);
            if (entry == null) {
                entry = this.addEntry(name);
            }
            Map entryAttrs = entry.asMap();
            Iterator atts = attributes.keySet().iterator();
            while (atts.hasNext()) {
                String attName = (String)atts.next();
                String value = (String)attributes.get(attName);
                if ("cachable-props".equals(attName) || "present-props".equals(attName)) {
                    String[] propsArray = SVNAdminArea.fromString(value, " ");
                    entryAttrs.put(attName, propsArray);
                    continue;
                }
                if (!"has-props".equals(attName) && !"has-prop-mods".equals(attName)) {
                    attName = "svn:entry:" + attName;
                }
                if (value != null) {
                    entryAttrs.put(attName, value);
                    continue;
                }
                entryAttrs.remove(attName);
            }
            if (!entry.isDirectory() && (rootEntry = this.getEntry(this.getThisDirName(), true)) != null) {
                if (!SVNRevision.isValidRevisionNumber(entry.getRevision())) {
                    entry.setRevision(rootEntry.getRevision());
                }
                if (entry.getURL() == null) {
                    entry.setURL(SVNPathUtil.append(rootEntry.getURL(), SVNEncodingUtil.uriEncode(name)));
                }
                if (entry.getRepositoryRoot() == null) {
                    entry.setRepositoryRoot(rootEntry.getRepositoryRoot());
                }
                if (entry.getUUID() == null && !entry.isScheduledForAddition() && !entry.isScheduledForReplacement()) {
                    entry.setUUID(rootEntry.getUUID());
                }
                if (this.isEntryPropertyApplicable("cachable-props") && entry.getCachableProperties() == null) {
                    entry.setCachableProperties(rootEntry.getCachableProperties());
                }
            }
            if (attributes.containsKey(SVNProperty.shortPropertyName("svn:entry:schedule")) && entry.isScheduledForDeletion()) {
                entry.setCopied(false);
                entry.setCopyFromRevision(-1L);
                entry.setCopyFromURL(null);
            }
        }
        if (save) {
            this.saveEntries(false);
        }
    }

    public void deleteEntry(String name) throws SVNException {
        Map entries = this.loadEntries();
        if (entries != null) {
            entries.remove(name);
        }
    }

    public SVNEntry getEntry(String name, boolean hidden) throws SVNException {
        Map entries = this.loadEntries();
        if (entries != null && entries.containsKey(name)) {
            SVNEntry entry = (SVNEntry)entries.get(name);
            if (!hidden && entry.isHidden()) {
                return null;
            }
            return entry;
        }
        return null;
    }

    public SVNEntry addEntry(String name) throws SVNException {
        Map entries = this.loadEntries();
        if (entries == null) {
            this.myEntries = new HashMap();
            entries = this.myEntries;
        }
        SVNEntry entry = entries.containsKey(name) ? (SVNEntry)entries.get(name) : new SVNEntry(new HashMap(), this, name);
        entries.put(name, entry);
        return entry;
    }

    public Iterator entries(boolean hidden) throws SVNException {
        Map entries = this.loadEntries();
        if (entries == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        ArrayList copy = new ArrayList(entries.values());
        if (!hidden) {
            Iterator iterator = copy.iterator();
            while (iterator.hasNext()) {
                SVNEntry entry = (SVNEntry)iterator.next();
                if (!entry.isHidden()) continue;
                iterator.remove();
            }
        }
        Collections.sort(copy);
        return copy.iterator();
    }

    public Map getEntries() throws SVNException {
        return this.loadEntries();
    }

    public void cleanup() throws SVNException {
        this.getWCAccess().checkCancelled();
        Iterator entries = this.entries(false);
        while (entries.hasNext()) {
            SVNEntry entry = (SVNEntry)entries.next();
            if (entry.getKind() == SVNNodeKind.DIR && !this.getThisDirName().equals(entry.getName())) {
                File childDir = this.getFile(entry.getName());
                if (!childDir.isDirectory()) continue;
                try {
                    SVNAdminArea child = this.getWCAccess().open(childDir, true, true, 0);
                    child.cleanup();
                    continue;
                }
                catch (SVNException e) {
                    if (e instanceof SVNCancelException) {
                        throw e;
                    }
                    if (SVNAdminArea.isSafeCleanup()) {
                        SVNDebugLog.getDefaultLog().info("CLEANUP FAILED for " + childDir);
                        SVNDebugLog.getDefaultLog().info(e);
                        continue;
                    }
                    throw e;
                }
            }
            this.hasPropModifications(entry.getName());
            if (entry.getKind() != SVNNodeKind.FILE) continue;
            this.hasTextModifications(entry.getName(), false);
        }
        if (this.isKillMe()) {
            this.removeFromRevisionControl(this.getThisDirName(), true, false);
        } else {
            this.runLogs();
        }
        SVNFileUtil.deleteAll(this.getAdminFile("tmp"), false);
    }

    public boolean hasTextConflict(String name) throws SVNException {
        SVNEntry entry = this.getEntry(name, false);
        if (entry == null || entry.getKind() != SVNNodeKind.FILE) {
            return false;
        }
        boolean conflicted = false;
        if (entry.getConflictNew() != null) {
            boolean bl = conflicted = SVNFileType.getType(this.getFile(entry.getConflictNew())) == SVNFileType.FILE;
        }
        if (!conflicted && entry.getConflictWorking() != null) {
            boolean bl = conflicted = SVNFileType.getType(this.getFile(entry.getConflictWorking())) == SVNFileType.FILE;
        }
        if (!conflicted && entry.getConflictOld() != null) {
            conflicted = SVNFileType.getType(this.getFile(entry.getConflictOld())) == SVNFileType.FILE;
        }
        return conflicted;
    }

    public boolean hasPropConflict(String name) throws SVNException {
        SVNEntry entry = this.getEntry(name, false);
        if (entry != null && entry.getPropRejectFile() != null) {
            return SVNFileType.getType(this.getFile(entry.getPropRejectFile())) == SVNFileType.FILE;
        }
        return false;
    }

    public File getRoot() {
        return this.myDirectory;
    }

    public File getAdminDirectory() {
        return this.myAdminRoot;
    }

    public File getAdminFile(String name) {
        return new File(this.getAdminDirectory(), name);
    }

    public File getFile(String name) {
        if (name == null) {
            return null;
        }
        return new File(this.getRoot(), name);
    }

    public SVNWCAccess getWCAccess() {
        return this.myWCAccess;
    }

    public void setWCAccess(SVNWCAccess wcAccess) {
        this.myWCAccess = wcAccess;
    }

    public void closeVersionedProperties() {
        this.myProperties = null;
        this.myBaseProperties = null;
    }

    public void closeWCProperties() {
        this.myWCProperties = null;
    }

    public void closeEntries() {
        this.myEntries = null;
    }

    public File getBaseFile(String name, boolean tmp) {
        String path = tmp ? "tmp/" : "";
        path = path + "text-base/" + name + ".svn-base";
        return this.getAdminFile(path);
    }

    protected abstract void writeEntries(Writer var1) throws IOException;

    protected abstract int getFormatVersion();

    protected abstract Map fetchEntries() throws SVNException;

    protected SVNAdminArea(File dir) {
        this.myDirectory = dir;
        this.myAdminRoot = new File(dir, SVNFileUtil.getAdminDirectoryName());
    }

    protected File getBasePropertiesFile(String name, boolean tmp) {
        String path = !tmp ? "" : "tmp/";
        path = path + (this.getThisDirName().equals(name) ? "dir-prop-base" : "prop-base/" + name + ".svn-base");
        File propertiesFile = this.getAdminFile(path);
        return propertiesFile;
    }

    protected File getRevertPropertiesFile(String name, boolean tmp) {
        String path = !tmp ? "" : "tmp/";
        path = path + (this.getThisDirName().equals(name) ? "dir-prop-revert" : "prop-base/" + name + ".svn-revert");
        File propertiesFile = this.getAdminFile(path);
        return propertiesFile;
    }

    public File getPropertiesFile(String name, boolean tmp) {
        String path = !tmp ? "" : "tmp/";
        path = path + (this.getThisDirName().equals(name) ? "dir-props" : "props/" + name + ".svn-work");
        File propertiesFile = this.getAdminFile(path);
        return propertiesFile;
    }

    protected Map loadEntries() throws SVNException {
        if (this.myEntries != null) {
            return this.myEntries;
        }
        this.myEntries = this.fetchEntries();
        return this.myEntries;
    }

    protected Map getBasePropertiesStorage(boolean create) {
        if (this.myBaseProperties == null && create) {
            this.myBaseProperties = new HashMap();
        }
        return this.myBaseProperties;
    }

    protected Map getRevertPropertiesStorage(boolean create) {
        if (this.myRevertProperties == null && create) {
            this.myRevertProperties = new HashMap();
        }
        return this.myRevertProperties;
    }

    protected Map getPropertiesStorage(boolean create) {
        if (this.myProperties == null && create) {
            this.myProperties = new HashMap();
        }
        return this.myProperties;
    }

    protected Map getWCPropertiesStorage(boolean create) {
        if (this.myWCProperties == null && create) {
            this.myWCProperties = new HashMap();
        }
        return this.myWCProperties;
    }

    public static String asString(String[] array, String delimiter) {
        String str = null;
        if (array != null) {
            str = "";
            for (int i = 0; i < array.length; ++i) {
                str = str + array[i];
                if (i >= array.length - 1) continue;
                str = str + delimiter;
            }
        }
        return str;
    }

    public static String[] fromString(String str, String delimiter) {
        if (str == null) {
            return new String[0];
        }
        LinkedList<String> list = new LinkedList<String>();
        int startInd = 0;
        int ind = -1;
        while ((ind = str.indexOf(delimiter, startInd)) != -1) {
            list.add(str.substring(startInd, ind));
            for (startInd = ind; startInd < str.length() && str.charAt(startInd) == ' '; ++startInd) {
            }
        }
        if (startInd < str.length()) {
            list.add(str.substring(startInd));
        }
        return list.toArray(new String[list.size()]);
    }

    private void destroyAdminArea() throws SVNException {
        if (!this.isLocked()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Write-lock stolen in ''{0}''", this.getRoot());
            SVNErrorManager.error(err);
        }
        SVNFileUtil.deleteAll(this.getAdminDirectory(), this.getWCAccess());
        this.getWCAccess().closeAdminArea(this.getRoot());
    }

    public void commit(String target, SVNCommitInfo info, Map wcPropChanges, boolean removeLock, boolean recursive, Collection explicitCommitPaths, ISVNCommitParameters params) throws SVNException {
        SVNEntry entry;
        SVNAdminArea anchor = this.getWCAccess().retrieve(this.getWCAccess().getAnchor());
        String path = this.getRelativePath(anchor);
        String string = path = "".equals(target) ? path : SVNPathUtil.append(path, target);
        if (!explicitCommitPaths.contains(path) && (entry = this.getEntry(target, true)) != null && entry.getCopyFromURL() != null) {
            return;
        }
        SVNLog log = this.getLog();
        String checksum = null;
        HashMap<String, String> command = new HashMap<String, String>();
        if (!"".equals(target)) {
            File baseFile = this.getBaseFile(target, true);
            SVNFileType baseType = SVNFileType.getType(baseFile);
            if (baseType == SVNFileType.NONE) {
                baseFile = this.getBaseFile(target, false);
                baseType = SVNFileType.getType(baseFile);
            }
            if (baseType == SVNFileType.FILE) {
                checksum = SVNFileUtil.computeChecksum(baseFile);
            }
            File textRevertFile = this.getFile(SVNAdminUtil.getTextRevertPath(target, false));
            File propRevertFile = this.getFile(SVNAdminUtil.getPropRevertPath(target, SVNNodeKind.FILE, false));
            if (textRevertFile.isFile()) {
                command.put("name", SVNAdminUtil.getTextRevertPath(target, false));
                log.addCommand("rm", command, false);
                command.clear();
            }
            if (propRevertFile.isFile()) {
                command.put("name", SVNAdminUtil.getPropRevertPath(target, SVNNodeKind.FILE, false));
                log.addCommand("rm", command, false);
                command.clear();
            }
            command.clear();
            recursive = false;
        }
        if (info != null) {
            command.put("name", target);
            command.put(SVNProperty.shortPropertyName("svn:entry:committed-rev"), Long.toString(info.getNewRevision()));
            command.put(SVNProperty.shortPropertyName("svn:entry:committed-date"), SVNTimeUtil.formatDate(info.getDate()));
            command.put(SVNProperty.shortPropertyName("svn:entry:last-author"), info.getAuthor());
            log.addCommand("modify-entry", command, false);
            command.clear();
        }
        if (checksum != null) {
            command.put("name", target);
            command.put(SVNProperty.shortPropertyName("svn:entry:checksum"), checksum);
            log.addCommand("modify-entry", command, false);
            command.clear();
        }
        if (removeLock) {
            command.put("name", target);
            log.addCommand("delete-lock", command, false);
            command.clear();
        }
        command.put("name", target);
        command.put("revision", info == null ? null : Long.toString(info.getNewRevision()));
        if (!explicitCommitPaths.contains(path)) {
            command.put("implicit", "true");
        }
        log.addCommand("committed", command, false);
        command.clear();
        if (wcPropChanges != null && !wcPropChanges.isEmpty()) {
            Iterator propNames = wcPropChanges.keySet().iterator();
            while (propNames.hasNext()) {
                String propName = (String)propNames.next();
                String propValue = (String)wcPropChanges.get(propName);
                command.put("name", target);
                command.put("propname", propName);
                command.put("propval", propValue);
                log.addCommand("modify-wcprop", command, false);
                command.clear();
            }
        }
        log.save();
        this.runLogs();
        if (recursive) {
            Iterator ents = this.entries(true);
            while (ents.hasNext()) {
                SVNEntry entry2 = (SVNEntry)ents.next();
                if ("".equals(entry2.getName())) continue;
                if (entry2.getKind() == SVNNodeKind.DIR) {
                    File childPath = this.getFile(entry2.getName());
                    SVNAdminArea childDir = this.getWCAccess().retrieve(childPath);
                    if (childDir == null) continue;
                    childDir.commit("", info, null, removeLock, true, explicitCommitPaths, params);
                    continue;
                }
                this.commit(entry2.getName(), info, null, removeLock, false, explicitCommitPaths, params);
            }
        }
    }

    protected void setLocked(boolean locked) {
        this.myWasLocked = locked;
    }

    public void setCommitParameters(ISVNCommitParameters commitParameters) {
        this.myCommitParameters = commitParameters;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

