/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaCombiner;
import org.tmatesoft.svn.core.internal.io.fs.FSClosestCopy;
import org.tmatesoft.svn.core.internal.io.fs.FSCommitEditor;
import org.tmatesoft.svn.core.internal.io.fs.FSEntry;
import org.tmatesoft.svn.core.internal.io.fs.FSErrors;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSHooks;
import org.tmatesoft.svn.core.internal.io.fs.FSInputStream;
import org.tmatesoft.svn.core.internal.io.fs.FSNodeHistory;
import org.tmatesoft.svn.core.internal.io.fs.FSParentPath;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSSoftCache;
import org.tmatesoft.svn.core.internal.io.fs.FSUpdateContext;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNTimeUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNFileRevisionHandler;
import org.tmatesoft.svn.core.io.ISVNLocationEntryHandler;
import org.tmatesoft.svn.core.io.ISVNLockHandler;
import org.tmatesoft.svn.core.io.ISVNReporter;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.ISVNSession;
import org.tmatesoft.svn.core.io.ISVNWorkspaceMediator;
import org.tmatesoft.svn.core.io.SVNFileRevision;
import org.tmatesoft.svn.core.io.SVNLocationEntry;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;

public class FSRepository
extends SVNRepository
implements ISVNReporter {
    public static final int SVN_INVALID_REVNUM = -1;
    private FSSoftCache myRootCache;
    private File myReposRootDir;
    private FSUpdateContext myReporterContext;
    private FSFS myFSFS;
    private boolean myIsUseRootCache;

    protected FSRepository(SVNURL location, ISVNSession options) {
        super(location, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnection() throws SVNException {
        try {
            this.openRepository();
        }
        finally {
            this.closeRepository();
        }
    }

    private void openRepository() throws SVNException {
        try {
            this.openRepositoryRoot();
        }
        catch (SVNException svne) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_LOCAL_REPOS_OPEN_FAILED, "Unable to open repository ''{0}''", this.getLocation().toDecodedString());
            err.setChildErrorMessage(svne.getErrorMessage());
            SVNErrorManager.error(err.wrap("Unable to open an ra_local session to URL"));
        }
    }

    private void openRepositoryRoot() throws SVNException {
        String startPath;
        String rootPath;
        boolean hasCustomHostName;
        this.lock();
        String hostName = this.getLocation().getHost();
        boolean bl = hasCustomHostName = !"".equals(hostName) && !"localhost".equalsIgnoreCase(hostName);
        if (!SVNFileUtil.isWindows && hasCustomHostName) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "Local URL ''{0}'' contains unsupported hostname", this.getLocation().toDecodedString());
            SVNErrorManager.error(err);
        }
        if ((rootPath = FSFS.findRepositoryRoot(hasCustomHostName ? hostName : null, startPath = SVNEncodingUtil.uriDecode(this.getLocation().getURIEncodedPath()))) == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_LOCAL_REPOS_OPEN_FAILED, "Unable to open repository ''{0}''", this.getLocation().toDecodedString());
            SVNErrorManager.error(err);
        }
        this.myReposRootDir = hasCustomHostName ? new File("\\\\" + hostName, rootPath).getAbsoluteFile() : new File(rootPath).getAbsoluteFile();
        this.myFSFS = new FSFS(this.myReposRootDir);
        this.myFSFS.open();
        this.setRepositoryCredentials(this.myFSFS.getUUID(), this.getLocation().setPath(rootPath, false));
    }

    void closeRepository() {
        this.unlock();
    }

    public File getRepositoryRootDir() {
        return this.myReposRootDir;
    }

    public int getReposFormat() {
        return this.myFSFS.getReposFormat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLatestRevision() throws SVNException {
        try {
            this.openRepository();
            long l = this.myFSFS.getYoungestRevision();
            return l;
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDatedRevision(Date date) throws SVNException {
        if (date == null) {
            return this.getLatestRevision();
        }
        try {
            this.openRepository();
            long l = this.myFSFS.getDatedRevision(date);
            return l;
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getRevisionProperties(long revision, Map properties) throws SVNException {
        FSRepository.assertValidRevision(revision);
        try {
            this.openRepository();
            properties = properties == null ? new HashMap() : properties;
            properties.putAll(this.myFSFS.getRevisionProperties(revision));
        }
        finally {
            this.closeRepository();
        }
        return properties;
    }

    public void setRevisionPropertyValue(long revision, String propertyName, String propertyValue) throws SVNException {
        this.setRevisionPropertyValue(revision, propertyName, propertyValue, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRevisionPropertyValue(long revision, String propertyName, String propertyValue, boolean bypassHooks) throws SVNException {
        FSRepository.assertValidRevision(revision);
        try {
            this.openRepository();
            if (!SVNProperty.isRegularProperty(propertyName)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.REPOS_BAD_ARGS, "Storage of non-regular property ''{0}'' is disallowed through the repository interface, and could indicate a bug in your client", propertyName);
                SVNErrorManager.error(err);
            }
            String userName = this.getUserName();
            Map revProps = this.myFSFS.getRevisionProperties(revision);
            String oldValue = (String)revProps.get(propertyName);
            String action = null;
            action = propertyValue == null ? "D" : (oldValue == null ? "A" : "M");
            if (FSHooks.isHooksEnabled() && !bypassHooks) {
                FSHooks.runPreRevPropChangeHook(this.myReposRootDir, propertyName, propertyValue, userName, revision, action);
            }
            this.myFSFS.setRevisionProperty(revision, propertyName, propertyValue);
            if (FSHooks.isHooksEnabled() && !bypassHooks) {
                FSHooks.runPostRevPropChangeHook(this.myReposRootDir, propertyName, propertyValue, userName, revision, action);
            }
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRevisionPropertyValue(long revision, String propertyName) throws SVNException {
        FSRepository.assertValidRevision(revision);
        if (propertyName == null) {
            return null;
        }
        try {
            this.openRepository();
            String string = (String)this.myFSFS.getRevisionProperties(revision).get(propertyName);
            return string;
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNNodeKind checkPath(String path, long revision) throws SVNException {
        try {
            this.openRepository();
            if (!SVNRepository.isValidRevision(revision)) {
                revision = this.myFSFS.getYoungestRevision();
            }
            String repositoryPath = this.getRepositoryPath(path);
            FSRevisionRoot root = this.createRevisionRoot(revision);
            SVNNodeKind sVNNodeKind = root.checkNodeKind(repositoryPath);
            return sVNNodeKind;
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFile(String path, long revision, Map properties, OutputStream contents) throws SVNException {
        try {
            this.openRepository();
            if (!SVNRepository.isValidRevision(revision)) {
                revision = this.myFSFS.getYoungestRevision();
            }
            String repositoryPath = this.getRepositoryPath(path);
            FSRevisionRoot root = this.createRevisionRoot(revision);
            if (contents != null) {
                InputStream fileStream = null;
                try {
                    fileStream = root.getFileStreamForPath(new SVNDeltaCombiner(), repositoryPath);
                    FSRepositoryUtil.copy(fileStream, contents);
                }
                catch (Throwable throwable) {
                    SVNFileUtil.closeFile(fileStream);
                    throw throwable;
                }
                SVNFileUtil.closeFile(fileStream);
            }
            if (properties != null) {
                FSRevisionNode revNode = root.getRevisionNode(repositoryPath);
                if (revNode.getFileChecksum() != null) {
                    properties.put("svn:entry:checksum", revNode.getFileChecksum());
                }
                if (revision >= 0L) {
                    properties.put("svn:entry:revision", Long.toString(revision));
                }
                properties.putAll(this.collectProperties(revNode));
            }
            long l = revision;
            return l;
        }
        finally {
            this.closeRepository();
        }
    }

    private Collection getDirEntries(FSRevisionNode parent, SVNURL parentURL, boolean includeLogs) throws SVNException {
        Map entries = parent.getDirEntries(this.myFSFS);
        Set keys = entries.keySet();
        Iterator dirEntries = keys.iterator();
        LinkedList<SVNDirEntry> dirEntriesList = new LinkedList<SVNDirEntry>();
        while (dirEntries.hasNext()) {
            String name = (String)dirEntries.next();
            FSEntry repEntry = (FSEntry)entries.get(name);
            if (repEntry == null) continue;
            dirEntriesList.add(this.buildDirEntry(repEntry, parentURL, null, includeLogs));
        }
        return dirEntriesList;
    }

    private Map collectProperties(FSRevisionNode revNode) throws SVNException {
        HashMap properties = new HashMap();
        Map versionedProps = revNode.getProperties(this.myFSFS);
        if (versionedProps != null && versionedProps.size() > 0) {
            properties.putAll(versionedProps);
        }
        Map metaprops = null;
        try {
            metaprops = this.myFSFS.compoundMetaProperties(revNode.getCreatedRevision());
        }
        catch (SVNException svne) {
            // empty catch block
        }
        if (metaprops != null && metaprops.size() > 0) {
            properties.putAll(metaprops);
        }
        return properties;
    }

    private SVNDirEntry buildDirEntry(FSEntry repEntry, SVNURL parentURL, FSRevisionNode entryNode, boolean includeLogs) throws SVNException {
        entryNode = entryNode == null ? this.myFSFS.getRevisionNode(repEntry.getId()) : entryNode;
        long size = 0L;
        if (entryNode.getType() == SVNNodeKind.FILE) {
            size = entryNode.getFileLength();
        }
        Map props = null;
        props = entryNode.getProperties(this.myFSFS);
        boolean hasProps = props != null && props.size() != 0;
        Map revProps = null;
        revProps = this.myFSFS.getRevisionProperties(repEntry.getId().getRevision());
        String lastAuthor = null;
        String log = null;
        Date lastCommitDate = null;
        if (revProps != null && revProps.size() > 0) {
            lastAuthor = (String)revProps.get("svn:author");
            log = (String)revProps.get("svn:log");
            String timeString = (String)revProps.get("svn:date");
            lastCommitDate = timeString != null ? SVNTimeUtil.parseDateString(timeString) : null;
        }
        SVNURL entryURL = parentURL.appendPath(repEntry.getName(), false);
        SVNDirEntry dirEntry = new SVNDirEntry(entryURL, repEntry.getName(), repEntry.getType(), size, hasProps, repEntry.getId().getRevision(), lastCommitDate, lastAuthor, includeLogs ? log : null);
        dirEntry.setRelativePath(repEntry.getName());
        return dirEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDir(String path, long revision, Map properties, ISVNDirEntryHandler handler) throws SVNException {
        try {
            this.openRepository();
            if (!SVNRepository.isValidRevision(revision)) {
                revision = this.myFSFS.getYoungestRevision();
            }
            String repositoryPath = this.getRepositoryPath(path);
            FSRevisionRoot root = this.createRevisionRoot(revision);
            FSRevisionNode parent = root.getRevisionNode(repositoryPath);
            if (handler != null) {
                SVNURL parentURL = this.getLocation().appendPath(path, false);
                Collection entriesCollection = this.getDirEntries(parent, parentURL, false);
                Iterator entries = entriesCollection.iterator();
                while (entries.hasNext()) {
                    SVNDirEntry entry = (SVNDirEntry)entries.next();
                    handler.handleDirEntry(entry);
                }
            }
            if (properties != null) {
                properties.putAll(this.collectProperties(parent));
            }
            long l = revision;
            return l;
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNDirEntry getDir(String path, long revision, boolean includeCommitMessages, Collection entries) throws SVNException {
        try {
            SVNDirEntry parentDirEntry;
            this.openRepository();
            if (!SVNRepository.isValidRevision(revision)) {
                revision = this.myFSFS.getYoungestRevision();
            }
            String repositoryPath = this.getRepositoryPath(path);
            SVNURL parentURL = this.getLocation().appendPath(path, false);
            FSRevisionRoot root = this.createRevisionRoot(revision);
            FSRevisionNode parent = root.getRevisionNode(repositoryPath);
            if (entries != null) {
                entries.addAll(this.getDirEntries(parent, parentURL, includeCommitMessages));
            }
            SVNDirEntry sVNDirEntry = parentDirEntry = this.buildDirEntry(new FSEntry(parent.getId(), parent.getType(), ""), parentURL, parent, false);
            return sVNDirEntry;
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFileRevisions(String path, long startRevision, long endRevision, ISVNFileRevisionHandler handler) throws SVNException {
        try {
            this.openRepository();
            path = this.getRepositoryPath(path);
            startRevision = FSRepository.isInvalidRevision(startRevision) ? this.myFSFS.getYoungestRevision() : startRevision;
            endRevision = FSRepository.isInvalidRevision(endRevision) ? this.myFSFS.getYoungestRevision() : endRevision;
            FSRevisionRoot root = this.createRevisionRoot(endRevision);
            if (root.checkNodeKind(path) != SVNNodeKind.FILE) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FILE, "''{0}'' is not a file", path);
                SVNErrorManager.error(err);
            }
            LinkedList<SVNLocationEntry> locationEntries = new LinkedList<SVNLocationEntry>();
            FSNodeHistory history = FSNodeHistory.getNodeHistory(root, path);
            while ((history = history.fsHistoryPrev(true, this.myFSFS)) != null) {
                long histRev = history.getHistoryEntry().getRevision();
                String histPath = history.getHistoryEntry().getPath();
                locationEntries.addFirst(new SVNLocationEntry(histRev, histPath));
                if (histRev > startRevision) continue;
                break;
            }
            if (locationEntries.size() == 0) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "FATAL error: there're no file revisions to get");
                SVNErrorManager.error(err);
            }
            FSRevisionRoot lastRoot = null;
            String lastPath = null;
            Map lastProps = new HashMap();
            ListIterator locations = locationEntries.listIterator();
            while (locations.hasNext()) {
                Map props;
                String revPath;
                block9: {
                    block10: {
                        SVNLocationEntry location = (SVNLocationEntry)locations.next();
                        long rev = location.getRevision();
                        revPath = location.getPath();
                        Map revProps = this.myFSFS.getRevisionProperties(rev);
                        root = this.createRevisionRoot(rev);
                        FSRevisionNode fileNode = root.getRevisionNode(revPath);
                        props = fileNode.getProperties(this.myFSFS);
                        Map propDiffs = FSRepositoryUtil.getPropsDiffs(lastProps, props);
                        boolean contentsChanged = false;
                        contentsChanged = lastRoot != null ? FSRepositoryUtil.areFileContentsChanged(lastRoot, lastPath, root, revPath) : true;
                        if (handler == null) break block9;
                        handler.openRevision(new SVNFileRevision(revPath, rev, revProps, propDiffs));
                        if (!contentsChanged) break block10;
                        SVNDeltaCombiner sourceCombiner = new SVNDeltaCombiner();
                        SVNDeltaCombiner targetCombiner = new SVNDeltaCombiner();
                        handler.applyTextDelta(path, null);
                        InputStream sourceStream = null;
                        InputStream targetStream = null;
                        try {
                            sourceStream = lastRoot != null && lastPath != null ? lastRoot.getFileStreamForPath(sourceCombiner, lastPath) : FSInputStream.createDeltaStream(sourceCombiner, (FSRevisionNode)null, this.myFSFS);
                            targetStream = root.getFileStreamForPath(targetCombiner, revPath);
                            SVNDeltaGenerator deltaGenerator = new SVNDeltaGenerator();
                            deltaGenerator.sendDelta(path, sourceStream, 0L, targetStream, handler, false);
                        }
                        catch (Throwable throwable) {
                            SVNFileUtil.closeFile(sourceStream);
                            SVNFileUtil.closeFile(targetStream);
                            throw throwable;
                        }
                        SVNFileUtil.closeFile(sourceStream);
                        SVNFileUtil.closeFile(targetStream);
                        handler.closeRevision(path);
                        break block9;
                    }
                    handler.closeRevision(path);
                }
                lastRoot = root;
                lastPath = revPath;
                lastProps = props;
            }
            int n = locationEntries.size();
            return n;
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long log(String[] targetPaths, long startRevision, long endRevision, boolean discoverChangedPaths, boolean strictNode, long limit, ISVNLogEntryHandler handler) throws SVNException {
        try {
            SVNErrorMessage err;
            this.openRepository();
            if (targetPaths == null || targetPaths.length == 0) {
                targetPaths = new String[]{""};
            }
            String[] absPaths = new String[targetPaths.length];
            for (int i = 0; i < targetPaths.length; ++i) {
                absPaths[i] = this.getRepositoryPath(targetPaths[i]);
            }
            long youngestRev = this.myFSFS.getYoungestRevision();
            if (FSRepository.isInvalidRevision(startRevision)) {
                startRevision = youngestRev;
            }
            if (FSRepository.isInvalidRevision(endRevision)) {
                endRevision = youngestRev;
            }
            long histStart = startRevision;
            long histEnd = endRevision;
            if (startRevision > youngestRev) {
                err = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_REVISION, "No such revision {0,number,integer}", new Long(startRevision));
                SVNErrorManager.error(err);
            }
            if (endRevision > youngestRev) {
                err = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_REVISION, "No such revision {0,number,integer}", new Long(endRevision));
                SVNErrorManager.error(err);
            }
            if (startRevision > endRevision) {
                histStart = endRevision;
                histEnd = startRevision;
            }
            long sendCount = 0L;
            if (absPaths.length == 1 && "/".equals(absPaths[0])) {
                sendCount = histEnd - histStart + 1L;
                if (limit != 0L && sendCount > limit) {
                    sendCount = limit;
                }
                int i22 = 0;
                while ((long)i22 < sendCount) {
                    long rev = histStart + (long)i22;
                    if (startRevision > endRevision) {
                        rev = histEnd - (long)i22;
                    }
                    if (handler != null) {
                        this.sendChanges(rev, discoverChangedPaths, handler);
                    }
                    ++i22;
                }
                long i22 = sendCount;
                return i22;
            }
            LinkedList<LogPathInfo> histories = new LinkedList<LogPathInfo>();
            FSRevisionRoot root = this.createRevisionRoot(histEnd);
            for (int i = 0; i < absPaths.length; ++i) {
                String path = absPaths[i];
                FSNodeHistory hist = FSNodeHistory.getNodeHistory(root, path);
                LogPathInfo info = new LogPathInfo(hist);
                info.pickUpNextHistory(strictNode, histStart);
                histories.addLast(info);
            }
            LinkedList<Long> revisions = null;
            boolean anyHistoriesLeft = true;
            long currentRev = histEnd;
            while (currentRev >= histStart && anyHistoriesLeft) {
                boolean changed = false;
                anyHistoriesLeft = false;
                ListIterator infoes = histories.listIterator();
                while (infoes.hasNext()) {
                    LogPathInfo info = (LogPathInfo)infoes.next();
                    if (info.checkHistory(currentRev, strictNode, histStart)) {
                        changed = true;
                    }
                    if (info.getHistory() == null) continue;
                    anyHistoriesLeft = true;
                }
                if (changed) {
                    if (startRevision > endRevision) {
                        if (handler != null) {
                            this.sendChanges(currentRev, discoverChangedPaths, handler);
                        }
                        if (limit != 0L && ++sendCount >= limit) {
                            break;
                        }
                    } else {
                        if (revisions == null) {
                            revisions = new LinkedList<Long>();
                        }
                        revisions.addFirst(new Long(currentRev));
                    }
                }
                currentRev = this.getNextHistoryRevision(histories);
            }
            if (revisions != null) {
                int i = 0;
                ListIterator revs = revisions.listIterator();
                while (revs.hasNext()) {
                    this.sendChanges((Long)revs.next(), discoverChangedPaths, handler);
                    if (limit == 0L || (long)(++i) < limit) continue;
                }
                long l = i;
                return l;
            }
            long l = sendCount;
            return l;
        }
        finally {
            this.closeRepository();
        }
    }

    private long getNextHistoryRevision(LinkedList histories) {
        long nextRevision = -1L;
        ListIterator infoes = histories.listIterator();
        while (infoes.hasNext()) {
            long historyRevision;
            LogPathInfo info = (LogPathInfo)infoes.next();
            if (info.getHistory() == null || (historyRevision = info.getHistoryRevision()) <= nextRevision) continue;
            nextRevision = historyRevision;
        }
        return nextRevision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLocations(String path, long pegRevision, long[] revisions, ISVNLocationEntryHandler handler) throws SVNException {
        FSRepository.assertValidRevision(pegRevision);
        for (int i = 0; i < revisions.length; ++i) {
            FSRepository.assertValidRevision(revisions[i]);
        }
        try {
            FSRevisionRoot croot;
            FSClosestCopy tempClCopy;
            this.openRepository();
            path = this.getRepositoryPath(path);
            ArrayList<SVNLocationEntry> locationEntries = new ArrayList<SVNLocationEntry>(0);
            long[] locationRevs = new long[revisions.length];
            Arrays.sort(revisions);
            for (int i = 0; i < revisions.length; ++i) {
                locationRevs[i] = revisions[revisions.length - (i + 1)];
            }
            int count = 0;
            boolean isAncestor = false;
            for (count = 0; count < locationRevs.length && locationRevs[count] > pegRevision && !(isAncestor = FSNodeHistory.checkAncestryOfPegPath(path, pegRevision, locationRevs[count], this.myFSFS)); ++count) {
            }
            if (count >= locationRevs.length) {
                int n = 0;
                return n;
            }
            long revision = isAncestor ? locationRevs[count] : pegRevision;
            FSRevisionRoot root = null;
            while (count < revisions.length && (tempClCopy = this.closestCopy(root = this.createRevisionRoot(revision), path)) != null && (croot = tempClCopy.getRevisionRoot()) != null) {
                String cpath = tempClCopy.getPath();
                long crev = croot.getRevision();
                while (count < revisions.length && locationRevs[count] >= crev) {
                    locationEntries.add(new SVNLocationEntry(locationRevs[count], path));
                    ++count;
                }
                FSRevisionNode copyfromNode = croot.getRevisionNode(cpath);
                String copyfromPath = copyfromNode.getCopyFromPath();
                long copyfromRevision = copyfromNode.getCopyFromRevision();
                while (count < revisions.length && locationRevs[count] > copyfromRevision) {
                    ++count;
                }
                String remainder = path.equals(cpath) ? "" : SVNPathUtil.pathIsChild(cpath, path);
                path = SVNPathUtil.concatToAbs(copyfromPath, remainder);
                revision = copyfromRevision;
            }
            root = this.createRevisionRoot(revision);
            FSRevisionNode curNode = root.getRevisionNode(path);
            while (count < revisions.length && (root = this.myFSFS.createRevisionRoot(locationRevs[count])).checkNodeKind(path) != SVNNodeKind.NONE) {
                FSRevisionNode currentNode = root.getRevisionNode(path);
                if (!curNode.getId().isRelated(currentNode.getId())) break;
                locationEntries.add(new SVNLocationEntry(locationRevs[count], path));
                ++count;
            }
            for (count = 0; count < locationEntries.size(); ++count) {
                if (handler == null) continue;
                handler.handleLocationEntry((SVNLocationEntry)locationEntries.get(count));
            }
            int n = count;
            return n;
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replay(long lowRevision, long highRevision, boolean sendDeltas, ISVNEditor editor) throws SVNException {
        try {
            this.openRepository();
            FSRevisionRoot root = this.createRevisionRoot(highRevision);
            String basePath = this.getRepositoryPath("");
            FSRepositoryUtil.replay(this.myFSFS, root, basePath, lowRevision, sendDeltas, editor);
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void diff(SVNURL url, long revision, String target, boolean ignoreAncestry, boolean recursive, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        try {
            this.openRepository();
            this.makeReporterContext(revision, target, url, recursive, ignoreAncestry, true, editor);
            reporter.report(this);
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void diff(SVNURL url, long targetRevision, long revision, String target, boolean ignoreAncestry, boolean recursive, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        try {
            this.openRepository();
            this.makeReporterContext(targetRevision, target, url, recursive, ignoreAncestry, true, editor);
            reporter.report(this);
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void diff(SVNURL url, long targetRevision, long revision, String target, boolean ignoreAncestry, boolean recursive, boolean getContents, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        try {
            this.openRepository();
            this.makeReporterContext(targetRevision, target, url, recursive, ignoreAncestry, getContents, editor);
            reporter.report(this);
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(long revision, String target, boolean recursive, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        try {
            this.openRepository();
            this.makeReporterContext(revision, target, null, recursive, false, true, editor);
            reporter.report(this);
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void status(long revision, String target, boolean recursive, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        try {
            this.openRepository();
            this.makeReporterContext(revision, target, null, recursive, false, false, editor);
            reporter.report(this);
        }
        finally {
            this.closeRepository();
        }
    }

    private void makeReporterContext(long targetRevision, String target, SVNURL switchURL, boolean recursive, boolean ignoreAncestry, boolean textDeltas, ISVNEditor editor) throws SVNException {
        String fullTargetPath;
        String string = target = target == null ? "" : target;
        if (!FSRepository.isValidRevision(targetRevision)) {
            targetRevision = this.myFSFS.getYoungestRevision();
        }
        String switchPath = null;
        if (switchURL != null) {
            SVNURL reposRootURL = this.getRepositoryRoot(false);
            if (switchURL.toDecodedString().indexOf(reposRootURL.toDecodedString()) == -1) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "''{0}''\nis not the same repository as\n''{1}''", new Object[]{switchURL, this.getRepositoryRoot(false)});
                SVNErrorManager.error(err);
            }
            if ("".equals(switchPath = switchURL.toDecodedString().substring(reposRootURL.toDecodedString().length()))) {
                switchPath = "/";
            }
        }
        String anchor = this.getRepositoryPath("");
        String string2 = fullTargetPath = switchPath != null ? switchPath : SVNPathUtil.concatToAbs(anchor, target);
        if (this.myReporterContext == null) {
            this.myReporterContext = new FSUpdateContext(this, this.myFSFS, targetRevision, SVNFileUtil.createTempFile("report", ".tmp"), target, fullTargetPath, switchURL != null, recursive, ignoreAncestry, textDeltas, editor);
        } else {
            this.myReporterContext.reset(this, this.myFSFS, targetRevision, SVNFileUtil.createTempFile("report", ".tmp"), target, fullTargetPath, switchURL != null, recursive, ignoreAncestry, textDeltas, editor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(SVNURL url, long revision, String target, boolean recursive, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        try {
            this.openRepository();
            this.makeReporterContext(revision, target, url, recursive, true, true, editor);
            reporter.report(this);
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNDirEntry info(String path, long revision) throws SVNException {
        try {
            SVNDirEntry entry;
            FSRevisionRoot root;
            this.openRepository();
            path = this.getRepositoryPath(path);
            if (FSRepository.isInvalidRevision(revision)) {
                revision = this.myFSFS.getYoungestRevision();
            }
            if ((root = this.createRevisionRoot(revision)).checkNodeKind(path) == SVNNodeKind.NONE) {
                SVNDirEntry sVNDirEntry = null;
                return sVNDirEntry;
            }
            FSRevisionNode revNode = root.getRevisionNode(path);
            String fullPath = this.getFullPath(path);
            String parentFullPath = "/".equals(path) ? fullPath : SVNPathUtil.removeTail(fullPath);
            SVNURL url = this.getLocation().setPath(parentFullPath, false);
            String name = SVNPathUtil.tail(path);
            FSEntry fsEntry = new FSEntry(revNode.getId(), revNode.getType(), name);
            SVNDirEntry sVNDirEntry = entry = this.buildDirEntry(fsEntry, url, revNode, false);
            return sVNDirEntry;
        }
        finally {
            this.closeRepository();
        }
    }

    public ISVNEditor getCommitEditor(String logMessage, Map locks, boolean keepLocks, ISVNWorkspaceMediator mediator) throws SVNException {
        try {
            this.openRepository();
        }
        catch (SVNException svne) {
            this.closeRepository();
            throw svne;
        }
        String author = this.getUserName();
        FSCommitEditor commitEditor = new FSCommitEditor(this.getRepositoryPath(""), logMessage, author, locks, keepLocks, null, this.myFSFS, this);
        return commitEditor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNLock getLock(String path) throws SVNException {
        try {
            SVNLock lock;
            this.openRepository();
            path = this.getRepositoryPath(path);
            SVNLock sVNLock = lock = this.myFSFS.getLockHelper(path, false);
            return sVNLock;
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNLock[] getLocks(String path) throws SVNException {
        try {
            this.openRepository();
            path = this.getRepositoryPath(path);
            File digestFile = this.myFSFS.getDigestFileFromRepositoryPath(path);
            final ArrayList locks = new ArrayList();
            ISVNLockHandler handler = new ISVNLockHandler(){

                public void handleLock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
                    locks.add(lock);
                }

                public void handleUnlock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
                }
            };
            this.myFSFS.walkDigestFiles(digestFile, handler, false);
            SVNLock[] sVNLockArray = locks.toArray(new SVNLock[locks.size()]);
            return sVNLockArray;
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Map pathsToRevisions, String comment, boolean force, ISVNLockHandler handler) throws SVNException {
        try {
            this.openRepository();
            Iterator paths = pathsToRevisions.keySet().iterator();
            while (paths.hasNext()) {
                SVNErrorMessage error;
                SVNLock lock;
                String reposPath;
                block6: {
                    String path = (String)paths.next();
                    Long revision = (Long)pathsToRevisions.get(path);
                    reposPath = this.getRepositoryPath(path);
                    long curRevision = revision == null || FSRepository.isInvalidRevision(revision) ? this.myFSFS.getYoungestRevision() : revision.longValue();
                    lock = null;
                    error = null;
                    try {
                        lock = this.myFSFS.lockPath(reposPath, null, this.getUserName(), comment, null, curRevision, force);
                    }
                    catch (SVNException svne) {
                        error = svne.getErrorMessage();
                        if (FSErrors.isLockError(error)) break block6;
                        throw svne;
                    }
                }
                if (handler == null) continue;
                handler.handleLock(reposPath, lock, error);
            }
        }
        finally {
            this.closeRepository();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(Map pathToTokens, boolean force, ISVNLockHandler handler) throws SVNException {
        try {
            this.openRepository();
            Iterator paths = pathToTokens.keySet().iterator();
            while (paths.hasNext()) {
                SVNErrorMessage error;
                String reposPath;
                String token;
                block6: {
                    String path = (String)paths.next();
                    token = (String)pathToTokens.get(path);
                    reposPath = this.getRepositoryPath(path);
                    error = null;
                    try {
                        this.myFSFS.unlockPath(reposPath, token, this.getUserName(), force, true);
                    }
                    catch (SVNException svne) {
                        error = svne.getErrorMessage();
                        if (FSErrors.isUnlockError(error)) break block6;
                        throw svne;
                    }
                }
                if (handler == null) continue;
                handler.handleUnlock(reposPath, new SVNLock(reposPath, token, null, null, null, null), error);
            }
        }
        finally {
            this.closeRepository();
        }
    }

    private void sendChanges(long revNum, boolean discoverChangedPaths, ISVNLogEntryHandler handler) throws SVNException {
        Map revisionProps = this.myFSFS.getRevisionProperties(revNum);
        Map changedPaths = null;
        String author = null;
        Date date = null;
        String message = null;
        if (revisionProps != null) {
            author = (String)revisionProps.get("svn:author");
            String datestamp = (String)revisionProps.get("svn:date");
            message = (String)revisionProps.get("svn:log");
            Date date2 = date = datestamp != null ? SVNTimeUtil.parseDateString(datestamp) : null;
        }
        if (revNum > 0L && discoverChangedPaths) {
            FSRevisionRoot root = this.createRevisionRoot(revNum);
            changedPaths = root.detectChanged();
        }
        changedPaths = changedPaths == null ? new HashMap() : changedPaths;
        handler.handleLogEntry(new SVNLogEntry(changedPaths, revNum, author, date, message));
    }

    public void closeSession() {
    }

    public void setUseRootChache(boolean useRootCache) {
        this.myIsUseRootCache = useRootCache;
        if (!this.myIsUseRootCache) {
            this.myRootCache = null;
        }
    }

    public boolean isUseRootChache() {
        return this.myIsUseRootCache;
    }

    public void setPath(String path, String lockToken, long revision, boolean startEmpty) throws SVNException {
        FSRepository.assertValidRevision(revision);
        this.myReporterContext.writePathInfoToReportFile(path, null, lockToken, revision, startEmpty);
    }

    public void deletePath(String path) throws SVNException {
        this.myReporterContext.writePathInfoToReportFile(path, null, null, -1L, false);
    }

    public void linkPath(SVNURL url, String path, String lockToken, long revision, boolean startEmpty) throws SVNException {
        String reposLinkPath;
        FSRepository.assertValidRevision(revision);
        SVNURL reposRootURL = this.getRepositoryRoot(false);
        if (url.toDecodedString().indexOf(reposRootURL.toDecodedString()) == -1) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "''{0}''\nis not the same repository as\n''{1}''", new Object[]{url, reposRootURL});
            SVNErrorManager.error(err);
        }
        if ("".equals(reposLinkPath = url.toDecodedString().substring(reposRootURL.toDecodedString().length()))) {
            reposLinkPath = "/";
        }
        this.myReporterContext.writePathInfoToReportFile(path, reposLinkPath, lockToken, revision, startEmpty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishReport() throws SVNException {
        try {
            this.myReporterContext.drive();
        }
        finally {
            this.myReporterContext.dispose();
        }
    }

    public void abortReport() throws SVNException {
        if (this.myReporterContext != null) {
            this.myReporterContext.dispose();
        }
    }

    public static boolean isInvalidRevision(long revision) {
        return SVNRepository.isInvalidRevision(revision);
    }

    public static boolean isValidRevision(long revision) {
        return SVNRepository.isValidRevision(revision);
    }

    private FSClosestCopy closestCopy(FSRevisionRoot root, String path) throws SVNException {
        FSParentPath parentPath = root.openPath(path, true, true);
        SVNLocationEntry copyDstEntry = FSNodeHistory.findYoungestCopyroot(this.myReposRootDir, parentPath);
        if (copyDstEntry == null || copyDstEntry.getRevision() == 0L) {
            return null;
        }
        FSRevisionRoot copyDstRoot = this.myFSFS.createRevisionRoot(copyDstEntry.getRevision());
        if (copyDstRoot.checkNodeKind(path) == SVNNodeKind.NONE) {
            return null;
        }
        FSParentPath copyDstParentPath = copyDstRoot.openPath(path, true, true);
        FSRevisionNode copyDstNode = copyDstParentPath.getRevNode();
        if (!copyDstNode.getId().isRelated(parentPath.getRevNode().getId())) {
            return null;
        }
        long createdRev = copyDstNode.getCreatedRevision();
        if (createdRev == copyDstEntry.getRevision() && copyDstNode.getPredecessorId() == null) {
            return null;
        }
        return new FSClosestCopy(copyDstRoot, copyDstEntry.getPath());
    }

    private String getUserName() throws SVNException {
        if (this.getLocation().getUserInfo() != null && this.getLocation().getUserInfo().trim().length() > 0) {
            return this.getLocation().getUserInfo();
        }
        if (this.getAuthenticationManager() != null) {
            try {
                String realm = this.getRepositoryUUID(true);
                ISVNAuthenticationManager authManager = this.getAuthenticationManager();
                SVNAuthentication auth = authManager.getFirstAuthentication("svn.username", realm, this.getLocation());
                while (auth != null) {
                    String userName = auth.getUserName();
                    if (userName == null || "".equals(userName.trim())) {
                        userName = System.getProperty("user.name");
                    }
                    auth = new SVNUserNameAuthentication(userName, auth.isStorageAllowed());
                    if (userName != null && !"".equals(userName.trim())) {
                        authManager.acknowledgeAuthentication(true, "svn.username", realm, null, auth);
                        return auth.getUserName();
                    }
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.AUTHN_CREDS_UNAVAILABLE, "Empty user name is not allowed");
                    authManager.acknowledgeAuthentication(false, "svn.username", realm, err, auth);
                    auth = authManager.getNextAuthentication("svn.username", realm, this.getLocation());
                }
                SVNErrorManager.cancel("Authentication cancelled");
            }
            catch (SVNCancelException e) {
                throw e;
            }
            catch (SVNAuthenticationException e) {
            }
            catch (SVNException e) {
                throw e;
            }
        }
        return System.getProperty("user.name");
    }

    private FSRevisionRoot createRevisionRoot(long revision) {
        Long rev;
        FSRevisionRoot ret;
        if (!this.myIsUseRootCache) {
            return this.myFSFS.createRevisionRoot(revision);
        }
        if (this.myRootCache == null) {
            this.myRootCache = new FSSoftCache();
        }
        if ((ret = (FSRevisionRoot)this.myRootCache.fetch(rev = new Long(revision))) == null) {
            ret = this.myFSFS.createRevisionRoot(revision);
            this.myRootCache.put(rev, ret);
        }
        return ret;
    }

    private class LogPathInfo {
        private FSNodeHistory myHistory;

        private LogPathInfo(FSNodeHistory hist) {
            this.myHistory = hist;
        }

        public FSNodeHistory getHistory() {
            return this.myHistory;
        }

        public long getHistoryRevision() {
            return this.myHistory == null ? -1L : this.myHistory.getHistoryEntry().getRevision();
        }

        public void pickUpNextHistory(boolean strict, long start) throws SVNException {
            if (this.myHistory == null) {
                return;
            }
            FSNodeHistory tempHist = this.myHistory.fsHistoryPrev(!strict, FSRepository.this.myFSFS);
            if (tempHist == null) {
                this.myHistory = null;
                return;
            }
            this.myHistory = tempHist;
            if (this.myHistory.getHistoryEntry().getRevision() < start) {
                this.myHistory = null;
                return;
            }
        }

        public boolean checkHistory(long currentRev, boolean strict, long start) throws SVNException {
            if (this.myHistory == null) {
                return false;
            }
            if (this.getHistoryRevision() < currentRev) {
                return false;
            }
            this.pickUpNextHistory(strict, start);
            return true;
        }
    }
}

